/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DataWatcherObject<Float> DATA_WIDTH_ID = DataWatcher.defineId(Interaction.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Float> DATA_HEIGHT_ID = DataWatcher.defineId(Interaction.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Boolean> DATA_RESPONSE_ID = DataWatcher.defineId(Interaction.class, DataWatcherRegistry.BOOLEAN);
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_ATTACK = "attack";
    private static final String TAG_INTERACTION = "interaction";
    private static final String TAG_RESPONSE = "response";
    @Nullable
    public PlayerAction attack;
    @Nullable
    public PlayerAction interaction;

    public Interaction(EntityTypes<?> var0, World var1) {
        super(var0, var1);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_WIDTH_ID, Float.valueOf(1.0f));
        var0.define(DATA_HEIGHT_ID, Float.valueOf(1.0f));
        var0.define(DATA_RESPONSE_ID, false);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var02) {
        if (var02.contains(TAG_WIDTH, 99)) {
            this.setWidth(var02.getFloat(TAG_WIDTH));
        }
        if (var02.contains(TAG_HEIGHT, 99)) {
            this.setHeight(var02.getFloat(TAG_HEIGHT));
        }
        if (var02.contains(TAG_ATTACK)) {
            PlayerAction.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_ATTACK)).resultOrPartial(SystemUtils.prefix("Interaction entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var0 -> {
                this.attack = (PlayerAction)var0.getFirst();
            });
        } else {
            this.attack = null;
        }
        if (var02.contains(TAG_INTERACTION)) {
            PlayerAction.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_INTERACTION)).resultOrPartial(SystemUtils.prefix("Interaction entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var0 -> {
                this.interaction = (PlayerAction)var0.getFirst();
            });
        } else {
            this.interaction = null;
        }
        this.setResponse(var02.getBoolean(TAG_RESPONSE));
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putFloat(TAG_WIDTH, this.getWidth());
        var0.putFloat(TAG_HEIGHT, this.getHeight());
        if (this.attack != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.attack).ifSuccess(var1 -> var0.put(TAG_ATTACK, (NBTBase)var1));
        }
        if (this.interaction != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.interaction).ifSuccess(var1 -> var0.put(TAG_INTERACTION, (NBTBase)var1));
        }
        var0.putBoolean(TAG_RESPONSE, this.getResponse());
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_HEIGHT_ID.equals(var0) || DATA_WIDTH_ID.equals(var0)) {
            this.refreshDimensions();
        }
    }

    @Override
    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity var0) {
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            this.attack = new PlayerAction(var1.getUUID(), this.level().getGameTime());
            if (var1 instanceof EntityPlayer) {
                EntityPlayer var2 = (EntityPlayer)var1;
                CriterionTriggers.PLAYER_HURT_ENTITY.trigger(var2, this, var1.damageSources().generic(), 1.0f, 1.0f, false);
            }
            return !this.getResponse();
        }
        return false;
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return false;
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        if (this.level().isClientSide) {
            return this.getResponse() ? EnumInteractionResult.SUCCESS : EnumInteractionResult.CONSUME;
        }
        this.interaction = new PlayerAction(var0.getUUID(), this.level().getGameTime());
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nullable
    public EntityLiving getLastAttacker() {
        if (this.attack != null) {
            return this.level().getPlayerByUUID(this.attack.player());
        }
        return null;
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        if (this.interaction != null) {
            return this.level().getPlayerByUUID(this.interaction.player());
        }
        return null;
    }

    public void setWidth(float var0) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(var0));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float var0) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(var0));
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    public void setResponse(boolean var0) {
        this.entityData.set(DATA_RESPONSE_ID, var0);
    }

    public boolean getResponse() {
        return this.entityData.get(DATA_RESPONSE_ID);
    }

    private EntitySize getDimensions() {
        return EntitySize.scalable(this.getWidth(), this.getHeight());
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return this.getDimensions();
    }

    @Override
    protected AxisAlignedBB makeBoundingBox() {
        return this.getDimensions().makeBoundingBox(this.position());
    }

    public record PlayerAction(UUID player, long timestamp) {
        public static final Codec<PlayerAction> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(PlayerAction::player), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::timestamp)).apply((Applicative)var0, PlayerAction::new));
    }
}

