/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class GlowSquid
extends EntitySquid {
    private static final DataWatcherObject<Integer> DATA_DARK_TICKS_REMAINING = DataWatcher.defineId(GlowSquid.class, DataWatcherRegistry.INT);

    public GlowSquid(EntityTypes<? extends GlowSquid> var0, World var1) {
        super((EntityTypes<? extends EntitySquid>)var0, var1);
    }

    @Override
    protected ParticleParam getInkParticle() {
        return Particles.GLOW_SQUID_INK;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_DARK_TICKS_REMAINING, 0);
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.GLOW_SQUID.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    protected SoundEffect getSquirtSound() {
        return SoundEffects.GLOW_SQUID_SQUIRT;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.GLOW_SQUID_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.GLOW_SQUID_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.GLOW_SQUID_DEATH;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("DarkTicksRemaining", this.getDarkTicksRemaining());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setDarkTicks(var0.getInt("DarkTicksRemaining"));
    }

    @Override
    public void aiStep() {
        super.aiStep();
        int var0 = this.getDarkTicksRemaining();
        if (var0 > 0) {
            this.setDarkTicks(var0 - 1);
        }
        this.level().addParticle(Particles.GLOW, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        boolean var3 = super.hurtServer(var0, var1, var2);
        if (var3) {
            this.setDarkTicks(100);
        }
        return var3;
    }

    public void setDarkTicks(int var0) {
        this.entityData.set(DATA_DARK_TICKS_REMAINING, var0);
    }

    public int getDarkTicksRemaining() {
        return this.entityData.get(DATA_DARK_TICKS_REMAINING);
    }

    public static boolean checkGlowSquidSpawnRules(EntityTypes<? extends EntityLiving> var0, WorldAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var3.getY() <= var1.getSeaLevel() - 33 && var1.getRawBrightness(var3, 0) == 0 && var1.getBlockState(var3).is(Blocks.WATER);
    }
}

