/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.item.ItemStack;

public final class EnumItemSlot
extends Enum<EnumItemSlot>
implements INamable {
    public static final /* enum */ EnumItemSlot MAINHAND = new EnumItemSlot(Function.HAND, 0, 0, "mainhand");
    public static final /* enum */ EnumItemSlot OFFHAND = new EnumItemSlot(Function.HAND, 1, 5, "offhand");
    public static final /* enum */ EnumItemSlot FEET = new EnumItemSlot(Function.HUMANOID_ARMOR, 0, 1, 1, "feet");
    public static final /* enum */ EnumItemSlot LEGS = new EnumItemSlot(Function.HUMANOID_ARMOR, 1, 1, 2, "legs");
    public static final /* enum */ EnumItemSlot CHEST = new EnumItemSlot(Function.HUMANOID_ARMOR, 2, 1, 3, "chest");
    public static final /* enum */ EnumItemSlot HEAD = new EnumItemSlot(Function.HUMANOID_ARMOR, 3, 1, 4, "head");
    public static final /* enum */ EnumItemSlot BODY = new EnumItemSlot(Function.ANIMAL_ARMOR, 0, 1, 6, "body");
    public static final int NO_COUNT_LIMIT = 0;
    public static final List<EnumItemSlot> VALUES;
    public static final IntFunction<EnumItemSlot> BY_ID;
    public static final INamable.a<EnumItemSlot> CODEC;
    public static final StreamCodec<ByteBuf, EnumItemSlot> STREAM_CODEC;
    private final Function type;
    private final int index;
    private final int countLimit;
    private final int id;
    private final String name;
    private static final /* synthetic */ EnumItemSlot[] r;

    public static EnumItemSlot[] values() {
        return (EnumItemSlot[])r.clone();
    }

    public static EnumItemSlot valueOf(String var0) {
        return Enum.valueOf(EnumItemSlot.class, var0);
    }

    private EnumItemSlot(Function var2, int var3, int var4, int var5, String var6) {
        this.type = var2;
        this.index = var3;
        this.countLimit = var4;
        this.id = var5;
        this.name = var6;
    }

    private EnumItemSlot(Function var2, int var3, int var4, String var5) {
        this(var2, var3, 0, var4, var5);
    }

    public Function getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndex(int var0) {
        return var0 + this.index;
    }

    public ItemStack limit(ItemStack var0) {
        return this.countLimit > 0 ? var0.split(this.countLimit) : var0;
    }

    public int getId() {
        return this.id;
    }

    public int getFilterBit(int var0) {
        return this.id + var0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArmor() {
        return this.type == Function.HUMANOID_ARMOR || this.type == Function.ANIMAL_ARMOR;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public static EnumItemSlot byName(String var0) {
        EnumItemSlot var1 = CODEC.byName(var0);
        if (var1 != null) {
            return var1;
        }
        throw new IllegalArgumentException("Invalid slot '" + var0 + "'");
    }

    private static /* synthetic */ EnumItemSlot[] g() {
        return new EnumItemSlot[]{MAINHAND, OFFHAND, FEET, LEGS, CHEST, HEAD, BODY};
    }

    static {
        r = EnumItemSlot.g();
        VALUES = List.of(EnumItemSlot.values());
        BY_ID = ByIdMap.continuous(var0 -> var0.id, EnumItemSlot.values(), ByIdMap.a.ZERO);
        CODEC = INamable.fromEnum(EnumItemSlot::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, var0 -> var0.id);
    }

    public static final class Function
    extends Enum<Function> {
        public static final /* enum */ Function HAND = new Function();
        public static final /* enum */ Function HUMANOID_ARMOR = new Function();
        public static final /* enum */ Function ANIMAL_ARMOR = new Function();
        private static final /* synthetic */ Function[] d;

        public static Function[] values() {
            return (Function[])d.clone();
        }

        public static Function valueOf(String var0) {
            return Enum.valueOf(Function.class, var0);
        }

        private static /* synthetic */ Function[] a() {
            return new Function[]{HAND, HUMANOID_ARMOR, ANIMAL_ARMOR};
        }

        static {
            d = Function.a();
        }
    }
}

