/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Scoreboard;

public abstract sealed class ConversionType
extends Enum<ConversionType> {
    public static final /* enum */ ConversionType SINGLE = new ConversionType(true){

        @Override
        void convert(EntityInsentient var0, EntityInsentient var1, ConversionParams var2) {
            Entity var4;
            Entity var3 = var0.getFirstPassenger();
            var1.copyPosition(var0);
            var1.setDeltaMovement(var0.getDeltaMovement());
            if (var3 != null) {
                var3.stopRiding();
                var3.boardingCooldown = 0;
                for (Entity entity : var1.getPassengers()) {
                    entity.stopRiding();
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
                var3.startRiding(var1);
            }
            if ((var4 = var0.getVehicle()) != null) {
                var0.stopRiding();
                var1.startRiding(var4);
            }
            if (var2.keepEquipment()) {
                for (EnumItemSlot var6 : EnumItemSlot.VALUES) {
                    ItemStack var7 = var0.getItemBySlot(var6);
                    if (var7.isEmpty()) continue;
                    var1.setItemSlot(var6, var7.copyAndClear());
                    var1.setDropChance(var6, var0.getEquipmentDropChance(var6));
                }
            }
            var1.fallDistance = var0.fallDistance;
            var1.setSharedFlag(7, var0.isFallFlying());
            var1.lastHurtByPlayerTime = var0.lastHurtByPlayerTime;
            var1.hurtTime = var0.hurtTime;
            var1.yBodyRot = var0.yBodyRot;
            var1.setOnGround(var0.onGround());
            var0.getSleepingPos().ifPresent(var1::setSleepingPos);
            Entity entity = var0.getLeashHolder();
            if (entity != null) {
                var1.setLeashedTo(entity, true);
            }
            this.convertCommon(var0, var1, var2);
        }
    };
    public static final /* enum */ ConversionType SPLIT_ON_DEATH = new ConversionType(false){

        @Override
        void convert(EntityInsentient var0, EntityInsentient var1, ConversionParams var2) {
            Entity var4;
            Entity var3 = var0.getFirstPassenger();
            if (var3 != null) {
                var3.stopRiding();
            }
            if ((var4 = var0.getLeashHolder()) != null) {
                var0.dropLeash(true, true);
            }
            this.convertCommon(var0, var1, var2);
        }
    };
    private final boolean discardAfterConversion;
    private static final /* synthetic */ ConversionType[] d;

    public static ConversionType[] values() {
        return (ConversionType[])d.clone();
    }

    public static ConversionType valueOf(String var0) {
        return Enum.valueOf(ConversionType.class, var0);
    }

    ConversionType(boolean var2) {
        this.discardAfterConversion = var2;
    }

    public boolean shouldDiscardAfterConversion() {
        return this.discardAfterConversion;
    }

    abstract void convert(EntityInsentient var1, EntityInsentient var2, ConversionParams var3);

    void convertCommon(EntityInsentient var0, EntityInsentient var1, ConversionParams var2) {
        Object var5;
        Object var3;
        var1.setAbsorptionAmount(var0.getAbsorptionAmount());
        for (MobEffect mobEffect : var0.getActiveEffects()) {
            var1.addEffect(new MobEffect(mobEffect));
        }
        if (var0.isBaby()) {
            var1.setBaby(true);
        }
        if (var0 instanceof EntityAgeable) {
            var3 = (EntityAgeable)var0;
            if (var1 instanceof EntityAgeable) {
                EntityAgeable entityAgeable = (EntityAgeable)var1;
                entityAgeable.setAge(((EntityAgeable)var3).getAge());
                entityAgeable.forcedAge = ((EntityAgeable)var3).forcedAge;
                entityAgeable.forcedAgeTimer = ((EntityAgeable)var3).forcedAgeTimer;
            }
        }
        var3 = var0.getBrain();
        BehaviorController<?> behaviorController = var1.getBrain();
        if (((BehaviorController)var3).checkMemory(MemoryModuleType.ANGRY_AT, MemoryStatus.REGISTERED) && ((BehaviorController)var3).hasMemoryValue(MemoryModuleType.ANGRY_AT)) {
            behaviorController.setMemory(MemoryModuleType.ANGRY_AT, ((BehaviorController)var3).getMemory(MemoryModuleType.ANGRY_AT));
        }
        if (var2.preserveCanPickUpLoot()) {
            var1.setCanPickUpLoot(var0.canPickUpLoot());
        }
        var1.setLeftHanded(var0.isLeftHanded());
        var1.setNoAi(var0.isNoAi());
        if (var0.isPersistenceRequired()) {
            var1.setPersistenceRequired();
        }
        if (var0.hasCustomName()) {
            var1.setCustomName(var0.getCustomName());
            var1.setCustomNameVisible(var0.isCustomNameVisible());
        }
        var1.setSharedFlagOnFire(var0.isOnFire());
        var1.setInvulnerable(var0.isInvulnerable());
        var1.setNoGravity(var0.isNoGravity());
        var1.setPortalCooldown(var0.getPortalCooldown());
        var1.setSilent(var0.isSilent());
        var0.getTags().forEach(var1::addTag);
        if (var2.team() != null) {
            var5 = var1.level().getScoreboard();
            ((Scoreboard)var5).addPlayerToTeam(var1.getStringUUID(), var2.team());
            if (var0.getTeam() != null && var0.getTeam() == var2.team()) {
                ((Scoreboard)var5).removePlayerFromTeam(var0.getStringUUID(), var0.getTeam());
            }
        }
        if (var0 instanceof EntityZombie && ((EntityZombie)(var5 = (EntityZombie)var0)).canBreakDoors() && var1 instanceof EntityZombie) {
            EntityZombie var6 = (EntityZombie)var1;
            var6.setCanBreakDoors(true);
        }
    }

    private static /* synthetic */ ConversionType[] b() {
        return new ConversionType[]{SINGLE, SPLIT_ON_DEATH};
    }

    static {
        d = ConversionType.b();
    }
}

