/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.function.ToIntFunction;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

class InfestedMobEffect
extends MobEffectList {
    private final float chanceToSpawn;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected InfestedMobEffect(MobEffectInfo var0, int var1, float var2, ToIntFunction<RandomSource> var3) {
        super(var0, var1, Particles.INFESTED);
        this.chanceToSpawn = var2;
        this.spawnedCount = var3;
    }

    @Override
    public void onMobHurt(WorldServer var0, EntityLiving var1, int var2, DamageSource var3, float var4) {
        if (var1.getRandom().nextFloat() <= this.chanceToSpawn) {
            int var5 = this.spawnedCount.applyAsInt(var1.getRandom());
            for (int var6 = 0; var6 < var5; ++var6) {
                this.spawnSilverfish(var0, var1, var1.getX(), var1.getY() + (double)var1.getBbHeight() / 2.0, var1.getZ());
            }
        }
    }

    private void spawnSilverfish(WorldServer var0, EntityLiving var1, double var2, double var4, double var6) {
        EntitySilverfish var8 = EntityTypes.SILVERFISH.create(var0, EntitySpawnReason.TRIGGERED);
        if (var8 == null) {
            return;
        }
        RandomSource var9 = var1.getRandom();
        float var10 = 1.5707964f;
        float var11 = MathHelper.randomBetween(var9, -1.5707964f, 1.5707964f);
        Vector3f var12 = var1.getLookAngle().toVector3f().mul(0.3f).mul(1.0f, 1.5f, 1.0f).rotateY(var11);
        var8.moveTo(var2, var4, var6, var0.getRandom().nextFloat() * 360.0f, 0.0f);
        var8.setDeltaMovement(new Vec3D(var12));
        var0.addFreshEntity(var8);
        var8.playSound(SoundEffects.SILVERFISH_HURT);
    }
}

