/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;

public abstract class NamedEntityWriteReadFix
extends DataFix {
    private final String name;
    private final String entityName;
    private final DSL.TypeReference type;

    public NamedEntityWriteReadFix(Schema var0, boolean var1, String var2, DSL.TypeReference var3, String var4) {
        super(var0, var1);
        this.name = var2;
        this.type = var3;
        this.entityName = var4;
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(this.type);
        Type var1 = this.getInputSchema().getChoiceType(this.type, this.entityName);
        Type var2 = this.getOutputSchema().getType(this.type);
        Type var3 = this.getOutputSchema().getChoiceType(this.type, this.entityName);
        OpticFinder var4 = DSL.namedChoice((String)this.entityName, (Type)var1);
        Type<?> var5 = ExtraDataFixUtils.patchSubType(var1, var0, var2);
        return this.fix(var0, var2, var4, var3, var5);
    }

    private <S, T, A, B> TypeRewriteRule fix(Type<S> var0, Type<T> var1, OpticFinder<A> var2, Type<B> var3, Type<?> var42) {
        return this.fixTypeEverywhere(this.name, var0, var1, var4 -> var5 -> {
            Typed var6 = new Typed(var0, var4, var5);
            return var6.update(var2, var3, var3 -> {
                Type<?> var42 = new Typed(var42, var4, var3);
                return SystemUtils.writeAndReadTypedOrThrow(var42, var3, this::fix).getValue();
            }).getValue();
        });
    }

    protected abstract <T> Dynamic<T> fix(Dynamic<T> var1);
}

