/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.UtilColor;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ExtraCodecs {
    public static final Codec<JsonElement> JSON = ExtraCodecs.converter(JsonOps.INSTANCE);
    public static final Codec<Object> JAVA = ExtraCodecs.converter(JavaOps.INSTANCE);
    public static final Codec<Vector3f> VECTOR3F = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 3).map(var0 -> new Vector3f(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue())), var0 -> List.of(Float.valueOf(var0.x()), Float.valueOf(var0.y()), Float.valueOf(var0.z())));
    public static final Codec<Vector4f> VECTOR4F = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 4).map(var0 -> new Vector4f(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue(), ((Float)var0.get(3)).floatValue())), var0 -> List.of(Float.valueOf(var0.x()), Float.valueOf(var0.y()), Float.valueOf(var0.z()), Float.valueOf(var0.w())));
    public static final Codec<Quaternionf> QUATERNIONF_COMPONENTS = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 4).map(var0 -> new Quaternionf(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue(), ((Float)var0.get(3)).floatValue()).normalize()), var0 -> List.of(Float.valueOf(var0.x), Float.valueOf(var0.y), Float.valueOf(var0.z), Float.valueOf(var0.w)));
    public static final Codec<AxisAngle4f> AXISANGLE4F = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("angle").forGetter(var0 -> Float.valueOf(var0.angle)), (App)VECTOR3F.fieldOf("axis").forGetter(var0 -> new Vector3f(var0.x, var0.y, var0.z))).apply((Applicative)var02, AxisAngle4f::new));
    public static final Codec<Quaternionf> QUATERNIONF = Codec.withAlternative(QUATERNIONF_COMPONENTS, (Codec)AXISANGLE4F.xmap(Quaternionf::new, AxisAngle4f::new));
    public static final Codec<Matrix4f> MATRIX4F = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 16).map(var0 -> {
        Matrix4f var1 = new Matrix4f();
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            var1.setRowColumn(var2 >> 2, var2 & 3, ((Float)var0.get(var2)).floatValue());
        }
        return var1.determineProperties();
    }), var0 -> {
        FloatArrayList var1 = new FloatArrayList(16);
        for (int var2 = 0; var2 < 16; ++var2) {
            var1.add(var0.getRowColumn(var2 >> 2, var2 & 3));
        }
        return var1;
    });
    public static final Codec<Integer> RGB_COLOR_CODEC = Codec.withAlternative((Codec)Codec.INT, VECTOR3F, var0 -> ARGB.colorFromFloat(1.0f, var0.x(), var0.y(), var0.z()));
    public static final Codec<Integer> ARGB_COLOR_CODEC = Codec.withAlternative((Codec)Codec.INT, VECTOR4F, var0 -> ARGB.colorFromFloat(var0.w(), var0.x(), var0.y(), var0.z()));
    public static final Codec<Integer> UNSIGNED_BYTE = Codec.BYTE.flatComapMap(UnsignedBytes::toInt, var0 -> {
        if (var0 > 255) {
            return DataResult.error(() -> "Unsigned byte was too large: " + var0 + " > 255");
        }
        return DataResult.success((Object)var0.byteValue());
    });
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, var0 -> "Value must be non-negative: " + var0);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, var0 -> "Value must be positive: " + var0);
    public static final Codec<Float> NON_NEGATIVE_FLOAT = ExtraCodecs.floatRangeMinInclusiveWithMessage(0.0f, Float.MAX_VALUE, var0 -> "Value must be non-negative: " + var0);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, var0 -> "Value must be positive: " + var0);
    public static final Codec<Pattern> PATTERN = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)Pattern.compile(var0));
        }
        catch (PatternSyntaxException var1) {
            return DataResult.error(() -> "Invalid regex pattern '" + var0 + "': " + var1.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> INSTANT_ISO8601 = ExtraCodecs.temporalCodec(DateTimeFormatter.ISO_INSTANT).xmap(Instant::from, Function.identity());
    public static final Codec<byte[]> BASE64_STRING = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)var0));
        }
        catch (IllegalArgumentException var1) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, var0 -> Base64.getEncoder().encodeToString((byte[])var0));
    public static final Codec<String> ESCAPED_STRING = Codec.STRING.comapFlatMap(var0 -> DataResult.success((Object)StringEscapeUtils.unescapeJava((String)var0)), StringEscapeUtils::escapeJava);
    public static final Codec<c> TAG_OR_ELEMENT_ID = Codec.STRING.comapFlatMap(var02 -> var02.startsWith("#") ? MinecraftKey.read(var02.substring(1)).map(var0 -> new c((MinecraftKey)var0, true)) : MinecraftKey.read(var02).map(var0 -> new c((MinecraftKey)var0, false)), c::decoratedId);
    public static final Function<Optional<Long>, OptionalLong> toOptionalLong = var0 -> var0.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> fromOptionalLong = var0 -> var0.isPresent() ? Optional.of(var0.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> BIT_SET = Codec.LONG_STREAM.xmap(var0 -> BitSet.valueOf(var0.toArray()), var0 -> Arrays.stream(var0.toLongArray()));
    private static final Codec<Property> PROPERTY = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.STRING.fieldOf("name").forGetter(Property::name), (App)Codec.STRING.fieldOf("value").forGetter(Property::value), (App)Codec.STRING.lenientOptionalFieldOf("signature").forGetter(var0 -> Optional.ofNullable(var0.signature()))).apply((Applicative)var02, (var0, var1, var2) -> new Property(var0, var1, (String)var2.orElse(null))));
    public static final Codec<PropertyMap> PROPERTY_MAP = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)PROPERTY.listOf()).xmap(var0 -> {
        PropertyMap var13 = new PropertyMap();
        var0.ifLeft(var12 -> var12.forEach((var1, var2) -> {
            for (String var4 : var2) {
                var13.put(var1, (Object)new Property(var1, var4));
            }
        })).ifRight(var1 -> {
            for (Property var3 : var1) {
                var13.put((Object)var3.name(), (Object)var3);
            }
        });
        return var13;
    }, var0 -> Either.right(var0.values().stream().toList()));
    public static final Codec<String> PLAYER_NAME = Codec.string((int)0, (int)16).validate(var0 -> {
        if (UtilColor.isValidPlayerName(var0)) {
            return DataResult.success((Object)var0);
        }
        return DataResult.error(() -> "Player name contained disallowed characters: '" + var0 + "'");
    });
    private static final MapCodec<GameProfile> GAME_PROFILE_WITHOUT_PROPERTIES = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)UUIDUtil.AUTHLIB_CODEC.fieldOf("id").forGetter(GameProfile::getId), (App)PLAYER_NAME.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)var0, GameProfile::new));
    public static final Codec<GameProfile> GAME_PROFILE = RecordCodecBuilder.create(var02 -> var02.group((App)GAME_PROFILE_WITHOUT_PROPERTIES.forGetter(Function.identity()), (App)PROPERTY_MAP.lenientOptionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)var02, (var0, var12) -> {
        var12.forEach((var1, var2) -> var0.getProperties().put(var1, var2));
        return var0;
    }));
    public static final Codec<String> NON_EMPTY_STRING = Codec.STRING.validate(var0 -> var0.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)var0));
    public static final Codec<Integer> CODEPOINT = Codec.STRING.comapFlatMap(var0 -> {
        int[] var1 = var0.codePoints().toArray();
        if (var1.length != 1) {
            return DataResult.error(() -> "Expected one codepoint, got: " + var0);
        }
        return DataResult.success((Object)var1[0]);
    }, Character::toString);
    public static final Codec<String> RESOURCE_PATH_CODEC = Codec.STRING.validate(var0 -> {
        if (!MinecraftKey.isValidPath(var0)) {
            return DataResult.error(() -> "Invalid string to use as a resource path element: " + var0);
        }
        return DataResult.success((Object)var0);
    });

    public static <T> Codec<T> converter(DynamicOps<T> var0) {
        return Codec.PASSTHROUGH.xmap(var1 -> var1.convert(var0).getValue(), var1 -> new Dynamic(var0, var1));
    }

    public static <P, I> Codec<I> intervalCodec(Codec<P> var0, String var13, String var22, BiFunction<P, P, DataResult<I>> var32, Function<I, P> var4, Function<I, P> var5) {
        Codec var6 = Codec.list(var0).comapFlatMap(var12 -> SystemUtils.fixedSize(var12, 2).flatMap(var1 -> {
            Object var2 = var1.get(0);
            Object var3 = var1.get(1);
            return (DataResult)var32.apply(var2, var3);
        }), var2 -> ImmutableList.of(var4.apply(var2), var5.apply(var2)));
        Codec var7 = RecordCodecBuilder.create(var3 -> var3.group((App)var0.fieldOf(var13).forGetter(Pair::getFirst), (App)var0.fieldOf(var22).forGetter(Pair::getSecond)).apply((Applicative)var3, Pair::of)).comapFlatMap(var1 -> (DataResult)var32.apply(var1.getFirst(), var1.getSecond()), var2 -> Pair.of(var4.apply(var2), var5.apply(var2)));
        Codec var8 = Codec.withAlternative((Codec)var6, (Codec)var7);
        return Codec.either(var0, (Codec)var8).comapFlatMap(var12 -> (DataResult)var12.map(var1 -> (DataResult)var32.apply(var1, var1), DataResult::success), var2 -> {
            Object var4;
            Object var3 = var4.apply(var2);
            if (Objects.equals(var3, var4 = var5.apply(var2))) {
                return Either.left(var3);
            }
            return Either.right((Object)var2);
        });
    }

    public static <A> Codec.ResultFunction<A> orElsePartial(final A var0) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> var02, T var1, DataResult<Pair<A, T>> var2) {
                MutableObject var3 = new MutableObject();
                Optional var4 = var2.resultOrPartial(arg_0 -> ((MutableObject)var3).setValue(arg_0));
                if (var4.isPresent()) {
                    return var2;
                }
                return DataResult.error(() -> "(" + (String)var3.getValue() + " -> using default)", (Object)Pair.of((Object)var0, var1));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> var02, A var1, DataResult<T> var2) {
                return var2;
            }

            public String toString() {
                return "OrElsePartial[" + String.valueOf(var0) + "]";
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> var0, IntFunction<E> var12, int var22) {
        return Codec.INT.flatXmap(var1 -> Optional.ofNullable(var12.apply((int)var1)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + var1)), var2 -> {
            int var3 = var0.applyAsInt(var2);
            return var3 == var22 ? DataResult.error(() -> "Element with unknown id: " + String.valueOf(var2)) : DataResult.success((Object)var3);
        });
    }

    public static <E> Codec<E> orCompressed(final Codec<E> var0, final Codec<E> var1) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E var02, DynamicOps<T> var12, T var2) {
                if (var12.compressMaps()) {
                    return var1.encode(var02, var12, var2);
                }
                return var0.encode(var02, var12, var2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> var02, T var12) {
                if (var02.compressMaps()) {
                    return var1.decode(var02, var12);
                }
                return var0.decode(var02, var12);
            }

            public String toString() {
                return String.valueOf(var0) + " orCompressed " + String.valueOf(var1);
            }
        };
    }

    public static <E> MapCodec<E> orCompressed(final MapCodec<E> var0, final MapCodec<E> var1) {
        return new MapCodec<E>(){

            public <T> RecordBuilder<T> encode(E var02, DynamicOps<T> var12, RecordBuilder<T> var2) {
                if (var12.compressMaps()) {
                    return var1.encode(var02, var12, var2);
                }
                return var0.encode(var02, var12, var2);
            }

            public <T> DataResult<E> decode(DynamicOps<T> var02, MapLike<T> var12) {
                if (var02.compressMaps()) {
                    return var1.decode(var02, var12);
                }
                return var0.decode(var02, var12);
            }

            public <T> Stream<T> keys(DynamicOps<T> var02) {
                return var1.keys(var02);
            }

            public String toString() {
                return String.valueOf(var0) + " orCompressed " + String.valueOf(var1);
            }
        };
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> var0, final Function<E, Lifecycle> var1, final Function<E, Lifecycle> var2) {
        return var0.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> var0, T var12, DataResult<Pair<E, T>> var22) {
                return var22.result().map(var2 -> var22.setLifecycle((Lifecycle)var1.apply(var2.getFirst()))).orElse(var22);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> var0, E var12, DataResult<T> var22) {
                return var22.setLifecycle((Lifecycle)var2.apply(var12));
            }

            public String toString() {
                return "WithLifecycle[" + String.valueOf(var1) + " " + String.valueOf(var2) + "]";
            }
        });
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> var0, Function<E, Lifecycle> var1) {
        return ExtraCodecs.overrideLifecycle(var0, var1, var1);
    }

    public static <K, V> b<K, V> strictUnboundedMap(Codec<K> var0, Codec<V> var1) {
        return new b<K, V>(var0, var1);
    }

    private static Codec<Integer> intRangeWithMessage(int var0, int var1, Function<Integer, String> var2) {
        return Codec.INT.validate(var3 -> {
            if (var3.compareTo(var0) >= 0 && var3.compareTo(var1) <= 0) {
                return DataResult.success((Object)var3);
            }
            return DataResult.error(() -> (String)var2.apply((Integer)var3));
        });
    }

    public static Codec<Integer> intRange(int var0, int var1) {
        return ExtraCodecs.intRangeWithMessage(var0, var1, var2 -> "Value must be within range [" + var0 + ";" + var1 + "]: " + var2);
    }

    private static Codec<Float> floatRangeMinInclusiveWithMessage(float var0, float var1, Function<Float, String> var2) {
        return Codec.FLOAT.validate(var3 -> {
            if (var3.compareTo(Float.valueOf(var0)) >= 0 && var3.compareTo(Float.valueOf(var1)) <= 0) {
                return DataResult.success((Object)var3);
            }
            return DataResult.error(() -> (String)var2.apply((Float)var3));
        });
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float var0, float var1, Function<Float, String> var2) {
        return Codec.FLOAT.validate(var3 -> {
            if (var3.compareTo(Float.valueOf(var0)) > 0 && var3.compareTo(Float.valueOf(var1)) <= 0) {
                return DataResult.success((Object)var3);
            }
            return DataResult.error(() -> (String)var2.apply((Float)var3));
        });
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> var02) {
        return var02.validate(var0 -> var0.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)var0));
    }

    public static <T> Codec<HolderSet<T>> nonEmptyHolderSet(Codec<HolderSet<T>> var02) {
        return var02.validate(var0 -> {
            if (var0.unwrap().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error(() -> "List must have contents");
            }
            return DataResult.success((Object)var0);
        });
    }

    public static <M extends Map<?, ?>> Codec<M> nonEmptyMap(Codec<M> var02) {
        return var02.validate(var0 -> var0.isEmpty() ? DataResult.error(() -> "Map must have contents") : DataResult.success((Object)var0));
    }

    public static <E> MapCodec<E> retrieveContext(Function<DynamicOps<?>, DataResult<E>> var0) {
        class A
        extends MapCodec<E> {
            final /* synthetic */ Function a;

            A(Function function) {
                this.a = function;
            }

            public <T> RecordBuilder<T> encode(E var0, DynamicOps<T> var1, RecordBuilder<T> var2) {
                return var2;
            }

            public <T> DataResult<E> decode(DynamicOps<T> var0, MapLike<T> var1) {
                return (DataResult)this.a.apply(var0);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + String.valueOf(this.a) + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> var0) {
                return Stream.empty();
            }
        }
        return new A(var0);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> ensureHomogenous(Function<E, T> var0) {
        return var1 -> {
            Iterator var2 = var1.iterator();
            if (var2.hasNext()) {
                Object var3 = var0.apply(var2.next());
                while (var2.hasNext()) {
                    Object var4 = var2.next();
                    Object var5 = var0.apply(var4);
                    if (var5 == var3) continue;
                    return DataResult.error(() -> "Mixed type list: element " + String.valueOf(var4) + " had type " + String.valueOf(var5) + ", but list is of type " + String.valueOf(var3));
                }
            }
            return DataResult.success((Object)var1, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> catchDecoderException(final Codec<A> var0) {
        return Codec.of(var0, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var02, T var1) {
                try {
                    return var0.decode(var02, var1);
                }
                catch (Exception var2) {
                    return DataResult.error(() -> "Caught exception decoding " + String.valueOf(var1) + ": " + var2.getMessage());
                }
            }
        });
    }

    public static Codec<TemporalAccessor> temporalCodec(DateTimeFormatter var0) {
        return Codec.STRING.comapFlatMap(var1 -> {
            try {
                return DataResult.success((Object)var0.parse((CharSequence)var1));
            }
            catch (Exception var2) {
                return DataResult.error(var2::getMessage);
            }
        }, var0::format);
    }

    public static MapCodec<OptionalLong> asOptionalLong(MapCodec<Optional<Long>> var0) {
        return var0.xmap(toOptionalLong, fromOptionalLong);
    }

    public static <K, V> Codec<Map<K, V>> sizeLimitedMap(Codec<Map<K, V>> var0, int var12) {
        return var0.validate(var1 -> {
            if (var1.size() > var12) {
                return DataResult.error(() -> "Map is too long: " + var1.size() + ", expected range [0-" + var12 + "]");
            }
            return DataResult.success((Object)var1);
        });
    }

    public static <T> Codec<Object2BooleanMap<T>> object2BooleanMap(Codec<T> var0) {
        return Codec.unboundedMap(var0, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Object2ObjectOpenHashMap::new);
    }

    @Deprecated
    public static <K, V> MapCodec<V> dispatchOptionalValue(final String var0, final String var1, final Codec<K> var2, final Function<? super V, ? extends K> var3, final Function<? super K, ? extends Codec<? extends V>> var4) {
        return new MapCodec<V>(){

            public <T> Stream<T> keys(DynamicOps<T> var02) {
                return Stream.of(var02.createString(var0), var02.createString(var1));
            }

            public <T> DataResult<V> decode(DynamicOps<T> var02, MapLike<T> var12) {
                Object var22 = var12.get(var0);
                if (var22 == null) {
                    return DataResult.error(() -> "Missing \"" + var0 + "\" in: " + String.valueOf(var12));
                }
                return var2.decode(var02, var22).flatMap(var4 -> {
                    Object var5 = Objects.requireNonNullElseGet(var12.get(var1), () -> ((DynamicOps)var02).emptyMap());
                    return ((Codec)var4.apply(var4.getFirst())).decode(var02, var5).map(Pair::getFirst);
                });
            }

            public <T> RecordBuilder<T> encode(V var02, DynamicOps<T> var12, RecordBuilder<T> var22) {
                Object var32 = var3.apply(var02);
                var22.add(var0, var2.encodeStart(var12, var32));
                DataResult<T> var42 = this.encode((Codec)var4.apply(var32), var02, var12);
                if (var42.result().isEmpty() || !Objects.equals(var42.result().get(), var12.emptyMap())) {
                    var22.add(var1, var42);
                }
                return var22;
            }

            private <T, V2 extends V> DataResult<T> encode(Codec<V2> var02, V var12, DynamicOps<T> var22) {
                return var02.encodeStart(var22, var12);
            }
        };
    }

    public static <A> Codec<Optional<A>> optionalEmptyMap(final Codec<A> var0) {
        return new Codec<Optional<A>>(){

            public <T> DataResult<Pair<Optional<A>, T>> decode(DynamicOps<T> var02, T var1) {
                if (7.isEmptyMap(var02, var1)) {
                    return DataResult.success((Object)Pair.of(Optional.empty(), var1));
                }
                return var0.decode(var02, var1).map(var0 -> var0.mapFirst(Optional::of));
            }

            private static <T> boolean isEmptyMap(DynamicOps<T> var02, T var1) {
                Optional var2 = var02.getMap(var1).result();
                return var2.isPresent() && ((MapLike)var2.get()).entries().findAny().isEmpty();
            }

            public <T> DataResult<T> encode(Optional<A> var02, DynamicOps<T> var1, T var2) {
                if (var02.isEmpty()) {
                    return DataResult.success((Object)var1.emptyMap());
                }
                return var0.encode(var02.get(), var1, var2);
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.encode((Optional)object, dynamicOps, object2);
            }
        };
    }

    public record b<K, V>(Codec<K> keyCodec, Codec<V> elementCodec) implements Codec<Map<K, V>>,
    BaseMapCodec<K, V>
    {
        public <T> DataResult<Map<K, V>> decode(DynamicOps<T> var0, MapLike<T> var1) {
            ImmutableMap.Builder var2 = ImmutableMap.builder();
            for (Pair var4 : var1.entries().toList()) {
                String var9;
                DataResult var6;
                DataResult var5 = this.keyCodec().parse(var0, var4.getFirst());
                DataResult var7 = var5.apply2stable(Pair::of, var6 = this.elementCodec().parse(var0, var4.getSecond()));
                Optional var8 = var7.error();
                if (var8.isPresent()) {
                    var9 = ((DataResult.Error)var8.get()).message();
                    return DataResult.error(() -> {
                        if (var5.result().isPresent()) {
                            return "Map entry '" + String.valueOf(var5.result().get()) + "' : " + var9;
                        }
                        return var9;
                    });
                }
                if (var7.result().isPresent()) {
                    var9 = (Pair)var7.result().get();
                    var2.put(var9.getFirst(), var9.getSecond());
                    continue;
                }
                return DataResult.error(() -> "Empty or invalid map contents are not allowed");
            }
            ImmutableMap var3 = var2.build();
            return DataResult.success((Object)var3);
        }

        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> var0, T var12) {
            return var0.getMap(var12).setLifecycle(Lifecycle.stable()).flatMap(var1 -> this.decode(var0, (Object)var1)).map(var1 -> Pair.of((Object)var1, (Object)var12));
        }

        public <T> DataResult<T> encode(Map<K, V> var0, DynamicOps<T> var1, T var2) {
            return this.encode(var0, var1, var1.mapBuilder()).build(var2);
        }

        @Override
        public String toString() {
            return "StrictUnboundedMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.elementCodec) + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Map)object, dynamicOps, object2);
        }
    }

    public record c(MinecraftKey id, boolean tag) {
        @Override
        public String toString() {
            return this.decoratedId();
        }

        private String decoratedId() {
            return this.tag ? "#" + String.valueOf(this.id) : this.id.toString();
        }
    }
}

