/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson<T>
extends ResourceDataAbstract<Map<MinecraftKey, T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DynamicOps<JsonElement> ops;
    private final Codec<T> codec;
    private final String directory;

    protected ResourceDataJson(HolderLookup.a var0, Codec<T> var1, String var2) {
        this(var0.createSerializationContext(JsonOps.INSTANCE), var1, var2);
    }

    protected ResourceDataJson(Codec<T> var0, String var1) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, var0, var1);
    }

    private ResourceDataJson(DynamicOps<JsonElement> var0, Codec<T> var1, String var2) {
        this.ops = var0;
        this.codec = var1;
        this.directory = var2;
    }

    @Override
    protected Map<MinecraftKey, T> prepare(IResourceManager var0, GameProfilerFiller var1) {
        HashMap var2 = new HashMap();
        ResourceDataJson.scanDirectory(var0, this.directory, this.ops, this.codec, var2);
        return var2;
    }

    public static <T> void scanDirectory(IResourceManager var0, String var1, DynamicOps<JsonElement> var22, Codec<T> var3, Map<MinecraftKey, T> var4) {
        FileToIdConverter var5 = FileToIdConverter.json(var1);
        for (Map.Entry<MinecraftKey, IResource> var7 : var5.listMatchingResources(var0).entrySet()) {
            MinecraftKey var8 = var7.getKey();
            MinecraftKey var9 = var5.fileToId(var8);
            try {
                BufferedReader var10 = var7.getValue().openAsReader();
                try {
                    var3.parse(var22, (Object)JsonParser.parseReader((Reader)var10)).ifSuccess(var2 -> {
                        if (var4.putIfAbsent(var9, var2) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(var9));
                        }
                    }).ifError(var2 -> LOGGER.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{var9, var8, var2}));
                }
                finally {
                    if (var10 == null) continue;
                    ((Reader)var10).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var10) {
                LOGGER.error("Couldn't parse data file '{}' from '{}'", new Object[]{var9, var8, var10});
            }
        }
    }

    @Override
    protected /* synthetic */ Object prepare(IResourceManager iResourceManager, GameProfilerFiller gameProfilerFiller) {
        return this.prepare(iResourceManager, gameProfilerFiller);
    }
}

