/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Comparator;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkCoordIntPair;

public class TicketType<T> {
    private final String name;
    private final Comparator<T> comparator;
    public long timeout;
    public static final TicketType<Unit> START = TicketType.create("start", (var0, var1) -> 0);
    public static final TicketType<Unit> DRAGON = TicketType.create("dragon", (var0, var1) -> 0);
    public static final TicketType<ChunkCoordIntPair> PLAYER = TicketType.create("player", Comparator.comparingLong(ChunkCoordIntPair::toLong));
    public static final TicketType<ChunkCoordIntPair> FORCED = TicketType.create("forced", Comparator.comparingLong(ChunkCoordIntPair::toLong));
    public static final TicketType<BlockPosition> PORTAL = TicketType.create("portal", BaseBlockPosition::compareTo, 300);
    public static final TicketType<ChunkCoordIntPair> ENDER_PEARL = TicketType.create("ender_pearl", Comparator.comparingLong(ChunkCoordIntPair::toLong), 40);
    public static final TicketType<Integer> POST_TELEPORT = TicketType.create("post_teleport", Integer::compareTo, 5);
    public static final TicketType<ChunkCoordIntPair> UNKNOWN = TicketType.create("unknown", Comparator.comparingLong(ChunkCoordIntPair::toLong), 1);

    public static <T> TicketType<T> create(String var0, Comparator<T> var1) {
        return new TicketType<T>(var0, var1, 0L);
    }

    public static <T> TicketType<T> create(String var0, Comparator<T> var1, int var2) {
        return new TicketType<T>(var0, var1, var2);
    }

    protected TicketType(String var0, Comparator<T> var1, long var2) {
        this.name = var0;
        this.comparator = var1;
        this.timeout = var2;
    }

    public String toString() {
        return this.name;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public long timeout() {
        return this.timeout;
    }
}

