/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.jetbrains.annotations.Nullable;

public class ThrottlingChunkTaskDispatcher
extends ChunkTaskDispatcher {
    private final LongSet chunkPositionsInExecution = new LongOpenHashSet();
    private final int maxChunksInExecution;
    private final String executorSchedulerName;

    public ThrottlingChunkTaskDispatcher(TaskScheduler<Runnable> var0, Executor var1, int var2) {
        super(var0, var1);
        this.maxChunksInExecution = var2;
        this.executorSchedulerName = var0.name();
    }

    @Override
    protected void onRelease(long var0) {
        this.chunkPositionsInExecution.remove(var0);
    }

    @Override
    @Nullable
    protected ChunkTaskQueue.a popTasks() {
        return this.chunkPositionsInExecution.size() < this.maxChunksInExecution ? super.popTasks() : null;
    }

    @Override
    protected void scheduleForExecution(ChunkTaskQueue.a var0) {
        this.chunkPositionsInExecution.add(var0.chunkPos());
        super.scheduleForExecution(var0);
    }

    @VisibleForTesting
    public String getDebugStatus() {
        return this.executorSchedulerName + "=[" + this.chunkPositionsInExecution.stream().map(var0 -> var0 + ":" + String.valueOf(new ChunkCoordIntPair((long)var0))).collect(Collectors.joining(",")) + "], s=" + this.sleeping;
    }
}

