/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.util.TimeRange;

public class TickCommand {
    private static final float MAX_TICKRATE = 10000.0f;
    private static final String DEFAULT_TICKRATE = String.valueOf(20);

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("tick").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.literal("query").executes(var0 -> TickCommand.tickQuery((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("rate").then(net.minecraft.commands.CommandDispatcher.argument("rate", FloatArgumentType.floatArg((float)1.0f, (float)10000.0f)).suggests((var0, var1) -> ICompletionProvider.suggest(new String[]{DEFAULT_TICKRATE}, var1)).executes(var0 -> TickCommand.setTickingRate((CommandListenerWrapper)var0.getSource(), FloatArgumentType.getFloat((CommandContext)var0, (String)"rate")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("step").executes(var0 -> TickCommand.step((CommandListenerWrapper)var0.getSource(), 1))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> TickCommand.stopStepping((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time(1)).suggests((var0, var1) -> ICompletionProvider.suggest(new String[]{"1t", "1s"}, var1)).executes(var0 -> TickCommand.step((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("sprint").then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> TickCommand.stopSprinting((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time(1)).suggests((var0, var1) -> ICompletionProvider.suggest(new String[]{"60s", "1d", "3d"}, var1)).executes(var0 -> TickCommand.sprint((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time")))))).then(net.minecraft.commands.CommandDispatcher.literal("unfreeze").executes(var0 -> TickCommand.setFreeze((CommandListenerWrapper)var0.getSource(), false)))).then(net.minecraft.commands.CommandDispatcher.literal("freeze").executes(var0 -> TickCommand.setFreeze((CommandListenerWrapper)var0.getSource(), true))));
    }

    private static String nanosToMilisString(long var0) {
        return String.format(Locale.ROOT, "%.1f", Float.valueOf((float)var0 / (float)TimeRange.NANOSECONDS_PER_MILLISECOND));
    }

    private static int setTickingRate(CommandListenerWrapper var0, float var1) {
        ServerTickRateManager var2 = var0.getServer().tickRateManager();
        var2.setTickRate(var1);
        String var3 = String.format(Locale.ROOT, "%.1f", Float.valueOf(var1));
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.rate.success", var3), true);
        return (int)var1;
    }

    private static int tickQuery(CommandListenerWrapper var0) {
        Object var5;
        ServerTickRateManager var1 = var0.getServer().tickRateManager();
        String var2 = TickCommand.nanosToMilisString(var0.getServer().getAverageTickTimeNanos());
        float var3 = var1.tickrate();
        String var4 = String.format(Locale.ROOT, "%.1f", Float.valueOf(var3));
        if (var1.isSprinting()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.status.sprinting"), false);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.query.rate.sprinting", var4, var2), false);
        } else {
            if (var1.isFrozen()) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.status.frozen"), false);
            } else if (var1.nanosecondsPerTick() < var0.getServer().getAverageTickTimeNanos()) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.status.lagging"), false);
            } else {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.status.running"), false);
            }
            var5 = TickCommand.nanosToMilisString(var1.nanosecondsPerTick());
            var0.sendSuccess(() -> TickCommand.a(var4, var2, (String)var5), false);
        }
        var5 = Arrays.copyOf(var0.getServer().getTickTimesNanos(), var0.getServer().getTickTimesNanos().length);
        Arrays.sort((long[])var5);
        String var6 = TickCommand.nanosToMilisString((long)var5[((Object)var5).length / 2]);
        String var7 = TickCommand.nanosToMilisString((long)var5[(int)((double)((Object)var5).length * 0.95)]);
        String var8 = TickCommand.nanosToMilisString((long)var5[(int)((double)((Object)var5).length * 0.99)]);
        var0.sendSuccess(() -> TickCommand.a(var6, var7, var8, (long[])var5), false);
        return (int)var3;
    }

    private static int sprint(CommandListenerWrapper var0, int var1) {
        boolean var2 = var0.getServer().tickRateManager().requestGameToSprint(var1);
        if (var2) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.sprint.stop.success"), true);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.status.sprinting"), true);
        return 1;
    }

    private static int setFreeze(CommandListenerWrapper var0, boolean var1) {
        ServerTickRateManager var2 = var0.getServer().tickRateManager();
        if (var1) {
            if (var2.isSprinting()) {
                var2.stopSprinting();
            }
            if (var2.isSteppingForward()) {
                var2.stopStepping();
            }
        }
        var2.setFrozen(var1);
        if (var1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.status.frozen"), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.status.running"), true);
        }
        return var1 ? 1 : 0;
    }

    private static int step(CommandListenerWrapper var0, int var1) {
        ServerTickRateManager var2 = var0.getServer().tickRateManager();
        boolean var3 = var2.stepGameIfPaused(var1);
        if (var3) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.step.success", var1), true);
        } else {
            var0.sendFailure(IChatBaseComponent.translatable("commands.tick.step.fail"));
        }
        return 1;
    }

    private static int stopStepping(CommandListenerWrapper var0) {
        ServerTickRateManager var1 = var0.getServer().tickRateManager();
        boolean var2 = var1.stopStepping();
        if (var2) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.step.stop.success"), true);
            return 1;
        }
        var0.sendFailure(IChatBaseComponent.translatable("commands.tick.step.stop.fail"));
        return 0;
    }

    private static int stopSprinting(CommandListenerWrapper var0) {
        ServerTickRateManager var1 = var0.getServer().tickRateManager();
        boolean var2 = var1.stopSprinting();
        if (var2) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.sprint.stop.success"), true);
            return 1;
        }
        var0.sendFailure(IChatBaseComponent.translatable("commands.tick.sprint.stop.fail"));
        return 0;
    }

    private static /* synthetic */ IChatBaseComponent a(String var0, String var1, String var2, long[] var3) {
        return IChatBaseComponent.translatable("commands.tick.query.percentiles", var0, var1, var2, var3.length);
    }

    private static /* synthetic */ IChatBaseComponent a(String var0, String var1, String var2) {
        return IChatBaseComponent.translatable("commands.tick.query.rate.running", var0, var1, var2);
    }
}

