/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final List<ResourceKey<TrimPattern>> VANILLA_TRIM_PATTERNS = List.of(TrimPatterns.SENTRY, TrimPatterns.DUNE, TrimPatterns.COAST, TrimPatterns.WILD, TrimPatterns.WARD, TrimPatterns.EYE, TrimPatterns.VEX, TrimPatterns.TIDE, TrimPatterns.SNOUT, TrimPatterns.RIB, TrimPatterns.SPIRE, TrimPatterns.WAYFINDER, TrimPatterns.SHAPER, TrimPatterns.SILENCE, TrimPatterns.RAISER, TrimPatterns.HOST, TrimPatterns.FLOW, TrimPatterns.BOLT);
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.QUARTZ, TrimMaterials.IRON, TrimMaterials.NETHERITE, TrimMaterials.REDSTONE, TrimMaterials.COPPER, TrimMaterials.GOLD, TrimMaterials.EMERALD, TrimMaterials.DIAMOND, TrimMaterials.LAPIS, TrimMaterials.AMETHYST);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = SystemUtils.createIndexLookup(VANILLA_TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = SystemUtils.createIndexLookup(VANILLA_TRIM_MATERIALS);

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spawn_armor_trims").requires(var0 -> var0.hasPermission(2))).executes(var0 -> SpawnArmorTrimsCommand.spawnArmorTrims((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getPlayerOrException())));
    }

    private static int spawnArmorTrims(CommandListenerWrapper var02, EntityHuman var1) {
        World var2 = var1.level();
        NonNullList<ArmorTrim> var3 = NonNullList.create();
        HolderLookup.b var4 = var2.registryAccess().lookupOrThrow(Registries.TRIM_PATTERN);
        HolderLookup.b var5 = var2.registryAccess().lookupOrThrow(Registries.TRIM_MATERIAL);
        HolderLookup<Item> var6 = var2.holderLookup(Registries.ITEM);
        Map<MinecraftKey, List<Item>> var7 = var6.listElements().map(Holder.c::value).filter(var0 -> {
            Equippable var1 = var0.components().get(DataComponents.EQUIPPABLE);
            return var1 != null && var1.slot().getType() == EnumItemSlot.Function.HUMANOID_ARMOR && var1.model().isPresent();
        }).collect(Collectors.groupingBy(var0 -> var0.components().get(DataComponents.EQUIPPABLE).model().get()));
        var4.stream().sorted(Comparator.comparing(arg_0 -> SpawnArmorTrimsCommand.a((IRegistry)var4, arg_0))).forEachOrdered(arg_0 -> SpawnArmorTrimsCommand.a((IRegistry)var5, var3, (IRegistry)var4, arg_0));
        BlockPosition var8 = var1.blockPosition().relative(var1.getDirection(), 5);
        int var9 = var7.size() - 1;
        double var10 = 3.0;
        int var12 = 0;
        int var13 = 0;
        for (ArmorTrim var15 : var3) {
            for (List<Item> var17 : var7.values()) {
                double var18 = (double)var8.getX() + 0.5 - (double)(var12 % var5.size()) * 3.0;
                double var20 = (double)var8.getY() + 0.5 + (double)(var13 % var9) * 3.0;
                double var22 = (double)var8.getZ() + 0.5 + (double)(var12 / var5.size() * 10);
                EntityArmorStand var24 = new EntityArmorStand(var2, var18, var20, var22);
                var24.setYRot(180.0f);
                var24.setNoGravity(true);
                for (Item var26 : var17) {
                    Equippable var27 = Objects.requireNonNull(var26.components().get(DataComponents.EQUIPPABLE));
                    ItemStack var28 = new ItemStack(var26);
                    var28.set(DataComponents.TRIM, var15);
                    var24.setItemSlot(var27.slot(), var28);
                    if (var28.is(Items.TURTLE_HELMET)) {
                        var24.setCustomName(var15.pattern().value().copyWithStyle(var15.material()).copy().append(" ").append(var15.material().value().description()));
                        var24.setCustomNameVisible(true);
                        continue;
                    }
                    var24.setInvisible(true);
                }
                var2.addFreshEntity(var24);
                ++var13;
            }
            ++var12;
        }
        var02.sendSuccess(() -> IChatBaseComponent.literal("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }

    private static /* synthetic */ void a(IRegistry var0, NonNullList var12, IRegistry var2, TrimPattern var3) {
        var0.stream().sorted(Comparator.comparing(var1 -> TRIM_MATERIAL_ORDER.applyAsInt(var0.getResourceKey(var1).orElse(null)))).forEachOrdered(var4 -> var12.add(new ArmorTrim(var0.wrapAsHolder(var4), var2.wrapAsHolder(var3))));
    }

    private static /* synthetic */ Integer a(IRegistry var0, TrimPattern var1) {
        return TRIM_PATTERN_ORDER.applyAsInt(var0.getResourceKey(var1).orElse(null));
    }
}

