/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagDataPack;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class CustomFunctionManager
implements IReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<IRegistry<CommandFunction<CommandListenerWrapper>>> TYPE_KEY = ResourceKey.createRegistryKey(MinecraftKey.withDefaultNamespace("function"));
    private static final FileToIdConverter LISTER = new FileToIdConverter(Registries.elementsDirPath(TYPE_KEY), ".mcfunction");
    private volatile Map<MinecraftKey, CommandFunction<CommandListenerWrapper>> functions = ImmutableMap.of();
    private final TagDataPack<CommandFunction<CommandListenerWrapper>> tagsLoader = new TagDataPack((var0, var1) -> this.getFunction(var0), Registries.tagsDirPath(TYPE_KEY));
    private volatile Map<MinecraftKey, List<CommandFunction<CommandListenerWrapper>>> tags = Map.of();
    private final int functionCompilationLevel;
    private final CommandDispatcher<CommandListenerWrapper> dispatcher;

    public Optional<CommandFunction<CommandListenerWrapper>> getFunction(MinecraftKey var0) {
        return Optional.ofNullable(this.functions.get(var0));
    }

    public Map<MinecraftKey, CommandFunction<CommandListenerWrapper>> getFunctions() {
        return this.functions;
    }

    public List<CommandFunction<CommandListenerWrapper>> getTag(MinecraftKey var0) {
        return this.tags.getOrDefault(var0, List.of());
    }

    public Iterable<MinecraftKey> getAvailableTags() {
        return this.tags.keySet();
    }

    public CustomFunctionManager(int var02, CommandDispatcher<CommandListenerWrapper> var12) {
        this.functionCompilationLevel = var02;
        this.dispatcher = var12;
    }

    @Override
    public CompletableFuture<Void> reload(IReloadListener.a var02, IResourceManager var1, Executor var2, Executor var3) {
        CompletableFuture<Map> var4 = CompletableFuture.supplyAsync(() -> this.tagsLoader.load(var1), var2);
        CompletionStage var5 = CompletableFuture.supplyAsync(() -> LISTER.listMatchingResources(var1), var2).thenCompose(var12 -> {
            HashMap var22 = Maps.newHashMap();
            CommandListenerWrapper var3 = new CommandListenerWrapper(ICommandListener.NULL, Vec3D.ZERO, Vec2F.ZERO, null, this.functionCompilationLevel, "", CommonComponents.EMPTY, null, null);
            for (Map.Entry var5 : var12.entrySet()) {
                MinecraftKey var6 = (MinecraftKey)var5.getKey();
                MinecraftKey var7 = LISTER.fileToId(var6);
                var22.put(var7, CompletableFuture.supplyAsync(() -> {
                    List<String> var3 = CustomFunctionManager.readLines((IResource)var5.getValue());
                    return CommandFunction.fromLines(var7, this.dispatcher, var3, var3);
                }, var2));
            }
            CompletableFuture[] var4 = var22.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(var4).handle((var1, var2) -> var22);
        });
        return ((CompletableFuture)((CompletableFuture)var4.thenCombine(var5, Pair::of)).thenCompose(var02::wait)).thenAcceptAsync(var0 -> {
            Map var12 = (Map)var0.getSecond();
            ImmutableMap.Builder var2 = ImmutableMap.builder();
            var12.forEach((var1, var22) -> ((CompletableFuture)var22.handle((var2, var3) -> {
                if (var3 != null) {
                    LOGGER.error("Failed to load function {}", var1, var3);
                } else {
                    var2.put(var1, var2);
                }
                return null;
            })).join());
            this.functions = var2.build();
            this.tags = this.tagsLoader.build((Map)var0.getFirst());
        }, var3);
    }

    private static List<String> readLines(IResource var0) {
        List<String> list;
        block8: {
            BufferedReader var1 = var0.openAsReader();
            try {
                list = var1.lines().toList();
                if (var1 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var1 != null) {
                        try {
                            var1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException var12) {
                    throw new CompletionException(var12);
                }
            }
            var1.close();
        }
        return list;
    }
}

