/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class AutoRecipe<R extends IRecipe<?>> {
    private static final int ITEM_NOT_FOUND = -1;
    private final PlayerInventory inventory;
    private final a<R> menu;
    private final boolean useMaxItems;
    private final int gridWidth;
    private final int gridHeight;
    private final List<Slot> inputGridSlots;
    private final List<Slot> slotsToClear;

    public static <I extends RecipeInput, R extends IRecipe<I>> ContainerRecipeBook.a placeRecipe(a<R> var0, int var1, int var2, List<Slot> var3, List<Slot> var4, PlayerInventory var5, RecipeHolder<R> var6, boolean var7, boolean var8) {
        AutoRecipe<R> var9 = new AutoRecipe<R>(var0, var5, var7, var1, var2, var3, var4);
        if (!var8 && !var9.testClearGrid()) {
            return ContainerRecipeBook.a.NOTHING;
        }
        StackedItemContents var10 = new StackedItemContents();
        var5.fillStackedContents(var10);
        var0.fillCraftSlotsStackedContents(var10);
        return var9.tryPlaceRecipe(var6, var10);
    }

    private AutoRecipe(a<R> var0, PlayerInventory var1, boolean var2, int var3, int var4, List<Slot> var5, List<Slot> var6) {
        this.menu = var0;
        this.inventory = var1;
        this.useMaxItems = var2;
        this.gridWidth = var3;
        this.gridHeight = var4;
        this.inputGridSlots = var5;
        this.slotsToClear = var6;
    }

    private ContainerRecipeBook.a tryPlaceRecipe(RecipeHolder<R> var0, StackedItemContents var1) {
        if (var1.canCraft((IRecipe<?>)var0.value(), null)) {
            this.placeRecipe(var0, var1);
            this.inventory.setChanged();
            return ContainerRecipeBook.a.NOTHING;
        }
        this.clearGrid();
        this.inventory.setChanged();
        return ContainerRecipeBook.a.PLACE_GHOST_RECIPE;
    }

    private void clearGrid() {
        for (Slot var1 : this.slotsToClear) {
            ItemStack var2 = var1.getItem().copy();
            this.inventory.placeItemBackInInventory(var2, false);
            var1.set(var2);
        }
        this.menu.clearCraftingContent();
    }

    private void placeRecipe(RecipeHolder<R> var02, StackedItemContents var1) {
        Object var6;
        boolean var22 = this.menu.recipeMatches(var02);
        int var32 = var1.getBiggestCraftableStack((IRecipe<?>)var02.value(), null);
        if (var22) {
            for (Slot slot : this.inputGridSlots) {
                var6 = slot.getItem();
                if (((ItemStack)var6).isEmpty() || Math.min(var32, ((ItemStack)var6).getMaxStackSize()) >= ((ItemStack)var6).getCount() + 1) continue;
                return;
            }
        }
        int var42 = this.calculateAmountToCraft(var32, var22);
        ArrayList arrayList = new ArrayList();
        if (var1.canCraft((IRecipe<?>)var02.value(), var42, arrayList::add)) {
            var6 = arrayList.stream().mapToInt(var0 -> ((Item)var0.value()).getDefaultMaxStackSize()).min();
            if (((OptionalInt)var6).isPresent()) {
                var42 = Math.min(var42, ((OptionalInt)var6).getAsInt());
            }
            arrayList.clear();
            if (var1.canCraft((IRecipe<?>)var02.value(), var42, arrayList::add)) {
                this.clearGrid();
                int var7 = var42;
                PlaceRecipeHelper.placeRecipe(this.gridWidth, this.gridHeight, var02.value(), var02.value().placementInfo().slotInfo(), (var2, var3, var4, var5) -> {
                    if (var2.isEmpty()) {
                        return;
                    }
                    Slot var6 = this.inputGridSlots.get(var3);
                    int var7 = ((PlacementInfo.a)var2.get()).placerOutputPosition();
                    int var8 = var7;
                    while (var8 > 0) {
                        Holder var9 = (Holder)arrayList.get(var7);
                        var8 = this.moveItemToGrid(var6, var9, var8);
                        if (var8 != -1) continue;
                        return;
                    }
                });
            }
        }
    }

    private int calculateAmountToCraft(int var0, boolean var1) {
        if (this.useMaxItems) {
            return var0;
        }
        if (var1) {
            int var2 = Integer.MAX_VALUE;
            for (Slot var4 : this.inputGridSlots) {
                ItemStack var5 = var4.getItem();
                if (var5.isEmpty() || var2 <= var5.getCount()) continue;
                var2 = var5.getCount();
            }
            if (var2 != Integer.MAX_VALUE) {
                ++var2;
            }
            return var2;
        }
        return 1;
    }

    private int moveItemToGrid(Slot var0, Holder<Item> var1, int var2) {
        int var5;
        int var3 = this.inventory.findSlotMatchingCraftingIngredient(var1);
        if (var3 == -1) {
            return -1;
        }
        ItemStack var4 = this.inventory.getItem(var3);
        if (var2 < var4.getCount()) {
            this.inventory.removeItem(var3, var2);
            var5 = var2;
        } else {
            this.inventory.removeItemNoUpdate(var3);
            var5 = var4.getCount();
        }
        if (var0.getItem().isEmpty()) {
            var0.set(var4.copyWithCount(var5));
        } else {
            var0.getItem().grow(var5);
        }
        return var2 - var5;
    }

    private boolean testClearGrid() {
        ArrayList var0 = Lists.newArrayList();
        int var1 = this.getAmountOfFreeSlotsInInventory();
        for (Slot var3 : this.inputGridSlots) {
            ItemStack var4 = var3.getItem().copy();
            if (var4.isEmpty()) continue;
            int var5 = this.inventory.getSlotWithRemainingSpace(var4);
            if (var5 == -1 && var0.size() <= var1) {
                for (ItemStack var7 : var0) {
                    if (!ItemStack.isSameItem(var7, var4) || var7.getCount() == var7.getMaxStackSize() || var7.getCount() + var4.getCount() > var7.getMaxStackSize()) continue;
                    var7.grow(var4.getCount());
                    var4.setCount(0);
                    break;
                }
                if (var4.isEmpty()) continue;
                if (var0.size() < var1) {
                    var0.add(var4);
                    continue;
                }
                return false;
            }
            if (var5 != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int var0 = 0;
        for (ItemStack var2 : this.inventory.items) {
            if (!var2.isEmpty()) continue;
            ++var0;
        }
        return var0;
    }

    public static interface a<T extends IRecipe<?>> {
        public void fillCraftSlotsStackedContents(StackedItemContents var1);

        public void clearCraftingContent();

        public boolean recipeMatches(RecipeHolder<T> var1);
    }
}

