/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.FormattedString;
import net.minecraft.world.level.ChunkCoordIntPair;

public interface IChatBaseComponent
extends Message,
IChatFormatted {
    public ChatModifier getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String getString(int var0) {
        StringBuilder var1 = new StringBuilder();
        this.visit(var2 -> {
            int var3 = var0 - var1.length();
            if (var3 <= 0) {
                return STOP_ITERATION;
            }
            var1.append(var2.length() <= var3 ? var2 : var2.substring(0, var3));
            return Optional.empty();
        });
        return var1.toString();
    }

    public List<IChatBaseComponent> getSiblings();

    @Nullable
    default public String tryCollapseToString() {
        ComponentContents componentContents = this.getContents();
        if (componentContents instanceof LiteralContents) {
            LiteralContents var0 = (LiteralContents)componentContents;
            if (this.getSiblings().isEmpty() && this.getStyle().isEmpty()) {
                return var0.text();
            }
        }
        return null;
    }

    default public IChatMutableComponent plainCopy() {
        return IChatMutableComponent.create(this.getContents());
    }

    default public IChatMutableComponent copy() {
        return new IChatMutableComponent(this.getContents(), new ArrayList<IChatBaseComponent>(this.getSiblings()), this.getStyle());
    }

    public FormattedString getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(IChatFormatted.b<T> var0, ChatModifier var1) {
        ChatModifier var2 = this.getStyle().applyTo(var1);
        Optional<T> var3 = this.getContents().visit(var0, var2);
        if (var3.isPresent()) {
            return var3;
        }
        for (IChatBaseComponent var5 : this.getSiblings()) {
            Optional<T> var6 = var5.visit(var0, var2);
            if (!var6.isPresent()) continue;
            return var6;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> visit(IChatFormatted.a<T> var0) {
        Optional<T> var1 = this.getContents().visit(var0);
        if (var1.isPresent()) {
            return var1;
        }
        for (IChatBaseComponent var3 : this.getSiblings()) {
            Optional<T> var4 = var3.visit(var0);
            if (!var4.isPresent()) continue;
            return var4;
        }
        return Optional.empty();
    }

    default public List<IChatBaseComponent> toFlatList() {
        return this.toFlatList(ChatModifier.EMPTY);
    }

    default public List<IChatBaseComponent> toFlatList(ChatModifier var0) {
        ArrayList var12 = Lists.newArrayList();
        this.visit((var1, var2) -> {
            if (!var2.isEmpty()) {
                var12.add(IChatBaseComponent.literal(var2).withStyle(var1));
            }
            return Optional.empty();
        }, var0);
        return var12;
    }

    default public boolean contains(IChatBaseComponent var0) {
        List<IChatBaseComponent> var2;
        if (this.equals(var0)) {
            return true;
        }
        List<IChatBaseComponent> var1 = this.toFlatList();
        return Collections.indexOfSubList(var1, var2 = var0.toFlatList(this.getStyle())) != -1;
    }

    public static IChatBaseComponent nullToEmpty(@Nullable String var0) {
        return var0 != null ? IChatBaseComponent.literal(var0) : CommonComponents.EMPTY;
    }

    public static IChatMutableComponent literal(String var0) {
        return IChatMutableComponent.create(LiteralContents.create(var0));
    }

    public static IChatMutableComponent translatable(String var0) {
        return IChatMutableComponent.create(new TranslatableContents(var0, null, TranslatableContents.NO_ARGS));
    }

    public static IChatMutableComponent translatable(String var0, Object ... var1) {
        return IChatMutableComponent.create(new TranslatableContents(var0, null, var1));
    }

    public static IChatMutableComponent translatableEscape(String var0, Object ... var1) {
        for (int var2 = 0; var2 < var1.length; ++var2) {
            Object var3 = var1[var2];
            if (TranslatableContents.isAllowedPrimitiveArgument(var3) || var3 instanceof IChatBaseComponent) continue;
            var1[var2] = String.valueOf(var3);
        }
        return IChatBaseComponent.translatable(var0, var1);
    }

    public static IChatMutableComponent translatableWithFallback(String var0, @Nullable String var1) {
        return IChatMutableComponent.create(new TranslatableContents(var0, var1, TranslatableContents.NO_ARGS));
    }

    public static IChatMutableComponent translatableWithFallback(String var0, @Nullable String var1, Object ... var2) {
        return IChatMutableComponent.create(new TranslatableContents(var0, var1, var2));
    }

    public static IChatMutableComponent empty() {
        return IChatMutableComponent.create(LiteralContents.EMPTY);
    }

    public static IChatMutableComponent keybind(String var0) {
        return IChatMutableComponent.create(new KeybindContents(var0));
    }

    public static IChatMutableComponent nbt(String var0, boolean var1, Optional<IChatBaseComponent> var2, DataSource var3) {
        return IChatMutableComponent.create(new NbtContents(var0, var1, var2, var3));
    }

    public static IChatMutableComponent score(SelectorPattern var0, String var1) {
        return IChatMutableComponent.create(new ScoreContents((Either<SelectorPattern, String>)Either.left((Object)var0), var1));
    }

    public static IChatMutableComponent score(String var0, String var1) {
        return IChatMutableComponent.create(new ScoreContents((Either<SelectorPattern, String>)Either.right((Object)var0), var1));
    }

    public static IChatMutableComponent selector(SelectorPattern var0, Optional<IChatBaseComponent> var1) {
        return IChatMutableComponent.create(new SelectorContents(var0, var1));
    }

    public static IChatBaseComponent translationArg(Date var0) {
        return IChatBaseComponent.literal(var0.toString());
    }

    public static IChatBaseComponent translationArg(Message var0) {
        IChatBaseComponent iChatBaseComponent;
        if (var0 instanceof IChatBaseComponent) {
            IChatBaseComponent var1 = (IChatBaseComponent)var0;
            iChatBaseComponent = var1;
        } else {
            iChatBaseComponent = IChatBaseComponent.literal(var0.getString());
        }
        return iChatBaseComponent;
    }

    public static IChatBaseComponent translationArg(UUID var0) {
        return IChatBaseComponent.literal(var0.toString());
    }

    public static IChatBaseComponent translationArg(MinecraftKey var0) {
        return IChatBaseComponent.literal(var0.toString());
    }

    public static IChatBaseComponent translationArg(ChunkCoordIntPair var0) {
        return IChatBaseComponent.literal(var0.toString());
    }

    public static IChatBaseComponent translationArg(URI var0) {
        return IChatBaseComponent.literal(var0.toString());
    }

    public static class b
    implements JsonDeserializer<IChatMutableComponent>,
    JsonSerializer<IChatBaseComponent> {
        private final HolderLookup.a registries;

        public b(HolderLookup.a var0) {
            this.registries = var0;
        }

        public IChatMutableComponent deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            return ChatSerializer.deserialize(var0, this.registries);
        }

        public JsonElement serialize(IChatBaseComponent var0, Type var1, JsonSerializationContext var2) {
            return ChatSerializer.serialize(var0, this.registries);
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((IChatBaseComponent)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    public static class ChatSerializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private ChatSerializer() {
        }

        static IChatMutableComponent deserialize(JsonElement var0, HolderLookup.a var1) {
            return (IChatMutableComponent)ComponentSerialization.CODEC.parse(var1.createSerializationContext(JsonOps.INSTANCE), (Object)var0).getOrThrow(JsonParseException::new);
        }

        static JsonElement serialize(IChatBaseComponent var0, HolderLookup.a var1) {
            return (JsonElement)ComponentSerialization.CODEC.encodeStart(var1.createSerializationContext(JsonOps.INSTANCE), (Object)var0).getOrThrow(JsonParseException::new);
        }

        public static String toJson(IChatBaseComponent var0, HolderLookup.a var1) {
            return GSON.toJson(ChatSerializer.serialize(var0, var1));
        }

        @Nullable
        public static IChatMutableComponent fromJson(String var0, HolderLookup.a var1) {
            JsonElement var2 = JsonParser.parseString((String)var0);
            if (var2 == null) {
                return null;
            }
            return ChatSerializer.deserialize(var2, var1);
        }

        @Nullable
        public static IChatMutableComponent fromJson(@Nullable JsonElement var0, HolderLookup.a var1) {
            if (var0 == null) {
                return null;
            }
            return ChatSerializer.deserialize(var0, var1);
        }

        @Nullable
        public static IChatMutableComponent fromJsonLenient(String var0, HolderLookup.a var1) {
            JsonReader var2 = new JsonReader((Reader)new StringReader(var0));
            var2.setLenient(true);
            JsonElement var3 = JsonParser.parseReader((JsonReader)var2);
            if (var3 == null) {
                return null;
            }
            return ChatSerializer.deserialize(var3, var1);
        }
    }
}

