/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;

public class GameTestHarnessTestFunctionArgument
implements ArgumentType<GameTestHarnessTestFunction> {
    private static final Collection<String> EXAMPLES = Arrays.asList("techtests.piston", "techtests");

    public GameTestHarnessTestFunction parse(StringReader var0) throws CommandSyntaxException {
        String var1 = var0.readUnquotedString();
        Optional<GameTestHarnessTestFunction> var2 = GameTestHarnessRegistry.findTestFunction(var1);
        if (var2.isPresent()) {
            return var2.get();
        }
        IChatMutableComponent var3 = IChatBaseComponent.literal("No such test: " + var1);
        throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)var3), (Message)var3);
    }

    public static GameTestHarnessTestFunctionArgument testFunctionArgument() {
        return new GameTestHarnessTestFunctionArgument();
    }

    public static GameTestHarnessTestFunction getTestFunction(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (GameTestHarnessTestFunction)var0.getArgument(var1, GameTestHarnessTestFunction.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return GameTestHarnessTestFunctionArgument.suggestTestFunction(var0, var1);
    }

    public static <S> CompletableFuture<Suggestions> suggestTestFunction(CommandContext<S> var0, SuggestionsBuilder var1) {
        Stream<String> var2 = GameTestHarnessRegistry.getAllTestFunctions().stream().map(GameTestHarnessTestFunction::testName);
        return ICompletionProvider.suggest(var2, var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

