/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplays;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplays;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.EnchantmentProviderTypes;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBindings;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> LOADERS = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> WRITABLE_REGISTRY = new RegistryMaterials(ResourceKey.createRegistryKey(Registries.ROOT_REGISTRY_NAME), Lifecycle.stable());
    public static final RegistryBlocks<GameEvent> GAME_EVENT = BuiltInRegistries.registerDefaulted(Registries.GAME_EVENT, "step", GameEvent::bootstrap);
    public static final IRegistry<SoundEffect> SOUND_EVENT = BuiltInRegistries.registerSimple(Registries.SOUND_EVENT, var0 -> SoundEffects.ITEM_PICKUP);
    public static final RegistryBlocks<FluidType> FLUID = BuiltInRegistries.registerDefaultedWithIntrusiveHolders(Registries.FLUID, "empty", var0 -> FluidTypes.EMPTY);
    public static final IRegistry<MobEffectList> MOB_EFFECT = BuiltInRegistries.registerSimple(Registries.MOB_EFFECT, MobEffects::bootstrap);
    public static final RegistryBlocks<Block> BLOCK = BuiltInRegistries.registerDefaultedWithIntrusiveHolders(Registries.BLOCK, "air", var0 -> Blocks.AIR);
    public static final RegistryBlocks<EntityTypes<?>> ENTITY_TYPE = BuiltInRegistries.registerDefaultedWithIntrusiveHolders(Registries.ENTITY_TYPE, "pig", var0 -> EntityTypes.PIG);
    public static final RegistryBlocks<Item> ITEM = BuiltInRegistries.registerDefaultedWithIntrusiveHolders(Registries.ITEM, "air", var0 -> Items.AIR);
    public static final IRegistry<PotionRegistry> POTION = BuiltInRegistries.registerSimple(Registries.POTION, Potions::bootstrap);
    public static final IRegistry<Particle<?>> PARTICLE_TYPE = BuiltInRegistries.registerSimple(Registries.PARTICLE_TYPE, var0 -> Particles.BLOCK);
    public static final IRegistry<TileEntityTypes<?>> BLOCK_ENTITY_TYPE = BuiltInRegistries.registerSimpleWithIntrusiveHolders(Registries.BLOCK_ENTITY_TYPE, var0 -> TileEntityTypes.FURNACE);
    public static final IRegistry<MinecraftKey> CUSTOM_STAT = BuiltInRegistries.registerSimple(Registries.CUSTOM_STAT, var0 -> StatisticList.JUMP);
    public static final RegistryBlocks<ChunkStatus> CHUNK_STATUS = BuiltInRegistries.registerDefaulted(Registries.CHUNK_STATUS, "empty", var0 -> ChunkStatus.EMPTY);
    public static final IRegistry<DefinedStructureRuleTestType<?>> RULE_TEST = BuiltInRegistries.registerSimple(Registries.RULE_TEST, var0 -> DefinedStructureRuleTestType.ALWAYS_TRUE_TEST);
    public static final IRegistry<RuleBlockEntityModifierType<?>> RULE_BLOCK_ENTITY_MODIFIER = BuiltInRegistries.registerSimple(Registries.RULE_BLOCK_ENTITY_MODIFIER, var0 -> RuleBlockEntityModifierType.PASSTHROUGH);
    public static final IRegistry<PosRuleTestType<?>> POS_RULE_TEST = BuiltInRegistries.registerSimple(Registries.POS_RULE_TEST, var0 -> PosRuleTestType.ALWAYS_TRUE_TEST);
    public static final IRegistry<Containers<?>> MENU = BuiltInRegistries.registerSimple(Registries.MENU, var0 -> Containers.ANVIL);
    public static final IRegistry<Recipes<?>> RECIPE_TYPE = BuiltInRegistries.registerSimple(Registries.RECIPE_TYPE, var0 -> Recipes.CRAFTING);
    public static final IRegistry<RecipeSerializer<?>> RECIPE_SERIALIZER = BuiltInRegistries.registerSimple(Registries.RECIPE_SERIALIZER, var0 -> RecipeSerializer.SHAPELESS_RECIPE);
    public static final IRegistry<AttributeBase> ATTRIBUTE = BuiltInRegistries.registerSimple(Registries.ATTRIBUTE, GenericAttributes::bootstrap);
    public static final IRegistry<PositionSourceType<?>> POSITION_SOURCE_TYPE = BuiltInRegistries.registerSimple(Registries.POSITION_SOURCE_TYPE, var0 -> PositionSourceType.BLOCK);
    public static final IRegistry<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPE = BuiltInRegistries.registerSimple(Registries.COMMAND_ARGUMENT_TYPE, ArgumentTypeInfos::bootstrap);
    public static final IRegistry<StatisticWrapper<?>> STAT_TYPE = BuiltInRegistries.registerSimple(Registries.STAT_TYPE, var0 -> StatisticList.ITEM_USED);
    public static final RegistryBlocks<VillagerType> VILLAGER_TYPE = BuiltInRegistries.registerDefaulted(Registries.VILLAGER_TYPE, "plains", var0 -> VillagerType.PLAINS);
    public static final RegistryBlocks<VillagerProfession> VILLAGER_PROFESSION = BuiltInRegistries.registerDefaulted(Registries.VILLAGER_PROFESSION, "none", var0 -> VillagerProfession.NONE);
    public static final IRegistry<VillagePlaceType> POINT_OF_INTEREST_TYPE = BuiltInRegistries.registerSimple(Registries.POINT_OF_INTEREST_TYPE, PoiTypes::bootstrap);
    public static final RegistryBlocks<MemoryModuleType<?>> MEMORY_MODULE_TYPE = BuiltInRegistries.registerDefaulted(Registries.MEMORY_MODULE_TYPE, "dummy", var0 -> MemoryModuleType.DUMMY);
    public static final RegistryBlocks<SensorType<?>> SENSOR_TYPE = BuiltInRegistries.registerDefaulted(Registries.SENSOR_TYPE, "dummy", var0 -> SensorType.DUMMY);
    public static final IRegistry<Schedule> SCHEDULE = BuiltInRegistries.registerSimple(Registries.SCHEDULE, var0 -> Schedule.EMPTY);
    public static final IRegistry<Activity> ACTIVITY = BuiltInRegistries.registerSimple(Registries.ACTIVITY, var0 -> Activity.IDLE);
    public static final IRegistry<LootEntryType> LOOT_POOL_ENTRY_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_POOL_ENTRY_TYPE, var0 -> LootEntries.EMPTY);
    public static final IRegistry<LootItemFunctionType<?>> LOOT_FUNCTION_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_FUNCTION_TYPE, var0 -> LootItemFunctions.SET_COUNT);
    public static final IRegistry<LootItemConditionType> LOOT_CONDITION_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_CONDITION_TYPE, var0 -> LootItemConditions.INVERTED);
    public static final IRegistry<LootNumberProviderType> LOOT_NUMBER_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_NUMBER_PROVIDER_TYPE, var0 -> NumberProviders.CONSTANT);
    public static final IRegistry<LootNbtProviderType> LOOT_NBT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_NBT_PROVIDER_TYPE, var0 -> NbtProviders.CONTEXT);
    public static final IRegistry<LootScoreProviderType> LOOT_SCORE_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_SCORE_PROVIDER_TYPE, var0 -> ScoreboardNameProviders.CONTEXT);
    public static final IRegistry<FloatProviderType<?>> FLOAT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.FLOAT_PROVIDER_TYPE, var0 -> FloatProviderType.CONSTANT);
    public static final IRegistry<IntProviderType<?>> INT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.INT_PROVIDER_TYPE, var0 -> IntProviderType.CONSTANT);
    public static final IRegistry<HeightProviderType<?>> HEIGHT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.HEIGHT_PROVIDER_TYPE, var0 -> HeightProviderType.CONSTANT);
    public static final IRegistry<BlockPredicateType<?>> BLOCK_PREDICATE_TYPE = BuiltInRegistries.registerSimple(Registries.BLOCK_PREDICATE_TYPE, var0 -> BlockPredicateType.NOT);
    public static final IRegistry<WorldGenCarverAbstract<?>> CARVER = BuiltInRegistries.registerSimple(Registries.CARVER, var0 -> WorldGenCarverAbstract.CAVE);
    public static final IRegistry<WorldGenerator<?>> FEATURE = BuiltInRegistries.registerSimple(Registries.FEATURE, var0 -> WorldGenerator.ORE);
    public static final IRegistry<StructurePlacementType<?>> STRUCTURE_PLACEMENT = BuiltInRegistries.registerSimple(Registries.STRUCTURE_PLACEMENT, var0 -> StructurePlacementType.RANDOM_SPREAD);
    public static final IRegistry<WorldGenFeatureStructurePieceType> STRUCTURE_PIECE = BuiltInRegistries.registerSimple(Registries.STRUCTURE_PIECE, var0 -> WorldGenFeatureStructurePieceType.MINE_SHAFT_ROOM);
    public static final IRegistry<StructureType<?>> STRUCTURE_TYPE = BuiltInRegistries.registerSimple(Registries.STRUCTURE_TYPE, var0 -> StructureType.JIGSAW);
    public static final IRegistry<PlacementModifierType<?>> PLACEMENT_MODIFIER_TYPE = BuiltInRegistries.registerSimple(Registries.PLACEMENT_MODIFIER_TYPE, var0 -> PlacementModifierType.COUNT);
    public static final IRegistry<WorldGenFeatureStateProviders<?>> BLOCKSTATE_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.BLOCK_STATE_PROVIDER_TYPE, var0 -> WorldGenFeatureStateProviders.SIMPLE_STATE_PROVIDER);
    public static final IRegistry<WorldGenFoilagePlacers<?>> FOLIAGE_PLACER_TYPE = BuiltInRegistries.registerSimple(Registries.FOLIAGE_PLACER_TYPE, var0 -> WorldGenFoilagePlacers.BLOB_FOLIAGE_PLACER);
    public static final IRegistry<TrunkPlacers<?>> TRUNK_PLACER_TYPE = BuiltInRegistries.registerSimple(Registries.TRUNK_PLACER_TYPE, var0 -> TrunkPlacers.STRAIGHT_TRUNK_PLACER);
    public static final IRegistry<RootPlacerType<?>> ROOT_PLACER_TYPE = BuiltInRegistries.registerSimple(Registries.ROOT_PLACER_TYPE, var0 -> RootPlacerType.MANGROVE_ROOT_PLACER);
    public static final IRegistry<WorldGenFeatureTrees<?>> TREE_DECORATOR_TYPE = BuiltInRegistries.registerSimple(Registries.TREE_DECORATOR_TYPE, var0 -> WorldGenFeatureTrees.LEAVE_VINE);
    public static final IRegistry<FeatureSizeType<?>> FEATURE_SIZE_TYPE = BuiltInRegistries.registerSimple(Registries.FEATURE_SIZE_TYPE, var0 -> FeatureSizeType.TWO_LAYERS_FEATURE_SIZE);
    public static final IRegistry<MapCodec<? extends WorldChunkManager>> BIOME_SOURCE = BuiltInRegistries.registerSimple(Registries.BIOME_SOURCE, BiomeSources::bootstrap);
    public static final IRegistry<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATOR = BuiltInRegistries.registerSimple(Registries.CHUNK_GENERATOR, ChunkGenerators::bootstrap);
    public static final IRegistry<MapCodec<? extends SurfaceRules.f>> MATERIAL_CONDITION = BuiltInRegistries.registerSimple(Registries.MATERIAL_CONDITION, SurfaceRules.f::bootstrap);
    public static final IRegistry<MapCodec<? extends SurfaceRules.o>> MATERIAL_RULE = BuiltInRegistries.registerSimple(Registries.MATERIAL_RULE, SurfaceRules.o::bootstrap);
    public static final IRegistry<MapCodec<? extends DensityFunction>> DENSITY_FUNCTION_TYPE = BuiltInRegistries.registerSimple(Registries.DENSITY_FUNCTION_TYPE, DensityFunctions::bootstrap);
    public static final IRegistry<MapCodec<? extends Block>> BLOCK_TYPE = BuiltInRegistries.registerSimple(Registries.BLOCK_TYPE, BlockTypes::bootstrap);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> STRUCTURE_PROCESSOR = BuiltInRegistries.registerSimple(Registries.STRUCTURE_PROCESSOR, var0 -> DefinedStructureStructureProcessorType.BLOCK_IGNORE);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> STRUCTURE_POOL_ELEMENT = BuiltInRegistries.registerSimple(Registries.STRUCTURE_POOL_ELEMENT, var0 -> WorldGenFeatureDefinedStructurePools.EMPTY);
    public static final IRegistry<MapCodec<? extends PoolAliasBinding>> POOL_ALIAS_BINDING_TYPE = BuiltInRegistries.registerSimple(Registries.POOL_ALIAS_BINDING, PoolAliasBindings::bootstrap);
    public static final IRegistry<CatVariant> CAT_VARIANT = BuiltInRegistries.registerSimple(Registries.CAT_VARIANT, CatVariant::bootstrap);
    public static final IRegistry<FrogVariant> FROG_VARIANT = BuiltInRegistries.registerSimple(Registries.FROG_VARIANT, FrogVariant::bootstrap);
    public static final IRegistry<DecoratedPotPattern> DECORATED_POT_PATTERN = BuiltInRegistries.registerSimple(Registries.DECORATED_POT_PATTERN, DecoratedPotPatterns::bootstrap);
    public static final IRegistry<CreativeModeTab> CREATIVE_MODE_TAB = BuiltInRegistries.registerSimple(Registries.CREATIVE_MODE_TAB, CreativeModeTabs::bootstrap);
    public static final IRegistry<CriterionTrigger<?>> TRIGGER_TYPES = BuiltInRegistries.registerSimple(Registries.TRIGGER_TYPE, CriterionTriggers::bootstrap);
    public static final IRegistry<NumberFormatType<?>> NUMBER_FORMAT_TYPE = BuiltInRegistries.registerSimple(Registries.NUMBER_FORMAT_TYPE, NumberFormatTypes::bootstrap);
    public static final IRegistry<DataComponentType<?>> DATA_COMPONENT_TYPE = BuiltInRegistries.registerSimple(Registries.DATA_COMPONENT_TYPE, DataComponents::bootstrap);
    public static final IRegistry<MapCodec<? extends EntitySubPredicate>> ENTITY_SUB_PREDICATE_TYPE = BuiltInRegistries.registerSimple(Registries.ENTITY_SUB_PREDICATE_TYPE, EntitySubPredicates::bootstrap);
    public static final IRegistry<ItemSubPredicate.a<?>> ITEM_SUB_PREDICATE_TYPE = BuiltInRegistries.registerSimple(Registries.ITEM_SUB_PREDICATE_TYPE, ItemSubPredicates::bootstrap);
    public static final IRegistry<MapDecorationType> MAP_DECORATION_TYPE = BuiltInRegistries.registerSimple(Registries.MAP_DECORATION_TYPE, MapDecorationTypes::bootstrap);
    public static final IRegistry<DataComponentType<?>> ENCHANTMENT_EFFECT_COMPONENT_TYPE = BuiltInRegistries.registerSimple(Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, EnchantmentEffectComponents::bootstrap);
    public static final IRegistry<MapCodec<? extends LevelBasedValue>> ENCHANTMENT_LEVEL_BASED_VALUE_TYPE = BuiltInRegistries.registerSimple(Registries.ENCHANTMENT_LEVEL_BASED_VALUE_TYPE, LevelBasedValue::bootstrap);
    public static final IRegistry<MapCodec<? extends EnchantmentEntityEffect>> ENCHANTMENT_ENTITY_EFFECT_TYPE = BuiltInRegistries.registerSimple(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, EnchantmentEntityEffect::bootstrap);
    public static final IRegistry<MapCodec<? extends EnchantmentLocationBasedEffect>> ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE = BuiltInRegistries.registerSimple(Registries.ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE, EnchantmentLocationBasedEffect::bootstrap);
    public static final IRegistry<MapCodec<? extends EnchantmentValueEffect>> ENCHANTMENT_VALUE_EFFECT_TYPE = BuiltInRegistries.registerSimple(Registries.ENCHANTMENT_VALUE_EFFECT_TYPE, EnchantmentValueEffect::bootstrap);
    public static final IRegistry<MapCodec<? extends EnchantmentProvider>> ENCHANTMENT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.ENCHANTMENT_PROVIDER_TYPE, EnchantmentProviderTypes::bootstrap);
    public static final IRegistry<ConsumeEffect.a<?>> CONSUME_EFFECT_TYPE = BuiltInRegistries.registerSimple(Registries.CONSUME_EFFECT_TYPE, var0 -> ConsumeEffect.a.APPLY_EFFECTS);
    public static final IRegistry<RecipeDisplay.a<?>> RECIPE_DISPLAY = BuiltInRegistries.registerSimple(Registries.RECIPE_DISPLAY, RecipeDisplays::bootstrap);
    public static final IRegistry<SlotDisplay.i<?>> SLOT_DISPLAY = BuiltInRegistries.registerSimple(Registries.SLOT_DISPLAY, SlotDisplays::bootstrap);
    public static final IRegistry<RecipeBookCategory> RECIPE_BOOK_CATEGORY = BuiltInRegistries.registerSimple(Registries.RECIPE_BOOK_CATEGORY, RecipeBookCategories::bootstrap);
    public static final IRegistry<? extends IRegistry<?>> REGISTRY = WRITABLE_REGISTRY;

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, a<T> var1) {
        return BuiltInRegistries.internalRegister(var0, new RegistryMaterials(var0, Lifecycle.stable(), false), var1);
    }

    private static <T> IRegistry<T> registerSimpleWithIntrusiveHolders(ResourceKey<? extends IRegistry<T>> var0, a<T> var1) {
        return BuiltInRegistries.internalRegister(var0, new RegistryMaterials(var0, Lifecycle.stable(), true), var1);
    }

    private static <T> RegistryBlocks<T> registerDefaulted(ResourceKey<? extends IRegistry<T>> var0, String var1, a<T> var2) {
        return BuiltInRegistries.internalRegister(var0, new DefaultedMappedRegistry(var1, var0, Lifecycle.stable(), false), var2);
    }

    private static <T> RegistryBlocks<T> registerDefaultedWithIntrusiveHolders(ResourceKey<? extends IRegistry<T>> var0, String var1, a<T> var2) {
        return BuiltInRegistries.internalRegister(var0, new DefaultedMappedRegistry(var1, var0, Lifecycle.stable(), true), var2);
    }

    private static <T, R extends IRegistryWritable<T>> R internalRegister(ResourceKey<? extends IRegistry<T>> var0, R var1, a<T> var2) {
        DispenserRegistry.checkBootstrapCalled(() -> "registry " + String.valueOf(var0.location()));
        MinecraftKey var3 = var0.location();
        LOADERS.put(var3, () -> var2.run(var1));
        WRITABLE_REGISTRY.register(var0, var1, RegistrationInfo.BUILT_IN);
        return var1;
    }

    public static void bootStrap() {
        BuiltInRegistries.createContents();
        BuiltInRegistries.freeze();
        BuiltInRegistries.validate(REGISTRY);
    }

    private static void createContents() {
        LOADERS.forEach((var0, var1) -> {
            if (var1.get() == null) {
                LOGGER.error("Unable to bootstrap registry '{}'", var0);
            }
        });
    }

    private static void freeze() {
        REGISTRY.freeze();
        for (IRegistry iRegistry : REGISTRY) {
            BuiltInRegistries.bindBootstrappedTagsToEmpty(iRegistry);
            iRegistry.freeze();
        }
    }

    private static <T extends IRegistry<?>> void validate(IRegistry<T> var0) {
        var0.forEach(var1 -> {
            if (var1.keySet().isEmpty()) {
                SystemUtils.logAndPauseIfInIde("Registry '" + String.valueOf(var0.getKey(var1)) + "' was empty after loading");
            }
            if (var1 instanceof RegistryBlocks) {
                MinecraftKey var2 = ((RegistryBlocks)var1).getDefaultKey();
                Validate.notNull(var1.getValue(var2), (String)("Missing default of DefaultedMappedRegistry: " + String.valueOf(var2)), (Object[])new Object[0]);
            }
        });
    }

    public static <T> HolderGetter<T> acquireBootstrapRegistrationLookup(IRegistry<T> var0) {
        return ((IRegistryWritable)var0).createRegistrationLookup();
    }

    private static void bindBootstrappedTagsToEmpty(IRegistry<?> var0) {
        ((RegistryMaterials)var0).bindAllTagsToEmpty();
    }

    @FunctionalInterface
    static interface a<T> {
        public Object run(IRegistry<T> var1);
    }
}

