/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public final class PatchedDataComponentMap
implements DataComponentMap {
    private final DataComponentMap prototype;
    private Reference2ObjectMap<DataComponentType<?>, Optional<?>> patch;
    private boolean copyOnWrite;

    public PatchedDataComponentMap(DataComponentMap var0) {
        this(var0, Reference2ObjectMaps.emptyMap(), true);
    }

    private PatchedDataComponentMap(DataComponentMap var0, Reference2ObjectMap<DataComponentType<?>, Optional<?>> var1, boolean var2) {
        this.prototype = var0;
        this.patch = var1;
        this.copyOnWrite = var2;
    }

    public static PatchedDataComponentMap fromPatch(DataComponentMap var0, DataComponentPatch var1) {
        if (PatchedDataComponentMap.isPatchSanitized(var0, var1.map)) {
            return new PatchedDataComponentMap(var0, var1.map, true);
        }
        PatchedDataComponentMap var2 = new PatchedDataComponentMap(var0);
        var2.applyPatch(var1);
        return var2;
    }

    private static boolean isPatchSanitized(DataComponentMap var0, Reference2ObjectMap<DataComponentType<?>, Optional<?>> var1) {
        for (Map.Entry var3 : Reference2ObjectMaps.fastIterable(var1)) {
            Object var4 = var0.get((DataComponentType)var3.getKey());
            Optional var5 = (Optional)var3.getValue();
            if (var5.isPresent() && var5.get().equals(var4)) {
                return false;
            }
            if (!var5.isEmpty() || var4 != null) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        Optional var1 = (Optional)this.patch.get(var0);
        if (var1 != null) {
            return var1.orElse(null);
        }
        return this.prototype.get(var0);
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> var0, @Nullable T var1) {
        this.ensureMapOwnership();
        T var2 = this.prototype.get(var0);
        Optional var3 = Objects.equals(var1, var2) ? (Optional)this.patch.remove(var0) : (Optional)this.patch.put(var0, Optional.ofNullable(var1));
        if (var3 != null) {
            return var3.orElse(var2);
        }
        return var2;
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> var0) {
        this.ensureMapOwnership();
        T var1 = this.prototype.get(var0);
        Optional var2 = var1 != null ? (Optional)this.patch.put(var0, Optional.empty()) : (Optional)this.patch.remove(var0);
        if (var2 != null) {
            return var2.orElse(null);
        }
        return var1;
    }

    public void applyPatch(DataComponentPatch var0) {
        this.ensureMapOwnership();
        for (Map.Entry var2 : Reference2ObjectMaps.fastIterable(var0.map)) {
            this.applyPatch((DataComponentType)var2.getKey(), (Optional)var2.getValue());
        }
    }

    private void applyPatch(DataComponentType<?> var0, Optional<?> var1) {
        Object var2 = this.prototype.get(var0);
        if (var1.isPresent()) {
            if (var1.get().equals(var2)) {
                this.patch.remove(var0);
            } else {
                this.patch.put(var0, var1);
            }
        } else if (var2 != null) {
            this.patch.put(var0, Optional.empty());
        } else {
            this.patch.remove(var0);
        }
    }

    public void restorePatch(DataComponentPatch var0) {
        this.ensureMapOwnership();
        this.patch.clear();
        this.patch.putAll(var0.map);
    }

    public void clearPatch() {
        this.ensureMapOwnership();
        this.patch.clear();
    }

    public void setAll(DataComponentMap var0) {
        for (TypedDataComponent<?> var2 : var0) {
            var2.applyTo(this);
        }
    }

    private void ensureMapOwnership() {
        if (this.copyOnWrite) {
            this.patch = new Reference2ObjectArrayMap(this.patch);
            this.copyOnWrite = false;
        }
    }

    @Override
    public Set<DataComponentType<?>> keySet() {
        if (this.patch.isEmpty()) {
            return this.prototype.keySet();
        }
        ReferenceArraySet var0 = new ReferenceArraySet(this.prototype.keySet());
        for (Reference2ObjectMap.Entry var2 : Reference2ObjectMaps.fastIterable(this.patch)) {
            Optional var3 = (Optional)var2.getValue();
            if (var3.isPresent()) {
                var0.add((DataComponentType)var2.getKey());
                continue;
            }
            var0.remove(var2.getKey());
        }
        return var0;
    }

    @Override
    public Iterator<TypedDataComponent<?>> iterator() {
        if (this.patch.isEmpty()) {
            return this.prototype.iterator();
        }
        ArrayList<Object> var0 = new ArrayList<Object>(this.patch.size() + this.prototype.size());
        for (Object var2 : Reference2ObjectMaps.fastIterable(this.patch)) {
            if (!((Optional)var2.getValue()).isPresent()) continue;
            var0.add(TypedDataComponent.createUnchecked((DataComponentType)var2.getKey(), ((Optional)var2.getValue()).get()));
        }
        for (Object var2 : this.prototype) {
            if (this.patch.containsKey(((TypedDataComponent)var2).type())) continue;
            var0.add(var2);
        }
        return var0.iterator();
    }

    @Override
    public int size() {
        int var0 = this.prototype.size();
        for (Reference2ObjectMap.Entry var2 : Reference2ObjectMaps.fastIterable(this.patch)) {
            boolean var4;
            boolean var3 = ((Optional)var2.getValue()).isPresent();
            if (var3 == (var4 = this.prototype.has((DataComponentType)var2.getKey()))) continue;
            var0 += var3 ? 1 : -1;
        }
        return var0;
    }

    public DataComponentPatch asPatch() {
        if (this.patch.isEmpty()) {
            return DataComponentPatch.EMPTY;
        }
        this.copyOnWrite = true;
        return new DataComponentPatch(this.patch);
    }

    public PatchedDataComponentMap copy() {
        this.copyOnWrite = true;
        return new PatchedDataComponentMap(this.prototype, this.patch, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof PatchedDataComponentMap)) return false;
        PatchedDataComponentMap var1 = (PatchedDataComponentMap)var0;
        if (!this.prototype.equals(var1.prototype)) return false;
        if (!this.patch.equals(var1.patch)) return false;
        return true;
    }

    public int hashCode() {
        return this.prototype.hashCode() + this.patch.hashCode() * 31;
    }

    public String toString() {
        return "{" + this.stream().map(TypedDataComponent::toString).collect(Collectors.joining(", ")) + "}";
    }
}

