/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class ResourceOrTagKeyArgument<T>
implements ArgumentType<c<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    final ResourceKey<? extends IRegistry<T>> registryKey;

    public ResourceOrTagKeyArgument(ResourceKey<? extends IRegistry<T>> var0) {
        this.registryKey = var0;
    }

    public static <T> ResourceOrTagKeyArgument<T> resourceOrTagKey(ResourceKey<? extends IRegistry<T>> var0) {
        return new ResourceOrTagKeyArgument<T>(var0);
    }

    public static <T> c<T> getResourceOrTagKey(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        c var4 = (c)var0.getArgument(var1, c.class);
        Optional<c<T>> var5 = var4.cast(var2);
        return var5.orElseThrow(() -> var3.create((Object)var4));
    }

    public c<T> parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '#') {
            int var1 = var0.getCursor();
            try {
                var0.skip();
                MinecraftKey var2 = MinecraftKey.read(var0);
                return new d(TagKey.create(this.registryKey, var2));
            }
            catch (CommandSyntaxException var2) {
                var0.setCursor(var1);
                throw var2;
            }
        }
        MinecraftKey var1 = MinecraftKey.read(var0);
        return new b(ResourceKey.create(this.registryKey, var1));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        Object object = var0.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider var2 = (ICompletionProvider)object;
            return var2.suggestRegistryElements(this.registryKey, ICompletionProvider.a.ALL, var1, var0);
        }
        return var1.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface c<T>
    extends Predicate<Holder<T>> {
        public Either<ResourceKey<T>, TagKey<T>> unwrap();

        public <E> Optional<c<E>> cast(ResourceKey<? extends IRegistry<E>> var1);

        public String asPrintable();
    }

    record d<T>(TagKey<T> key) implements c<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> unwrap() {
            return Either.right(this.key);
        }

        @Override
        public <E> Optional<c<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
            return this.key.cast(var0).map(d::new);
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.is(this.key);
        }

        @Override
        public String asPrintable() {
            return "#" + String.valueOf(this.key.location());
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record b<T>(ResourceKey<T> key) implements c<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> unwrap() {
            return Either.left(this.key);
        }

        @Override
        public <E> Optional<c<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
            return this.key.cast(var0).map(b::new);
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.is(this.key);
        }

        @Override
        public String asPrintable() {
            return this.key.location().toString();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class net.minecraft.commands.arguments.ResourceOrTagKeyArgument$a<T>
    implements ArgumentTypeInfo<ResourceOrTagKeyArgument<T>, a> {
        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            return new a(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public a unpack(ResourceOrTagKeyArgument<T> var0) {
            return new a(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceOrTagKeyArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> registryKey;

            a(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceOrTagKeyArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceOrTagKeyArgument(this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceOrTagKeyArgument<T>, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

