/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.phys.Vec3D;

public record SheepPredicate(Optional<Boolean> sheared, Optional<EnumColor> color) implements EntitySubPredicate
{
    public static final MapCodec<SheepPredicate> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.BOOL.optionalFieldOf("sheared").forGetter(SheepPredicate::sheared), (App)EnumColor.CODEC.optionalFieldOf("color").forGetter(SheepPredicate::color)).apply((Applicative)var0, SheepPredicate::new));

    public MapCodec<SheepPredicate> codec() {
        return EntitySubPredicates.SHEEP;
    }

    @Override
    public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var2) {
        if (var0 instanceof EntitySheep) {
            EntitySheep var3 = (EntitySheep)var0;
            if (this.sheared.isPresent() && var3.isSheared() != this.sheared.get().booleanValue()) {
                return false;
            }
            return !this.color.isPresent() || var3.getColor() == this.color.get();
        }
        return false;
    }

    public static SheepPredicate hasWool(EnumColor var0) {
        return new SheepPredicate(Optional.of(false), Optional.of(var0));
    }
}

