/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;

public class RecipeCraftedTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, ResourceKey<IRecipe<?>> var1, List<ItemStack> var22) {
        this.trigger(var0, var2 -> var2.matches(var1, var22));
    }

    public record a(Optional<ContextAwarePredicate> player, ResourceKey<IRecipe<?>> recipeId, List<CriterionConditionItem> ingredients) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)ResourceKey.codec(Registries.RECIPE).fieldOf("recipe_id").forGetter(a::recipeId), (App)CriterionConditionItem.CODEC.listOf().optionalFieldOf("ingredients", List.of()).forGetter(a::ingredients)).apply((Applicative)var0, a::new));

        public static Criterion<a> craftedItem(ResourceKey<IRecipe<?>> var0, List<CriterionConditionItem.a> var1) {
            return CriterionTriggers.RECIPE_CRAFTED.createCriterion(new a(Optional.empty(), var0, var1.stream().map(CriterionConditionItem.a::build).toList()));
        }

        public static Criterion<a> craftedItem(ResourceKey<IRecipe<?>> var0) {
            return CriterionTriggers.RECIPE_CRAFTED.createCriterion(new a(Optional.empty(), var0, List.of()));
        }

        public static Criterion<a> crafterCraftedItem(ResourceKey<IRecipe<?>> var0) {
            return CriterionTriggers.CRAFTER_RECIPE_CRAFTED.createCriterion(new a(Optional.empty(), var0, List.of()));
        }

        boolean matches(ResourceKey<IRecipe<?>> var0, List<ItemStack> var1) {
            if (var0 != this.recipeId) {
                return false;
            }
            ArrayList<ItemStack> var2 = new ArrayList<ItemStack>(var1);
            for (CriterionConditionItem var4 : this.ingredients) {
                boolean var5 = false;
                Iterator var6 = var2.iterator();
                while (var6.hasNext()) {
                    if (!var4.test((ItemStack)var6.next())) continue;
                    var6.remove();
                    var5 = true;
                    break;
                }
                if (var5) continue;
                return false;
            }
            return true;
        }
    }
}

