/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public record LootItemConditionMatchTool(Optional<CriterionConditionItem> predicate) implements LootItemCondition
{
    public static final MapCodec<LootItemConditionMatchTool> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CriterionConditionItem.CODEC.optionalFieldOf("predicate").forGetter(LootItemConditionMatchTool::predicate)).apply((Applicative)var0, LootItemConditionMatchTool::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.MATCH_TOOL;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParameters.TOOL);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        ItemStack var1 = var0.getOptionalParameter(LootContextParameters.TOOL);
        return var1 != null && (this.predicate.isEmpty() || this.predicate.get().test(var1));
    }

    public static LootItemCondition.a toolMatches(CriterionConditionItem.a var0) {
        return () -> new LootItemConditionMatchTool(Optional.of(var0.build()));
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

