/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootItemFunctionSetCount
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionSetCount> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionSetCount.commonFields(var02).and(var02.group((App)NumberProviders.CODEC.fieldOf("count").forGetter(var0 -> var0.value), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(var0 -> var0.add))).apply((Applicative)var02, LootItemFunctionSetCount::new));
    private final NumberProvider value;
    private final boolean add;

    private LootItemFunctionSetCount(List<LootItemCondition> var0, NumberProvider var1, boolean var2) {
        super(var0);
        this.value = var1;
        this.add = var2;
    }

    public LootItemFunctionType<LootItemFunctionSetCount> getType() {
        return LootItemFunctions.SET_COUNT;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        int var2 = this.add ? var0.getCount() : 0;
        var0.setCount(var2 + this.value.getInt(var1));
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setCount(NumberProvider var0) {
        return LootItemFunctionSetCount.simpleBuilder(var1 -> new LootItemFunctionSetCount((List<LootItemCondition>)var1, var0, false));
    }

    public static LootItemFunctionConditional.a<?> setCount(NumberProvider var0, boolean var1) {
        return LootItemFunctionSetCount.simpleBuilder(var2 -> new LootItemFunctionSetCount((List<LootItemCondition>)var2, var0, var1));
    }
}

