/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String LEVEL_NAME = "LevelName";
    protected static final String PLAYER = "Player";
    protected static final String WORLD_GEN_SETTINGS = "WorldGenSettings";
    public WorldSettings settings;
    private final WorldOptions worldOptions;
    private final a specialWorldProperty;
    private final Lifecycle worldGenSettingsLifecycle;
    private WorldData.a respawnData;
    private long gameTime;
    private long dayTime;
    private final @Nullable NBTTagCompound loadedPlayerTag;
    private final int version;
    private int clearWeatherTime;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private boolean initialized;
    private boolean difficultyLocked;
    @Deprecated
    private Optional<WorldBorder.c> legacyWorldBorderSettings;
    private EnderDragonBattle.a endDragonFightData;
    private @Nullable NBTTagCompound customBossEvents;
    private int wanderingTraderSpawnDelay;
    private int wanderingTraderSpawnChance;
    private @Nullable UUID wanderingTraderId;
    private final Set<String> knownServerBrands;
    private boolean wasModded;
    private final Set<String> removedFeatureFlags;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents;

    private WorldDataServer(@Nullable NBTTagCompound var0, boolean var1, WorldData.a var2, long var3, long var5, int var7, int var8, int var9, boolean var10, int var11, boolean var12, boolean var13, boolean var14, Optional<WorldBorder.c> var15, int var16, int var17, @Nullable UUID var18, Set<String> var19, Set<String> var20, CustomFunctionCallbackTimerQueue<MinecraftServer> var21, @Nullable NBTTagCompound var22, EnderDragonBattle.a var23, WorldSettings var24, WorldOptions var25, a var26, Lifecycle var27) {
        this.wasModded = var1;
        this.respawnData = var2;
        this.gameTime = var3;
        this.dayTime = var5;
        this.version = var7;
        this.clearWeatherTime = var8;
        this.rainTime = var9;
        this.raining = var10;
        this.thunderTime = var11;
        this.thundering = var12;
        this.initialized = var13;
        this.difficultyLocked = var14;
        this.legacyWorldBorderSettings = var15;
        this.wanderingTraderSpawnDelay = var16;
        this.wanderingTraderSpawnChance = var17;
        this.wanderingTraderId = var18;
        this.knownServerBrands = var19;
        this.removedFeatureFlags = var20;
        this.loadedPlayerTag = var0;
        this.scheduledEvents = var21;
        this.customBossEvents = var22;
        this.endDragonFightData = var23;
        this.settings = var24;
        this.worldOptions = var25;
        this.specialWorldProperty = var26;
        this.worldGenSettingsLifecycle = var27;
    }

    public WorldDataServer(WorldSettings var0, WorldOptions var1, a var2, Lifecycle var3) {
        this(null, false, WorldData.a.DEFAULT, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, Optional.empty(), 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.SERVER_CALLBACKS), null, EnderDragonBattle.a.DEFAULT, var0.copy(), var1, var2, var3);
    }

    public static <T> WorldDataServer parse(Dynamic<T> var02, WorldSettings var1, a var2, WorldOptions var3, Lifecycle var4) {
        long var5 = var02.get("Time").asLong(0L);
        return new WorldDataServer(var02.get(PLAYER).flatMap(arg_0 -> NBTTagCompound.CODEC.parse(arg_0)).result().orElse(null), var02.get("WasModded").asBoolean(false), var02.get("spawn").read(WorldData.a.CODEC).result().orElse(WorldData.a.DEFAULT), var5, var02.get("DayTime").asLong(var5), LevelVersion.parse(var02).levelDataVersion(), var02.get("clearWeatherTime").asInt(0), var02.get("rainTime").asInt(0), var02.get("raining").asBoolean(false), var02.get("thunderTime").asInt(0), var02.get("thundering").asBoolean(false), var02.get("initialized").asBoolean(true), var02.get("DifficultyLocked").asBoolean(false), WorldBorder.c.CODEC.parse(var02.get("world_border").orElseEmptyMap()).result(), var02.get("WanderingTraderSpawnDelay").asInt(0), var02.get("WanderingTraderSpawnChance").asInt(0), var02.get("WanderingTraderId").read(UUIDUtil.CODEC).result().orElse(null), var02.get("ServerBrands").asStream().flatMap(var0 -> var0.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), var02.get("removed_features").asStream().flatMap(var0 -> var0.asString().result().stream()).collect(Collectors.toSet()), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.SERVER_CALLBACKS, var02.get("ScheduledEvents").asStream()), (NBTTagCompound)var02.get("CustomBossEvents").orElseEmptyMap().getValue(), var02.get("DragonFight").read(EnderDragonBattle.a.CODEC).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(EnderDragonBattle.a.DEFAULT), var1, var3, var2, var4);
    }

    @Override
    public NBTTagCompound createTag(IRegistryCustom var0, @Nullable NBTTagCompound var1) {
        if (var1 == null) {
            var1 = this.loadedPlayerTag;
        }
        NBTTagCompound var2 = new NBTTagCompound();
        this.setTagData(var0, var2, var1);
        return var2;
    }

    private void setTagData(IRegistryCustom var0, NBTTagCompound var12, @Nullable NBTTagCompound var2) {
        var12.put("ServerBrands", WorldDataServer.stringCollectionToTag(this.knownServerBrands));
        var12.putBoolean("WasModded", this.wasModded);
        if (!this.removedFeatureFlags.isEmpty()) {
            var12.put("removed_features", WorldDataServer.stringCollectionToTag(this.removedFeatureFlags));
        }
        NBTTagCompound var3 = new NBTTagCompound();
        var3.putString("Name", SharedConstants.getCurrentVersion().name());
        var3.putInt("Id", SharedConstants.getCurrentVersion().dataVersion().version());
        var3.putBoolean("Snapshot", !SharedConstants.getCurrentVersion().stable());
        var3.putString("Series", SharedConstants.getCurrentVersion().dataVersion().series());
        var12.put("Version", var3);
        GameProfileSerializer.addCurrentDataVersion(var12);
        RegistryOps<NBTBase> var4 = var0.createSerializationContext(DynamicOpsNBT.INSTANCE);
        GeneratorSettings.encode(var4, this.worldOptions, var0).resultOrPartial(SystemUtils.prefix("WorldGenSettings: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var1 -> var12.put(WORLD_GEN_SETTINGS, (NBTBase)var1));
        var12.putInt("GameType", this.settings.gameType().getId());
        var12.store("spawn", WorldData.a.CODEC, this.respawnData);
        var12.putLong("Time", this.gameTime);
        var12.putLong("DayTime", this.dayTime);
        var12.putLong("LastPlayed", SystemUtils.getEpochMillis());
        var12.putString(LEVEL_NAME, this.settings.levelName());
        var12.putInt("version", 19133);
        var12.putInt("clearWeatherTime", this.clearWeatherTime);
        var12.putInt("rainTime", this.rainTime);
        var12.putBoolean("raining", this.raining);
        var12.putInt("thunderTime", this.thunderTime);
        var12.putBoolean("thundering", this.thundering);
        var12.putBoolean("hardcore", this.settings.hardcore());
        var12.putBoolean("allowCommands", this.settings.allowCommands());
        var12.putBoolean("initialized", this.initialized);
        this.legacyWorldBorderSettings.ifPresent(var1 -> var12.store("world_border", WorldBorder.c.CODEC, var1));
        var12.putByte("Difficulty", (byte)this.settings.difficulty().getId());
        var12.putBoolean("DifficultyLocked", this.difficultyLocked);
        var12.store("game_rules", GameRules.codec(this.enabledFeatures()), this.settings.gameRules());
        var12.store("DragonFight", EnderDragonBattle.a.CODEC, this.endDragonFightData);
        if (var2 != null) {
            var12.put(PLAYER, var2);
        }
        var12.store(WorldDataConfiguration.MAP_CODEC, this.settings.getDataConfiguration());
        if (this.customBossEvents != null) {
            var12.put("CustomBossEvents", this.customBossEvents);
        }
        var12.put("ScheduledEvents", this.scheduledEvents.store());
        var12.putInt("WanderingTraderSpawnDelay", this.wanderingTraderSpawnDelay);
        var12.putInt("WanderingTraderSpawnChance", this.wanderingTraderSpawnChance);
        var12.storeNullable("WanderingTraderId", UUIDUtil.CODEC, this.wanderingTraderId);
    }

    private static NBTTagList stringCollectionToTag(Set<String> var0) {
        NBTTagList var1 = new NBTTagList();
        var0.stream().map(NBTTagString::valueOf).forEach(var1::add);
        return var1;
    }

    @Override
    public WorldData.a getRespawnData() {
        return this.respawnData;
    }

    @Override
    public long getGameTime() {
        return this.gameTime;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    @Override
    public @Nullable NBTTagCompound getLoadedPlayerTag() {
        return this.loadedPlayerTag;
    }

    @Override
    public void setGameTime(long var0) {
        this.gameTime = var0;
    }

    @Override
    public void setDayTime(long var0) {
        this.dayTime = var0;
    }

    @Override
    public void setSpawn(WorldData.a var0) {
        this.respawnData = var0;
    }

    @Override
    public String getLevelName() {
        return this.settings.levelName();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getClearWeatherTime() {
        return this.clearWeatherTime;
    }

    @Override
    public void setClearWeatherTime(int var0) {
        this.clearWeatherTime = var0;
    }

    @Override
    public boolean isThundering() {
        return this.thundering;
    }

    @Override
    public void setThundering(boolean var0) {
        this.thundering = var0;
    }

    @Override
    public int getThunderTime() {
        return this.thunderTime;
    }

    @Override
    public void setThunderTime(int var0) {
        this.thunderTime = var0;
    }

    @Override
    public boolean isRaining() {
        return this.raining;
    }

    @Override
    public void setRaining(boolean var0) {
        this.raining = var0;
    }

    @Override
    public int getRainTime() {
        return this.rainTime;
    }

    @Override
    public void setRainTime(int var0) {
        this.rainTime = var0;
    }

    @Override
    public EnumGamemode getGameType() {
        return this.settings.gameType();
    }

    @Override
    public void setGameType(EnumGamemode var0) {
        this.settings = this.settings.withGameType(var0);
    }

    @Override
    public boolean isHardcore() {
        return this.settings.hardcore();
    }

    @Override
    public boolean isAllowCommands() {
        return this.settings.allowCommands();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean var0) {
        this.initialized = var0;
    }

    @Override
    public GameRules getGameRules() {
        return this.settings.gameRules();
    }

    @Override
    public Optional<WorldBorder.c> getLegacyWorldBorderSettings() {
        return this.legacyWorldBorderSettings;
    }

    @Override
    public void setLegacyWorldBorderSettings(Optional<WorldBorder.c> var0) {
        this.legacyWorldBorderSettings = var0;
    }

    @Override
    public EnumDifficulty getDifficulty() {
        return this.settings.difficulty();
    }

    @Override
    public void setDifficulty(EnumDifficulty var0) {
        this.settings = this.settings.withDifficulty(var0);
    }

    @Override
    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    @Override
    public void setDifficultyLocked(boolean var0) {
        this.difficultyLocked = var0;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> getScheduledEvents() {
        return this.scheduledEvents;
    }

    @Override
    public void fillCrashReportCategory(CrashReportSystemDetails var0, LevelHeightAccessor var1) {
        IWorldDataServer.super.fillCrashReportCategory(var0, var1);
        SaveData.super.fillCrashReportCategory(var0);
    }

    @Override
    public WorldOptions worldGenOptions() {
        return this.worldOptions;
    }

    @Override
    public boolean isFlatWorld() {
        return this.specialWorldProperty == a.FLAT;
    }

    @Override
    public boolean isDebugWorld() {
        return this.specialWorldProperty == a.DEBUG;
    }

    @Override
    public Lifecycle worldGenSettingsLifecycle() {
        return this.worldGenSettingsLifecycle;
    }

    @Override
    public EnderDragonBattle.a endDragonFightData() {
        return this.endDragonFightData;
    }

    @Override
    public void setEndDragonFightData(EnderDragonBattle.a var0) {
        this.endDragonFightData = var0;
    }

    @Override
    public WorldDataConfiguration getDataConfiguration() {
        return this.settings.getDataConfiguration();
    }

    @Override
    public void setDataConfiguration(WorldDataConfiguration var0) {
        this.settings = this.settings.withDataConfiguration(var0);
    }

    @Override
    public @Nullable NBTTagCompound getCustomBossEvents() {
        return this.customBossEvents;
    }

    @Override
    public void setCustomBossEvents(@Nullable NBTTagCompound var0) {
        this.customBossEvents = var0;
    }

    @Override
    public int getWanderingTraderSpawnDelay() {
        return this.wanderingTraderSpawnDelay;
    }

    @Override
    public void setWanderingTraderSpawnDelay(int var0) {
        this.wanderingTraderSpawnDelay = var0;
    }

    @Override
    public int getWanderingTraderSpawnChance() {
        return this.wanderingTraderSpawnChance;
    }

    @Override
    public void setWanderingTraderSpawnChance(int var0) {
        this.wanderingTraderSpawnChance = var0;
    }

    @Override
    public @Nullable UUID getWanderingTraderId() {
        return this.wanderingTraderId;
    }

    @Override
    public void setWanderingTraderId(UUID var0) {
        this.wanderingTraderId = var0;
    }

    @Override
    public void setModdedInfo(String var0, boolean var1) {
        this.knownServerBrands.add(var0);
        this.wasModded |= var1;
    }

    @Override
    public boolean wasModded() {
        return this.wasModded;
    }

    @Override
    public Set<String> getKnownServerBrands() {
        return ImmutableSet.copyOf(this.knownServerBrands);
    }

    @Override
    public Set<String> getRemovedFeatureFlags() {
        return Set.copyOf(this.removedFeatureFlags);
    }

    @Override
    public IWorldDataServer overworldData() {
        return this;
    }

    @Override
    public WorldSettings getLevelSettings() {
        return this.settings.copy();
    }

    @Deprecated
    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NONE = new a();
        public static final /* enum */ a FLAT = new a();
        public static final /* enum */ a DEBUG = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{NONE, FLAT, DEBUG};
        }

        static {
            d = a.a();
        }
    }
}

