/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;

public class Orientation {
    public static final StreamCodec<ByteBuf, Orientation> STREAM_CODEC = ByteBufCodecs.idMapper(Orientation::fromIndex, Orientation::getIndex);
    private static final Orientation[] ORIENTATIONS = SystemUtils.make(() -> {
        Orientation[] var0 = new Orientation[48];
        Orientation.generateContext(new Orientation(EnumDirection.UP, EnumDirection.NORTH, a.LEFT), var0);
        return var0;
    });
    private final EnumDirection up;
    private final EnumDirection front;
    private final EnumDirection side;
    private final a sideBias;
    private final int index;
    private final List<EnumDirection> neighbors;
    private final List<EnumDirection> horizontalNeighbors;
    private final List<EnumDirection> verticalNeighbors;
    private final Map<EnumDirection, Orientation> withFront = new EnumMap<EnumDirection, Orientation>(EnumDirection.class);
    private final Map<EnumDirection, Orientation> withUp = new EnumMap<EnumDirection, Orientation>(EnumDirection.class);
    private final Map<a, Orientation> withSideBias = new EnumMap<a, Orientation>(a.class);

    private Orientation(EnumDirection var02, EnumDirection var1, a var2) {
        this.up = var02;
        this.front = var1;
        this.sideBias = var2;
        this.index = Orientation.generateIndex(var02, var1, var2);
        BaseBlockPosition var3 = var1.getUnitVec3i().cross(var02.getUnitVec3i());
        EnumDirection var4 = EnumDirection.getNearest(var3, null);
        Objects.requireNonNull(var4);
        this.side = this.sideBias == a.RIGHT ? var4 : var4.getOpposite();
        this.neighbors = List.of(this.front.getOpposite(), this.front, this.side, this.side.getOpposite(), this.up.getOpposite(), this.up);
        this.horizontalNeighbors = this.neighbors.stream().filter(var0 -> var0.getAxis() != this.up.getAxis()).toList();
        this.verticalNeighbors = this.neighbors.stream().filter(var0 -> var0.getAxis() == this.up.getAxis()).toList();
    }

    public static Orientation of(EnumDirection var0, EnumDirection var1, a var2) {
        return ORIENTATIONS[Orientation.generateIndex(var0, var1, var2)];
    }

    public Orientation withUp(EnumDirection var0) {
        return this.withUp.get(var0);
    }

    public Orientation withFront(EnumDirection var0) {
        return this.withFront.get(var0);
    }

    public Orientation withFrontPreserveUp(EnumDirection var0) {
        if (var0.getAxis() == this.up.getAxis()) {
            return this;
        }
        return this.withFront.get(var0);
    }

    public Orientation withFrontAdjustSideBias(EnumDirection var0) {
        Orientation var1 = this.withFront(var0);
        if (this.front == var1.side) {
            return var1.withMirror();
        }
        return var1;
    }

    public Orientation withSideBias(a var0) {
        return this.withSideBias.get((Object)var0);
    }

    public Orientation withMirror() {
        return this.withSideBias(this.sideBias.getOpposite());
    }

    public EnumDirection getFront() {
        return this.front;
    }

    public EnumDirection getUp() {
        return this.up;
    }

    public EnumDirection getSide() {
        return this.side;
    }

    public a getSideBias() {
        return this.sideBias;
    }

    public List<EnumDirection> getDirections() {
        return this.neighbors;
    }

    public List<EnumDirection> getHorizontalDirections() {
        return this.horizontalNeighbors;
    }

    public List<EnumDirection> getVerticalDirections() {
        return this.verticalNeighbors;
    }

    public String toString() {
        return "[up=" + String.valueOf(this.up) + ",front=" + String.valueOf(this.front) + ",sideBias=" + String.valueOf((Object)this.sideBias) + "]";
    }

    public int getIndex() {
        return this.index;
    }

    public static Orientation fromIndex(int var0) {
        return ORIENTATIONS[var0];
    }

    public static Orientation random(RandomSource var0) {
        return SystemUtils.getRandom(ORIENTATIONS, var0);
    }

    private static Orientation generateContext(Orientation var0, Orientation[] var1) {
        EnumDirection var6;
        if (var1[var0.getIndex()] != null) {
            return var1[var0.getIndex()];
        }
        var1[var0.getIndex()] = var0;
        for (a a2 : a.values()) {
            var0.withSideBias.put(a2, Orientation.generateContext(new Orientation(var0.up, var0.front, a2), var1));
        }
        for (Enum enum_ : EnumDirection.values()) {
            var6 = var0.up;
            if (enum_ == var0.up) {
                var6 = var0.front.getOpposite();
            }
            if (enum_ == var0.up.getOpposite()) {
                var6 = var0.front;
            }
            var0.withFront.put((EnumDirection)enum_, Orientation.generateContext(new Orientation(var6, (EnumDirection)enum_, var0.sideBias), var1));
        }
        for (Enum enum_ : EnumDirection.values()) {
            var6 = var0.front;
            if (enum_ == var0.front) {
                var6 = var0.up.getOpposite();
            }
            if (enum_ == var0.front.getOpposite()) {
                var6 = var0.up;
            }
            var0.withUp.put((EnumDirection)enum_, Orientation.generateContext(new Orientation((EnumDirection)enum_, var6, var0.sideBias), var1));
        }
        return var0;
    }

    @VisibleForTesting
    protected static int generateIndex(EnumDirection var0, EnumDirection var1, a var2) {
        if (var0.getAxis() == var1.getAxis()) {
            throw new IllegalStateException("Up-vector and front-vector can not be on the same axis");
        }
        int var3 = var0.getAxis() == EnumDirection.EnumAxis.Y ? (var1.getAxis() == EnumDirection.EnumAxis.X ? 1 : 0) : (var1.getAxis() == EnumDirection.EnumAxis.Y ? 1 : 0);
        int var4 = var3 << 1 | var1.getAxisDirection().ordinal();
        return ((var0.ordinal() << 2) + var4 << 1) + var2.ordinal();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a LEFT = new a("left");
        public static final /* enum */ a RIGHT = new a("right");
        private final String name;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.name = var2;
        }

        public a getOpposite() {
            return this == LEFT ? RIGHT : LEFT;
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ a[] b() {
            return new a[]{LEFT, RIGHT};
        }

        static {
            d = a.b();
        }
    }
}

