/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageArray;
import org.jspecify.annotations.Nullable;

public abstract class LightEngineStorage<M extends LightEngineStorageArray<M>> {
    private final EnumSkyBlock layer;
    protected final ILightAccess chunkSource;
    protected final Long2ByteMap sectionStates = new Long2ByteOpenHashMap();
    private final LongSet columnsWithSources = new LongOpenHashSet();
    protected volatile M visibleSectionData;
    protected final M updatingSectionData;
    protected final LongSet changedSections = new LongOpenHashSet();
    protected final LongSet sectionsAffectedByLightUpdates = new LongOpenHashSet();
    protected final Long2ObjectMap<NibbleArray> queuedSections = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final LongSet columnsToRetainQueuedDataFor = new LongOpenHashSet();
    private final LongSet toRemove = new LongOpenHashSet();
    protected volatile boolean hasInconsistencies;

    protected LightEngineStorage(EnumSkyBlock var0, ILightAccess var1, M var2) {
        this.layer = var0;
        this.chunkSource = var1;
        this.updatingSectionData = var2;
        this.visibleSectionData = ((LightEngineStorageArray)var2).copy();
        ((LightEngineStorageArray)this.visibleSectionData).disableCache();
        this.sectionStates.defaultReturnValue((byte)0);
    }

    protected boolean storingLightForSection(long var0) {
        return this.getDataLayer(var0, true) != null;
    }

    protected @Nullable NibbleArray getDataLayer(long var0, boolean var2) {
        return this.getDataLayer(var2 ? this.updatingSectionData : this.visibleSectionData, var0);
    }

    protected @Nullable NibbleArray getDataLayer(M var0, long var1) {
        return ((LightEngineStorageArray)var0).getLayer(var1);
    }

    protected @Nullable NibbleArray getDataLayerToWrite(long var0) {
        NibbleArray var2 = ((LightEngineStorageArray)this.updatingSectionData).getLayer(var0);
        if (var2 == null) {
            return null;
        }
        if (this.changedSections.add(var0)) {
            var2 = var2.copy();
            ((LightEngineStorageArray)this.updatingSectionData).setLayer(var0, var2);
            ((LightEngineStorageArray)this.updatingSectionData).clearCache();
        }
        return var2;
    }

    public @Nullable NibbleArray getDataLayerData(long var0) {
        NibbleArray var2 = (NibbleArray)this.queuedSections.get(var0);
        if (var2 != null) {
            return var2;
        }
        return this.getDataLayer(var0, false);
    }

    protected abstract int getLightValue(long var1);

    protected int getStoredLevel(long var0) {
        long var2 = SectionPosition.blockToSection(var0);
        NibbleArray var4 = this.getDataLayer(var2, true);
        return var4.get(SectionPosition.sectionRelative(BlockPosition.getX(var0)), SectionPosition.sectionRelative(BlockPosition.getY(var0)), SectionPosition.sectionRelative(BlockPosition.getZ(var0)));
    }

    protected void setStoredLevel(long var0, int var2) {
        long var3 = SectionPosition.blockToSection(var0);
        NibbleArray var5 = this.changedSections.add(var3) ? ((LightEngineStorageArray)this.updatingSectionData).copyDataLayer(var3) : this.getDataLayer(var3, true);
        var5.set(SectionPosition.sectionRelative(BlockPosition.getX(var0)), SectionPosition.sectionRelative(BlockPosition.getY(var0)), SectionPosition.sectionRelative(BlockPosition.getZ(var0)), var2);
        SectionPosition.aroundAndAtBlockPos(var0, arg_0 -> ((LongSet)this.sectionsAffectedByLightUpdates).add(arg_0));
    }

    protected void markSectionAndNeighborsAsAffected(long var0) {
        int var2 = SectionPosition.x(var0);
        int var3 = SectionPosition.y(var0);
        int var4 = SectionPosition.z(var0);
        for (int var5 = -1; var5 <= 1; ++var5) {
            for (int var6 = -1; var6 <= 1; ++var6) {
                for (int var7 = -1; var7 <= 1; ++var7) {
                    this.sectionsAffectedByLightUpdates.add(SectionPosition.asLong(var2 + var6, var3 + var7, var4 + var5));
                }
            }
        }
    }

    protected NibbleArray createDataLayer(long var0) {
        NibbleArray var2 = (NibbleArray)this.queuedSections.get(var0);
        if (var2 != null) {
            return var2;
        }
        return new NibbleArray();
    }

    protected boolean hasInconsistencies() {
        return this.hasInconsistencies;
    }

    protected void markNewInconsistencies(LightEngine<M, ?> var0) {
        NibbleArray var5;
        long var2;
        if (!this.hasInconsistencies) {
            return;
        }
        this.hasInconsistencies = false;
        LongIterator longIterator = this.toRemove.iterator();
        while (longIterator.hasNext()) {
            var2 = (Long)longIterator.next();
            NibbleArray var4 = (NibbleArray)this.queuedSections.remove(var2);
            var5 = ((LightEngineStorageArray)this.updatingSectionData).removeLayer(var2);
            if (!this.columnsToRetainQueuedDataFor.contains(SectionPosition.getZeroNode(var2))) continue;
            if (var4 != null) {
                this.queuedSections.put(var2, (Object)var4);
                continue;
            }
            if (var5 == null) continue;
            this.queuedSections.put(var2, (Object)var5);
        }
        ((LightEngineStorageArray)this.updatingSectionData).clearCache();
        longIterator = this.toRemove.iterator();
        while (longIterator.hasNext()) {
            var2 = (Long)longIterator.next();
            this.onNodeRemoved(var2);
            this.changedSections.add(var2);
        }
        this.toRemove.clear();
        ObjectIterator var1 = Long2ObjectMaps.fastIterator(this.queuedSections);
        while (var1.hasNext()) {
            Long2ObjectMap.Entry var22 = (Long2ObjectMap.Entry)var1.next();
            long var3 = var22.getLongKey();
            if (!this.storingLightForSection(var3)) continue;
            var5 = (NibbleArray)var22.getValue();
            if (((LightEngineStorageArray)this.updatingSectionData).getLayer(var3) != var5) {
                ((LightEngineStorageArray)this.updatingSectionData).setLayer(var3, var5);
                this.changedSections.add(var3);
            }
            var1.remove();
        }
        ((LightEngineStorageArray)this.updatingSectionData).clearCache();
    }

    protected void onNodeAdded(long var0) {
    }

    protected void onNodeRemoved(long var0) {
    }

    protected void setLightEnabled(long var0, boolean var2) {
        if (var2) {
            this.columnsWithSources.add(var0);
        } else {
            this.columnsWithSources.remove(var0);
        }
    }

    protected boolean lightOnInSection(long var0) {
        long var2 = SectionPosition.getZeroNode(var0);
        return this.columnsWithSources.contains(var2);
    }

    protected boolean lightOnInColumn(long var0) {
        return this.columnsWithSources.contains(var0);
    }

    public void retainData(long var0, boolean var2) {
        if (var2) {
            this.columnsToRetainQueuedDataFor.add(var0);
        } else {
            this.columnsToRetainQueuedDataFor.remove(var0);
        }
    }

    protected void queueSectionData(long var0, @Nullable NibbleArray var2) {
        if (var2 != null) {
            this.queuedSections.put(var0, (Object)var2);
            this.hasInconsistencies = true;
        } else {
            this.queuedSections.remove(var0);
        }
    }

    protected void updateSectionStatus(long var0, boolean var2) {
        byte var4;
        byte var3 = this.sectionStates.get(var0);
        if (var3 == (var4 = a.hasData(var3, !var2))) {
            return;
        }
        this.putSectionState(var0, var4);
        int var5 = var2 ? -1 : 1;
        for (int var6 = -1; var6 <= 1; ++var6) {
            for (int var7 = -1; var7 <= 1; ++var7) {
                for (int var8 = -1; var8 <= 1; ++var8) {
                    if (var6 == 0 && var7 == 0 && var8 == 0) continue;
                    long var9 = SectionPosition.offset(var0, var6, var7, var8);
                    byte var11 = this.sectionStates.get(var9);
                    this.putSectionState(var9, a.neighborCount(var11, a.neighborCount(var11) + var5));
                }
            }
        }
    }

    protected void putSectionState(long var0, byte var2) {
        if (var2 != 0) {
            if (this.sectionStates.put(var0, var2) == 0) {
                this.initializeSection(var0);
            }
        } else if (this.sectionStates.remove(var0) != 0) {
            this.removeSection(var0);
        }
    }

    private void initializeSection(long var0) {
        if (!this.toRemove.remove(var0)) {
            ((LightEngineStorageArray)this.updatingSectionData).setLayer(var0, this.createDataLayer(var0));
            this.changedSections.add(var0);
            this.onNodeAdded(var0);
            this.markSectionAndNeighborsAsAffected(var0);
            this.hasInconsistencies = true;
        }
    }

    private void removeSection(long var0) {
        this.toRemove.add(var0);
        this.hasInconsistencies = true;
    }

    protected void swapSectionMap() {
        Object var0;
        if (!this.changedSections.isEmpty()) {
            var0 = ((LightEngineStorageArray)this.updatingSectionData).copy();
            ((LightEngineStorageArray)var0).disableCache();
            this.visibleSectionData = var0;
            this.changedSections.clear();
        }
        if (!this.sectionsAffectedByLightUpdates.isEmpty()) {
            var0 = this.sectionsAffectedByLightUpdates.iterator();
            while (var0.hasNext()) {
                long var1 = var0.nextLong();
                this.chunkSource.onLightUpdate(this.layer, SectionPosition.of(var1));
            }
            this.sectionsAffectedByLightUpdates.clear();
        }
    }

    public b getDebugSectionType(long var0) {
        return a.type(this.sectionStates.get(var0));
    }

    protected static class a {
        public static final byte EMPTY = 0;
        private static final int MIN_NEIGHBORS = 0;
        private static final int MAX_NEIGHBORS = 26;
        private static final byte HAS_DATA_BIT = 32;
        private static final byte NEIGHBOR_COUNT_BITS = 31;

        protected a() {
        }

        public static byte hasData(byte var0, boolean var1) {
            return (byte)(var1 ? var0 | 0x20 : var0 & 0xFFFFFFDF);
        }

        public static byte neighborCount(byte var0, int var1) {
            if (var1 < 0 || var1 > 26) {
                throw new IllegalArgumentException("Neighbor count was not within range [0; 26]");
            }
            return (byte)(var0 & 0xFFFFFFE0 | var1 & 0x1F);
        }

        public static boolean hasData(byte var0) {
            return (var0 & 0x20) != 0;
        }

        public static int neighborCount(byte var0) {
            return var0 & 0x1F;
        }

        public static b type(byte var0) {
            if (var0 == 0) {
                return b.EMPTY;
            }
            if (a.hasData(var0)) {
                return b.LIGHT_AND_DATA;
            }
            return b.LIGHT_ONLY;
        }
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b EMPTY = new b("2");
        public static final /* enum */ b LIGHT_ONLY = new b("1");
        public static final /* enum */ b LIGHT_AND_DATA = new b("0");
        private final String display;
        private static final /* synthetic */ b[] e;

        public static b[] values() {
            return (b[])e.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(String var2) {
            this.display = var2;
        }

        public String display() {
            return this.display;
        }

        private static /* synthetic */ b[] b() {
            return new b[]{EMPTY, LIGHT_ONLY, LIGHT_AND_DATA};
        }

        static {
            e = b.b();
        }
    }
}

