/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTables;

public class EndCityPieces {
    private static final int MAX_GEN_DEPTH = 8;
    static final b HOUSE_TOWER_GENERATOR = new b(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager var0, int var1, a var2, BlockPosition var3, List<StructurePiece> var4, RandomSource var5) {
            if (var1 > 8) {
                return false;
            }
            EnumBlockRotation var6 = var2.placeSettings().getRotation();
            a var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var2, var3, "base_floor", var6, true));
            int var8 = var5.nextInt(3);
            if (var8 == 0) {
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 4, -1), "base_roof", var6, true));
            } else if (var8 == 1) {
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 0, -1), "second_floor_2", var6, false));
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 8, -1), "second_roof", var6, false));
                EndCityPieces.recursiveChildren(var0, TOWER_GENERATOR, var1 + 1, var7, null, var4, var5);
            } else if (var8 == 2) {
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 0, -1), "second_floor_2", var6, false));
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 4, -1), "third_floor_2", var6, false));
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 8, -1), "third_roof", var6, true));
                EndCityPieces.recursiveChildren(var0, TOWER_GENERATOR, var1 + 1, var7, null, var4, var5);
            }
            return true;
        }
    };
    static final List<Tuple<EnumBlockRotation, BlockPosition>> TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.NONE, new BlockPosition(1, -1, 0)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_90, new BlockPosition(6, -1, 1)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.COUNTERCLOCKWISE_90, new BlockPosition(0, -1, 5)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_180, new BlockPosition(5, -1, 6))});
    static final b TOWER_GENERATOR = new b(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager var0, int var1, a var2, BlockPosition var3, List<StructurePiece> var4, RandomSource var5) {
            EnumBlockRotation var6 = var2.placeSettings().getRotation();
            a var7 = var2;
            var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(3 + var5.nextInt(2), -3, 3 + var5.nextInt(2)), "tower_base", var6, true));
            var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(0, 7, 0), "tower_piece", var6, true));
            a var8 = var5.nextInt(3) == 0 ? var7 : null;
            int var9 = 1 + var5.nextInt(3);
            for (int var10 = 0; var10 < var9; ++var10) {
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(0, 4, 0), "tower_piece", var6, true));
                if (var10 >= var9 - 1 || !var5.nextBoolean()) continue;
                var8 = var7;
            }
            if (var8 != null) {
                for (Tuple<EnumBlockRotation, BlockPosition> var11 : TOWER_BRIDGES) {
                    if (!var5.nextBoolean()) continue;
                    a var12 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var8, var11.getB(), "bridge_end", var6.getRotated(var11.getA()), true));
                    EndCityPieces.recursiveChildren(var0, TOWER_BRIDGE_GENERATOR, var1 + 1, var12, null, var4, var5);
                }
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 4, -1), "tower_top", var6, true));
            } else if (var1 == 7) {
                var7 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var7, new BlockPosition(-1, 4, -1), "tower_top", var6, true));
            } else {
                return EndCityPieces.recursiveChildren(var0, FAT_TOWER_GENERATOR, var1 + 1, var7, null, var4, var5);
            }
            return true;
        }
    };
    static final b TOWER_BRIDGE_GENERATOR = new b(){
        public boolean shipCreated;

        @Override
        public void init() {
            this.shipCreated = false;
        }

        @Override
        public boolean generate(StructureTemplateManager var0, int var1, a var2, BlockPosition var3, List<StructurePiece> var4, RandomSource var5) {
            EnumBlockRotation var6 = var2.placeSettings().getRotation();
            int var7 = var5.nextInt(4) + 1;
            a var8 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var2, new BlockPosition(0, 0, -4), "bridge_piece", var6, true));
            var8.setGenDepth(-1);
            int var9 = 0;
            for (int var10 = 0; var10 < var7; ++var10) {
                if (var5.nextBoolean()) {
                    var8 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var8, new BlockPosition(0, var9, -4), "bridge_piece", var6, true));
                    var9 = 0;
                    continue;
                }
                var8 = var5.nextBoolean() ? EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var8, new BlockPosition(0, var9, -4), "bridge_steep_stairs", var6, true)) : EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var8, new BlockPosition(0, var9, -8), "bridge_gentle_stairs", var6, true));
                var9 = 4;
            }
            if (this.shipCreated || var5.nextInt(10 - var1) != 0) {
                if (!EndCityPieces.recursiveChildren(var0, HOUSE_TOWER_GENERATOR, var1 + 1, var8, new BlockPosition(-3, var9 + 1, -11), var4, var5)) {
                    return false;
                }
            } else {
                EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var8, new BlockPosition(-8 + var5.nextInt(8), var9, -70 + var5.nextInt(10)), "ship", var6, true));
                this.shipCreated = true;
            }
            var8 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var8, new BlockPosition(4, var9, 0), "bridge_end", var6.getRotated(EnumBlockRotation.CLOCKWISE_180), true));
            var8.setGenDepth(-1);
            return true;
        }
    };
    static final List<Tuple<EnumBlockRotation, BlockPosition>> FAT_TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.NONE, new BlockPosition(4, -1, 0)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_90, new BlockPosition(12, -1, 4)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.COUNTERCLOCKWISE_90, new BlockPosition(0, -1, 8)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_180, new BlockPosition(8, -1, 12))});
    static final b FAT_TOWER_GENERATOR = new b(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager var0, int var1, a var2, BlockPosition var3, List<StructurePiece> var4, RandomSource var5) {
            EnumBlockRotation var7 = var2.placeSettings().getRotation();
            a var6 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var2, new BlockPosition(-3, 4, -3), "fat_tower_base", var7, true));
            var6 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var6, new BlockPosition(0, 4, 0), "fat_tower_middle", var7, true));
            for (int var8 = 0; var8 < 2 && var5.nextInt(3) != 0; ++var8) {
                var6 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var6, new BlockPosition(0, 8, 0), "fat_tower_middle", var7, true));
                for (Tuple<EnumBlockRotation, BlockPosition> var10 : FAT_TOWER_BRIDGES) {
                    if (!var5.nextBoolean()) continue;
                    a var11 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var6, var10.getB(), "bridge_end", var7.getRotated(var10.getA()), true));
                    EndCityPieces.recursiveChildren(var0, TOWER_BRIDGE_GENERATOR, var1 + 1, var11, null, var4, var5);
                }
            }
            var6 = EndCityPieces.addHelper(var4, EndCityPieces.addPiece(var0, var6, new BlockPosition(-2, 8, -2), "fat_tower_top", var7, true));
            return true;
        }
    };

    static a addPiece(StructureTemplateManager var0, a var1, BlockPosition var2, String var3, EnumBlockRotation var4, boolean var5) {
        a var6 = new a(var0, var3, var1.templatePosition(), var4, var5);
        BlockPosition var7 = var1.template().calculateConnectedPosition(var1.placeSettings(), var2, var6.placeSettings(), BlockPosition.ZERO);
        var6.move(var7.getX(), var7.getY(), var7.getZ());
        return var6;
    }

    public static void startHouseTower(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, List<StructurePiece> var3, RandomSource var4) {
        FAT_TOWER_GENERATOR.init();
        HOUSE_TOWER_GENERATOR.init();
        TOWER_BRIDGE_GENERATOR.init();
        TOWER_GENERATOR.init();
        a var5 = EndCityPieces.addHelper(var3, new a(var0, "base_floor", var1, var2, true));
        var5 = EndCityPieces.addHelper(var3, EndCityPieces.addPiece(var0, var5, new BlockPosition(-1, 0, -1), "second_floor_1", var2, false));
        var5 = EndCityPieces.addHelper(var3, EndCityPieces.addPiece(var0, var5, new BlockPosition(-1, 4, -1), "third_floor_1", var2, false));
        var5 = EndCityPieces.addHelper(var3, EndCityPieces.addPiece(var0, var5, new BlockPosition(-1, 8, -1), "third_roof", var2, true));
        EndCityPieces.recursiveChildren(var0, TOWER_GENERATOR, 1, var5, null, var3, var4);
    }

    static a addHelper(List<StructurePiece> var0, a var1) {
        var0.add(var1);
        return var1;
    }

    static boolean recursiveChildren(StructureTemplateManager var0, b var1, int var2, a var3, BlockPosition var4, List<StructurePiece> var5, RandomSource var6) {
        if (var2 > 8) {
            return false;
        }
        ArrayList var7 = Lists.newArrayList();
        if (var1.generate(var0, var2, var3, var4, var7, var6)) {
            boolean var8 = false;
            int var9 = var6.nextInt();
            for (StructurePiece var11 : var7) {
                var11.setGenDepth(var9);
                StructurePiece var12 = StructurePiece.findCollisionPiece(var5, var11.getBoundingBox());
                if (var12 == null || var12.getGenDepth() == var3.getGenDepth()) continue;
                var8 = true;
                break;
            }
            if (!var8) {
                var5.addAll(var7);
                return true;
            }
        }
        return false;
    }

    public static class a
    extends DefinedStructurePiece {
        public a(StructureTemplateManager var0, String var1, BlockPosition var2, EnumBlockRotation var3, boolean var4) {
            super(WorldGenFeatureStructurePieceType.END_CITY_PIECE, 0, var0, a.makeIdentifier(var1), var1, a.makeSettings(var4, var3), var2);
        }

        public a(StructureTemplateManager var0, NBTTagCompound var12) {
            super(WorldGenFeatureStructurePieceType.END_CITY_PIECE, var12, var0, var1 -> a.makeSettings(var12.getBooleanOr("OW", false), var12.read("Rot", EnumBlockRotation.LEGACY_CODEC).orElseThrow()));
        }

        private static DefinedStructureInfo makeSettings(boolean var0, EnumBlockRotation var1) {
            DefinedStructureProcessorBlockIgnore var2 = var0 ? DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK : DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR;
            return new DefinedStructureInfo().setIgnoreEntities(true).addProcessor(var2).setRotation(var1);
        }

        @Override
        protected MinecraftKey makeTemplateLocation() {
            return a.makeIdentifier(this.templateName);
        }

        private static MinecraftKey makeIdentifier(String var0) {
            return MinecraftKey.withDefaultNamespace("end_city/" + var0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.store("Rot", EnumBlockRotation.LEGACY_CODEC, this.placeSettings.getRotation());
            var1.putBoolean("OW", this.placeSettings.getProcessors().get(0) == DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK);
        }

        @Override
        protected void handleDataMarker(String var0, BlockPosition var1, WorldAccess var2, RandomSource var3, StructureBoundingBox var4) {
            if (var0.startsWith("Chest")) {
                BlockPosition var5 = var1.below();
                if (var4.isInside(var5)) {
                    RandomizableContainer.setBlockEntityLootTable(var2, var3, var5, LootTables.END_CITY_TREASURE);
                }
            } else if (var4.isInside(var1) && World.isInSpawnableBounds(var1)) {
                if (var0.startsWith("Sentry")) {
                    EntityShulker var5 = EntityTypes.SHULKER.create(var2.getLevel(), EntitySpawnReason.STRUCTURE);
                    if (var5 != null) {
                        var5.setPos((double)var1.getX() + 0.5, var1.getY(), (double)var1.getZ() + 0.5);
                        var2.addFreshEntity(var5);
                    }
                } else if (var0.startsWith("Elytra")) {
                    EntityItemFrame var5 = new EntityItemFrame(var2.getLevel(), var1, this.placeSettings.getRotation().rotate(EnumDirection.SOUTH));
                    var5.setItem(new ItemStack(Items.ELYTRA), false);
                    var2.addFreshEntity(var5);
                }
            }
        }
    }

    static interface b {
        public void init();

        public boolean generate(StructureTemplateManager var1, int var2, a var3, BlockPosition var4, List<StructurePiece> var5, RandomSource var6);
    }
}

