/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorJigsawReplacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeatureDefinedStructurePoolSingle
extends WorldGenFeatureDefinedStructurePoolStructure {
    private static final Comparator<DefinedStructure.a> HIGHEST_SELECTION_PRIORITY_FIRST = Comparator.comparingInt(DefinedStructure.a::selectionPriority).reversed();
    private static final Codec<Either<MinecraftKey, DefinedStructure>> TEMPLATE_CODEC = Codec.of(WorldGenFeatureDefinedStructurePoolSingle::encodeTemplate, (Decoder)MinecraftKey.CODEC.map(Either::left));
    public static final MapCodec<WorldGenFeatureDefinedStructurePoolSingle> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group(WorldGenFeatureDefinedStructurePoolSingle.templateCodec(), WorldGenFeatureDefinedStructurePoolSingle.processorsCodec(), WorldGenFeatureDefinedStructurePoolSingle.projectionCodec(), WorldGenFeatureDefinedStructurePoolSingle.overrideLiquidSettingsCodec()).apply((Applicative)var0, WorldGenFeatureDefinedStructurePoolSingle::new));
    protected final Either<MinecraftKey, DefinedStructure> template;
    protected final Holder<ProcessorList> processors;
    protected final Optional<LiquidSettings> overrideLiquidSettings;

    private static <T> DataResult<T> encodeTemplate(Either<MinecraftKey, DefinedStructure> var0, DynamicOps<T> var1, T var2) {
        Optional var3 = var0.left();
        if (var3.isEmpty()) {
            return DataResult.error(() -> "Can not serialize a runtime pool element");
        }
        return MinecraftKey.CODEC.encode((Object)((MinecraftKey)var3.get()), var1, var2);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Holder<ProcessorList>> processorsCodec() {
        return DefinedStructureStructureProcessorType.LIST_CODEC.fieldOf("processors").forGetter(var0 -> var0.processors);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Optional<LiquidSettings>> overrideLiquidSettingsCodec() {
        return LiquidSettings.CODEC.optionalFieldOf("override_liquid_settings").forGetter(var0 -> var0.overrideLiquidSettings);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Either<MinecraftKey, DefinedStructure>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(var0 -> var0.template);
    }

    protected WorldGenFeatureDefinedStructurePoolSingle(Either<MinecraftKey, DefinedStructure> var0, Holder<ProcessorList> var1, WorldGenFeatureDefinedStructurePoolTemplate.Matching var2, Optional<LiquidSettings> var3) {
        super(var2);
        this.template = var0;
        this.processors = var1;
        this.overrideLiquidSettings = var3;
    }

    @Override
    public BaseBlockPosition getSize(StructureTemplateManager var0, EnumBlockRotation var1) {
        DefinedStructure var2 = this.getTemplate(var0);
        return var2.getSize(var1);
    }

    private DefinedStructure getTemplate(StructureTemplateManager var0) {
        return (DefinedStructure)this.template.map(var0::getOrCreate, Function.identity());
    }

    public List<DefinedStructure.BlockInfo> getDataMarkers(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, boolean var3) {
        DefinedStructure var4 = this.getTemplate(var0);
        ObjectArrayList<DefinedStructure.BlockInfo> var5 = var4.filterBlocks(var1, new DefinedStructureInfo().setRotation(var2), Blocks.STRUCTURE_BLOCK, var3);
        ArrayList var6 = Lists.newArrayList();
        for (DefinedStructure.BlockInfo var8 : var5) {
            BlockPropertyStructureMode var10;
            NBTTagCompound var9 = var8.nbt();
            if (var9 == null || (var10 = var9.read("mode", BlockPropertyStructureMode.LEGACY_CODEC).orElseThrow()) != BlockPropertyStructureMode.DATA) continue;
            var6.add(var8);
        }
        return var6;
    }

    @Override
    public List<DefinedStructure.a> getShuffledJigsawBlocks(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, RandomSource var3) {
        List<DefinedStructure.a> var4 = this.getTemplate(var0).getJigsaws(var1, var2);
        SystemUtils.shuffle(var4, var3);
        WorldGenFeatureDefinedStructurePoolSingle.sortBySelectionPriority(var4);
        return var4;
    }

    @VisibleForTesting
    static void sortBySelectionPriority(List<DefinedStructure.a> var0) {
        var0.sort(HIGHEST_SELECTION_PRIORITY_FIRST);
    }

    @Override
    public StructureBoundingBox getBoundingBox(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2) {
        DefinedStructure var3 = this.getTemplate(var0);
        return var3.getBoundingBox(new DefinedStructureInfo().setRotation(var2), var1);
    }

    @Override
    public boolean place(StructureTemplateManager var0, GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, BlockPosition var4, BlockPosition var5, EnumBlockRotation var6, StructureBoundingBox var7, RandomSource var8, LiquidSettings var9, boolean var10) {
        DefinedStructureInfo var12;
        DefinedStructure var11 = this.getTemplate(var0);
        if (var11.placeInWorld(var1, var4, var5, var12 = this.getSettings(var6, var7, var9, var10), var8, 18)) {
            List<DefinedStructure.BlockInfo> var13 = DefinedStructure.processBlockInfos(var1, var4, var5, var12, this.getDataMarkers(var0, var4, var6, false));
            for (DefinedStructure.BlockInfo var15 : var13) {
                this.handleDataMarker(var1, var15, var4, var6, var8, var7);
            }
            return true;
        }
        return false;
    }

    protected DefinedStructureInfo getSettings(EnumBlockRotation var0, StructureBoundingBox var1, LiquidSettings var2, boolean var3) {
        DefinedStructureInfo var4 = new DefinedStructureInfo();
        var4.setBoundingBox(var1);
        var4.setRotation(var0);
        var4.setKnownShape(true);
        var4.setIgnoreEntities(false);
        var4.addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK);
        var4.setFinalizeEntities(true);
        var4.setLiquidSettings(this.overrideLiquidSettings.orElse(var2));
        if (!var3) {
            var4.addProcessor(DefinedStructureProcessorJigsawReplacement.INSTANCE);
        }
        this.processors.value().list().forEach(var4::addProcessor);
        this.getProjection().getProcessors().forEach(var4::addProcessor);
        return var4;
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> getType() {
        return WorldGenFeatureDefinedStructurePools.SINGLE;
    }

    public String toString() {
        return "Single[" + String.valueOf(this.template) + "]";
    }

    @VisibleForTesting
    public MinecraftKey getTemplateLocation() {
        return (MinecraftKey)this.template.orThrow();
    }
}

