/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.flat.WorldGenFlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class GeneratorSettingsFlat {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<GeneratorSettingsFlat> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RegistryCodecs.homogeneousList(Registries.STRUCTURE_SET).lenientOptionalFieldOf("structure_overrides").forGetter(var0 -> var0.structureOverrides), (App)WorldGenFlatLayerInfo.CODEC.listOf().fieldOf("layers").forGetter(GeneratorSettingsFlat::getLayersInfo), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(var0 -> var0.addLakes), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(var0 -> var0.decoration), (App)BiomeBase.CODEC.lenientOptionalFieldOf("biome").orElseGet(Optional::empty).forGetter(var0 -> Optional.of(var0.biome)), RegistryOps.retrieveElement(Biomes.PLAINS), RegistryOps.retrieveElement(MiscOverworldPlacements.LAKE_LAVA_UNDERGROUND), RegistryOps.retrieveElement(MiscOverworldPlacements.LAKE_LAVA_SURFACE)).apply((Applicative)var02, GeneratorSettingsFlat::new)).comapFlatMap(GeneratorSettingsFlat::validateHeight, Function.identity()).stable();
    private final Optional<HolderSet<StructureSet>> structureOverrides;
    private final List<WorldGenFlatLayerInfo> layersInfo = Lists.newArrayList();
    private final Holder<BiomeBase> biome;
    private final List<IBlockData> layers;
    private boolean voidGen;
    private boolean decoration;
    private boolean addLakes;
    private final List<Holder<PlacedFeature>> lakes;

    private static DataResult<GeneratorSettingsFlat> validateHeight(GeneratorSettingsFlat var0) {
        int var1 = var0.layersInfo.stream().mapToInt(WorldGenFlatLayerInfo::getHeight).sum();
        if (var1 > DimensionManager.Y_SIZE) {
            return DataResult.error(() -> "Sum of layer heights is > " + DimensionManager.Y_SIZE, (Object)var0);
        }
        return DataResult.success((Object)var0);
    }

    private GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> var0, List<WorldGenFlatLayerInfo> var1, boolean var2, boolean var3, Optional<Holder<BiomeBase>> var4, Holder.c<BiomeBase> var5, Holder<PlacedFeature> var6, Holder<PlacedFeature> var7) {
        this(var0, GeneratorSettingsFlat.getBiome(var4, var5), List.of(var6, var7));
        if (var2) {
            this.setAddLakes();
        }
        if (var3) {
            this.setDecoration();
        }
        this.layersInfo.addAll(var1);
        this.updateLayers();
    }

    private static Holder<BiomeBase> getBiome(Optional<? extends Holder<BiomeBase>> var0, Holder<BiomeBase> var1) {
        if (var0.isEmpty()) {
            LOGGER.error("Unknown biome, defaulting to plains");
            return var1;
        }
        return var0.get();
    }

    public GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> var0, Holder<BiomeBase> var1, List<Holder<PlacedFeature>> var2) {
        this.structureOverrides = var0;
        this.biome = var1;
        this.layers = Lists.newArrayList();
        this.lakes = var2;
    }

    public GeneratorSettingsFlat withBiomeAndLayers(List<WorldGenFlatLayerInfo> var0, Optional<HolderSet<StructureSet>> var1, Holder<BiomeBase> var2) {
        GeneratorSettingsFlat var3 = new GeneratorSettingsFlat(var1, var2, this.lakes);
        for (WorldGenFlatLayerInfo var5 : var0) {
            var3.layersInfo.add(new WorldGenFlatLayerInfo(var5.getHeight(), var5.getBlockState().getBlock()));
            var3.updateLayers();
        }
        if (this.decoration) {
            var3.setDecoration();
        }
        if (this.addLakes) {
            var3.setAddLakes();
        }
        return var3;
    }

    public void setDecoration() {
        this.decoration = true;
    }

    public void setAddLakes() {
        this.addLakes = true;
    }

    public BiomeSettingsGeneration adjustGenerationSettings(Holder<BiomeBase> var0) {
        Object var6;
        int var5;
        boolean var3;
        if (!var0.equals(this.biome)) {
            return var0.value().getGenerationSettings();
        }
        BiomeSettingsGeneration var1 = this.getBiome().value().getGenerationSettings();
        BiomeSettingsGeneration.b var2 = new BiomeSettingsGeneration.b();
        if (this.addLakes) {
            for (Holder<PlacedFeature> holder : this.lakes) {
                var2.addFeature(WorldGenStage.Decoration.LAKES, holder);
            }
        }
        boolean bl = var3 = (!this.voidGen || var0.is(Biomes.THE_VOID)) && this.decoration;
        if (var3) {
            List<HolderSet<PlacedFeature>> list = var1.features();
            for (var5 = 0; var5 < list.size(); ++var5) {
                if (var5 == WorldGenStage.Decoration.UNDERGROUND_STRUCTURES.ordinal() || var5 == WorldGenStage.Decoration.SURFACE_STRUCTURES.ordinal() || this.addLakes && var5 == WorldGenStage.Decoration.LAKES.ordinal()) continue;
                var6 = list.get(var5);
                Iterator iterator = var6.iterator();
                while (iterator.hasNext()) {
                    Holder var8 = (Holder)iterator.next();
                    var2.addFeature(var5, (Holder<PlacedFeature>)var8);
                }
            }
        }
        List<IBlockData> list = this.getLayers();
        for (var5 = 0; var5 < list.size(); ++var5) {
            var6 = list.get(var5);
            if (HeightMap.Type.MOTION_BLOCKING.isOpaque().test((IBlockData)var6)) continue;
            list.set(var5, null);
            var2.addFeature(WorldGenStage.Decoration.TOP_LAYER_MODIFICATION, PlacementUtils.inlinePlaced(WorldGenerator.FILL_LAYER, new WorldGenFeatureFillConfiguration(var5, (IBlockData)var6), new PlacementModifier[0]));
        }
        return var2.build();
    }

    public Optional<HolderSet<StructureSet>> structureOverrides() {
        return this.structureOverrides;
    }

    public Holder<BiomeBase> getBiome() {
        return this.biome;
    }

    public List<WorldGenFlatLayerInfo> getLayersInfo() {
        return this.layersInfo;
    }

    public List<IBlockData> getLayers() {
        return this.layers;
    }

    public void updateLayers() {
        this.layers.clear();
        for (WorldGenFlatLayerInfo var1 : this.layersInfo) {
            for (int var2 = 0; var2 < var1.getHeight(); ++var2) {
                this.layers.add(var1.getBlockState());
            }
        }
        this.voidGen = this.layers.stream().allMatch(var0 -> var0.is(Blocks.AIR));
    }

    public static GeneratorSettingsFlat getDefault(HolderGetter<BiomeBase> var0, HolderGetter<StructureSet> var1, HolderGetter<PlacedFeature> var2) {
        HolderSet.a var3 = HolderSet.direct(var1.getOrThrow(BuiltinStructureSets.STRONGHOLDS), var1.getOrThrow(BuiltinStructureSets.VILLAGES));
        GeneratorSettingsFlat var4 = new GeneratorSettingsFlat(Optional.of(var3), GeneratorSettingsFlat.getDefaultBiome(var0), GeneratorSettingsFlat.createLakesList(var2));
        var4.getLayersInfo().add(new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
        var4.getLayersInfo().add(new WorldGenFlatLayerInfo(2, Blocks.DIRT));
        var4.getLayersInfo().add(new WorldGenFlatLayerInfo(1, Blocks.GRASS_BLOCK));
        var4.updateLayers();
        return var4;
    }

    public static Holder<BiomeBase> getDefaultBiome(HolderGetter<BiomeBase> var0) {
        return var0.getOrThrow(Biomes.PLAINS);
    }

    public static List<Holder<PlacedFeature>> createLakesList(HolderGetter<PlacedFeature> var0) {
        return List.of(var0.getOrThrow(MiscOverworldPlacements.LAKE_LAVA_UNDERGROUND), var0.getOrThrow(MiscOverworldPlacements.LAKE_LAVA_SURFACE));
    }
}

