/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class AttachedToLogsDecorator
extends WorldGenFeatureTree {
    public static final MapCodec<AttachedToLogsDecorator> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(var0 -> Float.valueOf(var0.probability)), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("block_provider").forGetter(var0 -> var0.blockProvider), (App)ExtraCodecs.nonEmptyList(EnumDirection.CODEC.listOf()).fieldOf("directions").forGetter(var0 -> var0.directions)).apply((Applicative)var02, AttachedToLogsDecorator::new));
    private final float probability;
    private final WorldGenFeatureStateProvider blockProvider;
    private final List<EnumDirection> directions;

    public AttachedToLogsDecorator(float var0, WorldGenFeatureStateProvider var1, List<EnumDirection> var2) {
        this.probability = var0;
        this.blockProvider = var1;
        this.directions = var2;
    }

    @Override
    public void place(WorldGenFeatureTree.a var0) {
        RandomSource var1 = var0.random();
        for (BlockPosition var3 : SystemUtils.shuffledCopy(var0.logs(), var1)) {
            EnumDirection var4 = SystemUtils.getRandom(this.directions, var1);
            BlockPosition var5 = var3.relative(var4);
            if (!(var1.nextFloat() <= this.probability) || !var0.isAir(var5)) continue;
            var0.setBlock(var5, this.blockProvider.getState(var1, var5));
        }
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.ATTACHED_TO_LOGS;
    }
}

