/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;

public class GeodeFeature
extends WorldGenerator<GeodeConfiguration> {
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();

    public GeodeFeature(Codec<GeodeConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<GeodeConfiguration> var0) {
        IBlockData var34;
        int var30;
        int var29;
        GeodeConfiguration var1 = var0.config();
        RandomSource var2 = var0.random();
        BlockPosition var3 = var0.origin();
        GeneratorAccessSeed var4 = var0.level();
        int var5 = var1.minGenOffset;
        int var6 = var1.maxGenOffset;
        LinkedList var7 = Lists.newLinkedList();
        int var8 = var1.distributionPoints.sample(var2);
        SeededRandom var9 = new SeededRandom(new LegacyRandomSource(var4.getSeed()));
        NoiseGeneratorNormal var10 = NoiseGeneratorNormal.create(var9, -4, 1.0);
        LinkedList var11 = Lists.newLinkedList();
        double var12 = (double)var8 / (double)var1.outerWallDistance.getMaxValue();
        GeodeLayerSettings var14 = var1.geodeLayerSettings;
        GeodeBlockSettings var15 = var1.geodeBlockSettings;
        GeodeCrackSettings var16 = var1.geodeCrackSettings;
        double var17 = 1.0 / Math.sqrt(var14.filling);
        double var19 = 1.0 / Math.sqrt(var14.innerLayer + var12);
        double var21 = 1.0 / Math.sqrt(var14.middleLayer + var12);
        double var23 = 1.0 / Math.sqrt(var14.outerLayer + var12);
        double var25 = 1.0 / Math.sqrt(var16.baseCrackSize + var2.nextDouble() / 2.0 + (var8 > 3 ? var12 : 0.0));
        boolean var27 = (double)var2.nextFloat() < var16.generateCrackChance;
        int var28 = 0;
        for (var29 = 0; var29 < var8; ++var29) {
            int var32;
            int var31;
            var30 = var1.outerWallDistance.sample(var2);
            BlockPosition var33 = var3.offset(var30, var31 = var1.outerWallDistance.sample(var2), var32 = var1.outerWallDistance.sample(var2));
            var34 = var4.getBlockState(var33);
            if ((var34.isAir() || var34.is(var15.invalidBlocks)) && ++var28 > var1.invalidBlocksThreshold) {
                return false;
            }
            var7.add(Pair.of((Object)var33, (Object)var1.pointOffset.sample(var2)));
        }
        if (var27) {
            var29 = var2.nextInt(4);
            var30 = var8 * 2 + 1;
            if (var29 == 0) {
                var11.add(var3.offset(var30, 7, 0));
                var11.add(var3.offset(var30, 5, 0));
                var11.add(var3.offset(var30, 1, 0));
            } else if (var29 == 1) {
                var11.add(var3.offset(0, 7, var30));
                var11.add(var3.offset(0, 5, var30));
                var11.add(var3.offset(0, 1, var30));
            } else if (var29 == 2) {
                var11.add(var3.offset(var30, 7, var30));
                var11.add(var3.offset(var30, 5, var30));
                var11.add(var3.offset(var30, 1, var30));
            } else {
                var11.add(var3.offset(0, 7, 0));
                var11.add(var3.offset(0, 5, 0));
                var11.add(var3.offset(0, 1, 0));
            }
        }
        ArrayList var292 = Lists.newArrayList();
        Predicate<IBlockData> var302 = GeodeFeature.isReplaceable(var1.geodeBlockSettings.cannotReplace);
        for (BlockPosition var32 : BlockPosition.betweenClosed(var3.offset(var5, var5, var5), var3.offset(var6, var6, var6))) {
            double var33 = var10.getValue(var32.getX(), var32.getY(), var32.getZ()) * var1.noiseMultiplier;
            double var35 = 0.0;
            double var37 = 0.0;
            for (Object var40 : var7) {
                var35 += MathHelper.invSqrt(var32.distSqr((BaseBlockPosition)var40.getFirst()) + (double)((Integer)var40.getSecond()).intValue()) + var33;
            }
            for (Object var40 : var11) {
                var37 += MathHelper.invSqrt(var32.distSqr((BaseBlockPosition)var40) + (double)var16.crackPointOffset) + var33;
            }
            if (var35 < var23) continue;
            if (var27 && var37 >= var25 && var35 < var17) {
                this.safeSetBlock(var4, var32, Blocks.AIR.defaultBlockState(), var302);
                for (EnumDirection var42 : DIRECTIONS) {
                    BlockPosition var43 = var32.relative(var42);
                    Fluid var44 = var4.getFluidState(var43);
                    if (var44.isEmpty()) continue;
                    var4.scheduleTick(var43, var44.getType(), 0);
                }
                continue;
            }
            if (var35 >= var17) {
                this.safeSetBlock(var4, var32, var15.fillingProvider.getState(var2, var32), var302);
                continue;
            }
            if (var35 >= var19) {
                boolean var39;
                boolean bl = var39 = (double)var2.nextFloat() < var1.useAlternateLayer0Chance;
                if (var39) {
                    this.safeSetBlock(var4, var32, var15.alternateInnerLayerProvider.getState(var2, var32), var302);
                } else {
                    this.safeSetBlock(var4, var32, var15.innerLayerProvider.getState(var2, var32), var302);
                }
                if (var1.placementsRequireLayer0Alternate && !var39 || !((double)var2.nextFloat() < var1.usePotentialPlacementsChance)) continue;
                var292.add(var32.immutable());
                continue;
            }
            if (var35 >= var21) {
                this.safeSetBlock(var4, var32, var15.middleLayerProvider.getState(var2, var32), var302);
                continue;
            }
            if (!(var35 >= var23)) continue;
            this.safeSetBlock(var4, var32, var15.outerLayerProvider.getState(var2, var32), var302);
        }
        List<IBlockData> var31 = var15.innerPlacements;
        block5: for (BlockPosition var33 : var292) {
            var34 = (IBlockData)SystemUtils.getRandom(var31, var2);
            for (EnumDirection var38 : DIRECTIONS) {
                if (var34.hasProperty(BlockProperties.FACING)) {
                    var34 = (IBlockData)var34.setValue(BlockProperties.FACING, var38);
                }
                BlockPosition var39 = var33.relative(var38);
                IBlockData var40 = var4.getBlockState(var39);
                if (var34.hasProperty(BlockProperties.WATERLOGGED)) {
                    var34 = (IBlockData)var34.setValue(BlockProperties.WATERLOGGED, var40.getFluidState().isSource());
                }
                if (!BuddingAmethystBlock.canClusterGrowAtState(var40)) continue;
                this.safeSetBlock(var4, var39, var34, var302);
                continue block5;
            }
        }
        return true;
    }
}

