/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.Fluid;

public class MobSpawnerPhantom
implements MobSpawner {
    private int nextTick;

    @Override
    public void tick(WorldServer var0, boolean var1) {
        if (!var1) {
            return;
        }
        if (!var0.getGameRules().get(GameRules.SPAWN_PHANTOMS).booleanValue()) {
            return;
        }
        RandomSource var2 = var0.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return;
        }
        this.nextTick += (60 + var2.nextInt(60)) * 20;
        if (var0.getSkyDarken() < 5 && var0.dimensionType().hasSkyLight()) {
            return;
        }
        for (EntityPlayer var4 : var0.players()) {
            Fluid var12;
            IBlockData var11;
            BlockPosition var10;
            DifficultyDamageScaler var6;
            if (var4.isSpectator()) continue;
            BlockPosition var5 = var4.blockPosition();
            if (var0.dimensionType().hasSkyLight() && (var5.getY() < var0.getSeaLevel() || !var0.canSeeSky(var5)) || !(var6 = var0.getCurrentDifficultyAt(var5)).isHarderThan(var2.nextFloat() * 3.0f)) continue;
            ServerStatisticManager var7 = var4.getStats();
            int var8 = MathHelper.clamp(var7.getValue(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
            int var9 = 24000;
            if (var2.nextInt(var8) < 72000 || !SpawnerCreature.isValidEmptySpawnBlock(var0, var10 = var5.above(20 + var2.nextInt(15)).east(-10 + var2.nextInt(21)).south(-10 + var2.nextInt(21)), var11 = var0.getBlockState(var10), var12 = var0.getFluidState(var10), EntityTypes.PHANTOM)) continue;
            GroupDataEntity var13 = null;
            int var14 = 1 + var2.nextInt(var6.getDifficulty().getId() + 1);
            for (int var15 = 0; var15 < var14; ++var15) {
                EntityPhantom var16 = EntityTypes.PHANTOM.create(var0, EntitySpawnReason.NATURAL);
                if (var16 == null) continue;
                var16.snapTo(var10, 0.0f, 0.0f);
                var13 = var16.finalizeSpawn(var0, var6, EntitySpawnReason.NATURAL, var13);
                var0.addFreshEntityWithPassengers(var16);
            }
        }
    }
}

