/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkGeneratorStructureState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomState randomState;
    private final WorldChunkManager biomeSource;
    private final long levelSeed;
    private final long concentricRingsSeed;
    private final Map<Structure, List<StructurePlacement>> placementsForStructure = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkCoordIntPair>>> ringPositions = new Object2ObjectArrayMap();
    private boolean hasGeneratedPositions;
    private final List<Holder<StructureSet>> possibleStructureSets;

    public static ChunkGeneratorStructureState createForFlat(RandomState var0, long var12, WorldChunkManager var3, Stream<Holder<StructureSet>> var4) {
        List<Holder<StructureSet>> var5 = var4.filter(var1 -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)var1.value(), var3)).toList();
        return new ChunkGeneratorStructureState(var0, var3, var12, 0L, var5);
    }

    public static ChunkGeneratorStructureState createForNormal(RandomState var0, long var12, WorldChunkManager var3, HolderLookup<StructureSet> var4) {
        List<Holder<StructureSet>> var5 = var4.listElements().filter(var1 -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)var1.value(), var3)).collect(Collectors.toUnmodifiableList());
        return new ChunkGeneratorStructureState(var0, var3, var12, var12, var5);
    }

    private static boolean hasBiomesForStructureSet(StructureSet var02, WorldChunkManager var1) {
        Stream var2 = var02.structures().stream().flatMap(var0 -> {
            Structure var1 = var0.structure().value();
            return var1.biomes().stream();
        });
        return var2.anyMatch(var1.possibleBiomes()::contains);
    }

    private ChunkGeneratorStructureState(RandomState var0, WorldChunkManager var1, long var2, long var4, List<Holder<StructureSet>> var6) {
        this.randomState = var0;
        this.levelSeed = var2;
        this.biomeSource = var1;
        this.concentricRingsSeed = var4;
        this.possibleStructureSets = var6;
    }

    public List<Holder<StructureSet>> possibleStructureSets() {
        return this.possibleStructureSets;
    }

    private void generatePositions() {
        Set<Holder<BiomeBase>> var0 = this.biomeSource.possibleBiomes();
        this.possibleStructureSets().forEach(var1 -> {
            StructurePlacement structurePlacement;
            StructureSet var2 = (StructureSet)var1.value();
            boolean var3 = false;
            for (StructureSet.a a2 : var2.structures()) {
                Structure var6 = a2.structure().value();
                if (!var6.biomes().stream().anyMatch(var0::contains)) continue;
                this.placementsForStructure.computeIfAbsent(var6, var0 -> new ArrayList()).add(var2.placement());
                var3 = true;
            }
            if (var3 && (structurePlacement = var2.placement()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement var4 = (ConcentricRingsStructurePlacement)structurePlacement;
                this.ringPositions.put(var4, this.generateRingPositions((Holder<StructureSet>)var1, var4));
            }
        });
    }

    private CompletableFuture<List<ChunkCoordIntPair>> generateRingPositions(Holder<StructureSet> var0, ConcentricRingsStructurePlacement var1) {
        if (var1.count() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        Stopwatch var22 = Stopwatch.createStarted((Ticker)SystemUtils.TICKER);
        int var3 = var1.distance();
        int var4 = var1.count();
        ArrayList<CompletableFuture<ChunkCoordIntPair>> var5 = new ArrayList<CompletableFuture<ChunkCoordIntPair>>(var4);
        int var6 = var1.spread();
        HolderSet<BiomeBase> var7 = var1.preferredBiomes();
        RandomSource var8 = RandomSource.create();
        var8.setSeed(this.concentricRingsSeed);
        double var9 = var8.nextDouble() * Math.PI * 2.0;
        int var11 = 0;
        int var12 = 0;
        for (int var13 = 0; var13 < var4; ++var13) {
            double var14 = (double)(4 * var3 + var3 * var12 * 6) + (var8.nextDouble() - 0.5) * ((double)var3 * 2.5);
            int var16 = (int)Math.round(Math.cos(var9) * var14);
            int var17 = (int)Math.round(Math.sin(var9) * var14);
            RandomSource var18 = var8.fork();
            var5.add(CompletableFuture.supplyAsync(() -> {
                Pair<BlockPosition, Holder<BiomeBase>> var4 = this.biomeSource.findBiomeHorizontal(SectionPosition.sectionToBlockCoord(var16, 8), 0, SectionPosition.sectionToBlockCoord(var17, 8), 112, var7::contains, var18, this.randomState.sampler());
                if (var4 != null) {
                    BlockPosition var5 = (BlockPosition)var4.getFirst();
                    return new ChunkCoordIntPair(SectionPosition.blockToSectionCoord(var5.getX()), SectionPosition.blockToSectionCoord(var5.getZ()));
                }
                return new ChunkCoordIntPair(var16, var17);
            }, SystemUtils.backgroundExecutor().forName("structureRings")));
            var9 += Math.PI * 2 / (double)var6;
            if (++var11 != var6) continue;
            var11 = 0;
            var6 += 2 * var6 / (++var12 + 1);
            var6 = Math.min(var6, var4 - var13);
            var9 += var8.nextDouble() * Math.PI * 2.0;
        }
        return SystemUtils.sequence(var5).thenApply(var2 -> {
            double var3 = (double)var22.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            LOGGER.debug("Calculation for {} took {}s", (Object)var0, (Object)var3);
            return var2;
        });
    }

    public void ensureStructuresGenerated() {
        if (!this.hasGeneratedPositions) {
            this.generatePositions();
            this.hasGeneratedPositions = true;
        }
    }

    public @Nullable List<ChunkCoordIntPair> getRingPositionsFor(ConcentricRingsStructurePlacement var0) {
        this.ensureStructuresGenerated();
        CompletableFuture<List<ChunkCoordIntPair>> var1 = this.ringPositions.get(var0);
        return var1 != null ? var1.join() : null;
    }

    public List<StructurePlacement> getPlacementsForStructure(Holder<Structure> var0) {
        this.ensureStructuresGenerated();
        return this.placementsForStructure.getOrDefault(var0.value(), List.of());
    }

    public RandomState randomState() {
        return this.randomState;
    }

    public boolean hasStructureChunkInRange(Holder<StructureSet> var0, int var1, int var2, int var3) {
        StructurePlacement var4 = var0.value().placement();
        for (int var5 = var1 - var3; var5 <= var1 + var3; ++var5) {
            for (int var6 = var2 - var3; var6 <= var2 + var3; ++var6) {
                if (!var4.isStructureChunk(this, var5, var6)) continue;
                return true;
            }
        }
        return false;
    }

    public long getLevelSeed() {
        return this.levelSeed;
    }
}

