/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class TileEntitySkull
extends TileEntity {
    private static final String TAG_PROFILE = "profile";
    private static final String TAG_NOTE_BLOCK_SOUND = "note_block_sound";
    private static final String TAG_CUSTOM_NAME = "custom_name";
    public @Nullable ResolvableProfile owner;
    public @Nullable MinecraftKey noteBlockSound;
    private int animationTickCount;
    private boolean isAnimating;
    private @Nullable IChatBaseComponent customName;

    public TileEntitySkull(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SKULL, var0, var1);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.storeNullable(TAG_PROFILE, ResolvableProfile.CODEC, this.owner);
        var0.storeNullable(TAG_NOTE_BLOCK_SOUND, MinecraftKey.CODEC, this.noteBlockSound);
        var0.storeNullable(TAG_CUSTOM_NAME, ComponentSerialization.CODEC, this.customName);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.owner = var0.read(TAG_PROFILE, ResolvableProfile.CODEC).orElse(null);
        this.noteBlockSound = var0.read(TAG_NOTE_BLOCK_SOUND, MinecraftKey.CODEC).orElse(null);
        this.customName = TileEntitySkull.parseCustomNameSafe(var0, TAG_CUSTOM_NAME);
    }

    public static void animation(World var0, BlockPosition var1, IBlockData var2, TileEntitySkull var3) {
        if (var2.hasProperty(BlockSkull.POWERED) && var2.getValue(BlockSkull.POWERED).booleanValue()) {
            var3.isAnimating = true;
            ++var3.animationTickCount;
        } else {
            var3.isAnimating = false;
        }
    }

    public float getAnimation(float var0) {
        if (this.isAnimating) {
            return (float)this.animationTickCount + var0;
        }
        return this.animationTickCount;
    }

    public @Nullable ResolvableProfile getOwnerProfile() {
        return this.owner;
    }

    public @Nullable MinecraftKey getNoteBlockSound() {
        return this.noteBlockSound;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        this.owner = var0.get(DataComponents.PROFILE);
        this.noteBlockSound = var0.get(DataComponents.NOTE_BLOCK_SOUND);
        this.customName = var0.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.PROFILE, this.owner);
        var0.set(DataComponents.NOTE_BLOCK_SOUND, this.noteBlockSound);
        var0.set(DataComponents.CUSTOM_NAME, this.customName);
    }

    @Override
    public void removeComponentsFromTag(ValueOutput var0) {
        super.removeComponentsFromTag(var0);
        var0.discard(TAG_PROFILE);
        var0.discard(TAG_NOTE_BLOCK_SOUND);
        var0.discard(TAG_CUSTOM_NAME);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

