/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class TileEntityConduit
extends TileEntity {
    private static final int BLOCK_REFRESH_RATE = 2;
    private static final int EFFECT_DURATION = 13;
    private static final float ROTATION_SPEED = -0.0375f;
    private static final int MIN_ACTIVE_SIZE = 16;
    private static final int MIN_KILL_SIZE = 42;
    private static final int KILL_RANGE = 8;
    private static final Block[] VALID_BLOCKS = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    public final List<BlockPosition> effectBlocks = Lists.newArrayList();
    public @Nullable EntityReference<EntityLiving> destroyTarget;
    private long nextAmbientSoundActivation;

    public TileEntityConduit(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.CONDUIT, var0, var1);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.destroyTarget = EntityReference.read(var0, "Target");
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        EntityReference.store(this.destroyTarget, var0, "Target");
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public static void clientTick(World var0, BlockPosition var1, IBlockData var2, TileEntityConduit var3) {
        ++var3.tickCount;
        long var4 = var0.getGameTime();
        List<BlockPosition> var6 = var3.effectBlocks;
        if (var4 % 40L == 0L) {
            var3.isActive = TileEntityConduit.updateShape(var0, var1, var6);
            TileEntityConduit.updateHunting(var3, var6);
        }
        EntityLiving var7 = EntityReference.getLivingEntity(var3.destroyTarget, var0);
        TileEntityConduit.animationTick(var0, var1, var6, var7, var3.tickCount);
        if (var3.isActive()) {
            var3.activeRotation += 1.0f;
        }
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityConduit var3) {
        ++var3.tickCount;
        long var4 = var0.getGameTime();
        List<BlockPosition> var6 = var3.effectBlocks;
        if (var4 % 40L == 0L) {
            boolean var7 = TileEntityConduit.updateShape(var0, var1, var6);
            if (var7 != var3.isActive) {
                SoundEffect var8 = var7 ? SoundEffects.CONDUIT_ACTIVATE : SoundEffects.CONDUIT_DEACTIVATE;
                var0.playSound(null, var1, var8, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            var3.isActive = var7;
            TileEntityConduit.updateHunting(var3, var6);
            if (var7) {
                TileEntityConduit.applyEffects(var0, var1, var6);
                TileEntityConduit.updateAndAttackTarget((WorldServer)var0, var1, var2, var3, var6.size() >= 42);
            }
        }
        if (var3.isActive()) {
            if (var4 % 80L == 0L) {
                var0.playSound(null, var1, SoundEffects.CONDUIT_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (var4 > var3.nextAmbientSoundActivation) {
                var3.nextAmbientSoundActivation = var4 + 60L + (long)var0.getRandom().nextInt(40);
                var0.playSound(null, var1, SoundEffects.CONDUIT_AMBIENT_SHORT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void updateHunting(TileEntityConduit var0, List<BlockPosition> var1) {
        var0.setHunting(var1.size() >= 42);
    }

    private static boolean updateShape(World var0, BlockPosition var1, List<BlockPosition> var2) {
        int var5;
        int var4;
        int var3;
        var2.clear();
        for (var3 = -1; var3 <= 1; ++var3) {
            for (var4 = -1; var4 <= 1; ++var4) {
                for (var5 = -1; var5 <= 1; ++var5) {
                    BlockPosition var6 = var1.offset(var3, var4, var5);
                    if (var0.isWaterAt(var6)) continue;
                    return false;
                }
            }
        }
        for (var3 = -2; var3 <= 2; ++var3) {
            for (var4 = -2; var4 <= 2; ++var4) {
                for (var5 = -2; var5 <= 2; ++var5) {
                    int var6 = Math.abs(var3);
                    int var7 = Math.abs(var4);
                    int var8 = Math.abs(var5);
                    if (var6 <= 1 && var7 <= 1 && var8 <= 1 || (var3 != 0 || var7 != 2 && var8 != 2) && (var4 != 0 || var6 != 2 && var8 != 2) && (var5 != 0 || var6 != 2 && var7 != 2)) continue;
                    BlockPosition var9 = var1.offset(var3, var4, var5);
                    IBlockData var10 = var0.getBlockState(var9);
                    for (Block var14 : VALID_BLOCKS) {
                        if (!var10.is(var14)) continue;
                        var2.add(var9);
                    }
                }
            }
        }
        return var2.size() >= 16;
    }

    private static void applyEffects(World var0, BlockPosition var1, List<BlockPosition> var2) {
        int var7;
        int var6;
        int var3 = var2.size();
        int var4 = var3 / 7 * 16;
        int var5 = var1.getX();
        AxisAlignedBB var8 = new AxisAlignedBB(var5, var6 = var1.getY(), var7 = var1.getZ(), var5 + 1, var6 + 1, var7 + 1).inflate(var4).expandTowards(0.0, var0.getHeight(), 0.0);
        List<EntityHuman> var9 = var0.getEntitiesOfClass(EntityHuman.class, var8);
        if (var9.isEmpty()) {
            return;
        }
        for (EntityHuman var11 : var9) {
            if (!var1.closerThan(var11.blockPosition(), var4) || !var11.isInWaterOrRain()) continue;
            var11.addEffect(new MobEffect(MobEffects.CONDUIT_POWER, 260, 0, true, true));
        }
    }

    private static void updateAndAttackTarget(WorldServer var0, BlockPosition var1, IBlockData var2, TileEntityConduit var3, boolean var4) {
        EntityReference<EntityLiving> var5 = TileEntityConduit.updateDestroyTarget(var3.destroyTarget, var0, var1, var4);
        EntityLiving var6 = EntityReference.getLivingEntity(var5, var0);
        if (var6 != null) {
            var0.playSound(null, var6.getX(), var6.getY(), var6.getZ(), SoundEffects.CONDUIT_ATTACK_TARGET, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var6.hurtServer(var0, var0.damageSources().magic(), 4.0f);
        }
        if (!Objects.equals(var5, var3.destroyTarget)) {
            var3.destroyTarget = var5;
            var0.sendBlockUpdated(var1, var2, var2, 2);
        }
    }

    private static @Nullable EntityReference<EntityLiving> updateDestroyTarget(@Nullable EntityReference<EntityLiving> var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (!var3) {
            return null;
        }
        if (var0 == null) {
            return TileEntityConduit.selectNewTarget(var1, var2);
        }
        EntityLiving var4 = EntityReference.getLivingEntity(var0, var1);
        if (var4 == null || !var4.isAlive() || !var2.closerThan(var4.blockPosition(), 8.0)) {
            return null;
        }
        return var0;
    }

    private static @Nullable EntityReference<EntityLiving> selectNewTarget(WorldServer var02, BlockPosition var1) {
        List<EntityLiving> var2 = var02.getEntitiesOfClass(EntityLiving.class, TileEntityConduit.getDestroyRangeAABB(var1), var0 -> var0 instanceof IMonster && var0.isInWaterOrRain());
        if (var2.isEmpty()) {
            return null;
        }
        return EntityReference.of(SystemUtils.getRandom(var2, var02.random));
    }

    public static AxisAlignedBB getDestroyRangeAABB(BlockPosition var0) {
        return new AxisAlignedBB(var0).inflate(8.0);
    }

    private static void animationTick(World var0, BlockPosition var1, List<BlockPosition> var2, @Nullable Entity var3, int var4) {
        float var12;
        RandomSource var5 = var0.random;
        double var6 = MathHelper.sin((float)(var4 + 35) * 0.1f) / 2.0f + 0.5f;
        var6 = (var6 * var6 + var6) * (double)0.3f;
        Vec3D var8 = new Vec3D((double)var1.getX() + 0.5, (double)var1.getY() + 1.5 + var6, (double)var1.getZ() + 0.5);
        for (BlockPosition var10 : var2) {
            if (var5.nextInt(50) != 0) continue;
            BlockPosition var11 = var10.subtract(var1);
            var12 = -0.5f + var5.nextFloat() + (float)var11.getX();
            float var13 = -2.0f + var5.nextFloat() + (float)var11.getY();
            float var14 = -0.5f + var5.nextFloat() + (float)var11.getZ();
            var0.addParticle(Particles.NAUTILUS, var8.x, var8.y, var8.z, var12, var13, var14);
        }
        if (var3 != null) {
            Vec3D var9 = new Vec3D(var3.getX(), var3.getEyeY(), var3.getZ());
            float var10 = (-0.5f + var5.nextFloat()) * (3.0f + var3.getBbWidth());
            float var11 = -1.0f + var5.nextFloat() * var3.getBbHeight();
            var12 = (-0.5f + var5.nextFloat()) * (3.0f + var3.getBbWidth());
            Vec3D var13 = new Vec3D(var10, var11, var12);
            var0.addParticle(Particles.NAUTILUS, var9.x, var9.y, var9.z, var13.x, var13.y, var13.z);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean var0) {
        this.isHunting = var0;
    }

    public float getActiveRotation(float var0) {
        return (this.activeRotation + var0) * -0.0375f;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

