/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class TileEntityCommand
extends TileEntity {
    private static final boolean DEFAULT_POWERED = false;
    private static final boolean DEFAULT_CONDITION_MET = false;
    private static final boolean DEFAULT_AUTOMATIC = false;
    private boolean powered = false;
    private boolean auto = false;
    private boolean conditionMet = false;
    private final CommandBlockListenerAbstract commandBlock = new CommandBlockListenerAbstract(){

        @Override
        public void setCommand(String var0) {
            super.setCommand(var0);
            TileEntityCommand.this.setChanged();
        }

        @Override
        public void onUpdated(WorldServer var0) {
            IBlockData var1 = var0.getBlockState(TileEntityCommand.this.worldPosition);
            var0.sendBlockUpdated(TileEntityCommand.this.worldPosition, var1, var1, 3);
        }

        @Override
        public CommandListenerWrapper createCommandSourceStack(WorldServer var0, ICommandListener var1) {
            EnumDirection var2 = TileEntityCommand.this.getBlockState().getValue(BlockCommand.FACING);
            return new CommandListenerWrapper(var1, Vec3D.atCenterOf(TileEntityCommand.this.worldPosition), new Vec2F(0.0f, var2.toYRot()), var0, LevelBasedPermissionSet.GAMEMASTER, this.getName().getString(), this.getName(), var0.getServer(), null);
        }

        @Override
        public boolean isValid() {
            return !TileEntityCommand.this.isRemoved();
        }
    };

    public TileEntityCommand(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.COMMAND_BLOCK, var0, var1);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        this.commandBlock.save(var0);
        var0.putBoolean("powered", this.isPowered());
        var0.putBoolean("conditionMet", this.wasConditionMet());
        var0.putBoolean("auto", this.isAutomatic());
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.commandBlock.load(var0);
        this.powered = var0.getBooleanOr("powered", false);
        this.conditionMet = var0.getBooleanOr("conditionMet", false);
        this.setAutomatic(var0.getBooleanOr("auto", false));
    }

    public CommandBlockListenerAbstract getCommandBlock() {
        return this.commandBlock;
    }

    public void setPowered(boolean var0) {
        this.powered = var0;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isAutomatic() {
        return this.auto;
    }

    public void setAutomatic(boolean var0) {
        boolean var1 = this.auto;
        this.auto = var0;
        if (!var1 && var0 && !this.powered && this.level != null && this.getMode() != Type.SEQUENCE) {
            this.scheduleTick();
        }
    }

    public void onModeSwitch() {
        Type var0 = this.getMode();
        if (var0 == Type.AUTO && (this.powered || this.auto) && this.level != null) {
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        Block var0 = this.getBlockState().getBlock();
        if (var0 instanceof BlockCommand) {
            this.markConditionMet();
            this.level.scheduleTick(this.worldPosition, var0, 1);
        }
    }

    public boolean wasConditionMet() {
        return this.conditionMet;
    }

    public boolean markConditionMet() {
        this.conditionMet = true;
        if (this.isConditional()) {
            TileEntity var1;
            BlockPosition var0 = this.worldPosition.relative(this.level.getBlockState(this.worldPosition).getValue(BlockCommand.FACING).getOpposite());
            this.conditionMet = this.level.getBlockState(var0).getBlock() instanceof BlockCommand ? (var1 = this.level.getBlockEntity(var0)) instanceof TileEntityCommand && ((TileEntityCommand)var1).getCommandBlock().getSuccessCount() > 0 : false;
        }
        return this.conditionMet;
    }

    public Type getMode() {
        IBlockData var0 = this.getBlockState();
        if (var0.is(Blocks.COMMAND_BLOCK)) {
            return Type.REDSTONE;
        }
        if (var0.is(Blocks.REPEATING_COMMAND_BLOCK)) {
            return Type.AUTO;
        }
        if (var0.is(Blocks.CHAIN_COMMAND_BLOCK)) {
            return Type.SEQUENCE;
        }
        return Type.REDSTONE;
    }

    public boolean isConditional() {
        IBlockData var0 = this.level.getBlockState(this.getBlockPos());
        if (var0.getBlock() instanceof BlockCommand) {
            return var0.getValue(BlockCommand.CONDITIONAL);
        }
        return false;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        this.commandBlock.setCustomName(var0.get(DataComponents.CUSTOM_NAME));
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.CUSTOM_NAME, this.commandBlock.getCustomName());
    }

    @Override
    public void removeComponentsFromTag(ValueOutput var0) {
        super.removeComponentsFromTag(var0);
        var0.discard("CustomName");
        var0.discard("conditionMet");
        var0.discard("powered");
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SEQUENCE = new Type();
        public static final /* enum */ Type AUTO = new Type();
        public static final /* enum */ Type REDSTONE = new Type();
        private static final /* synthetic */ Type[] d;

        public static Type[] values() {
            return (Type[])d.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{SEQUENCE, AUTO, REDSTONE};
        }

        static {
            d = Type.a();
        }
    }
}

