/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class PitcherCropBlock
extends BlockTallPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<PitcherCropBlock> CODEC = PitcherCropBlock.simpleCodec(PitcherCropBlock::new);
    public static final int MAX_AGE = 4;
    public static final BlockStateInteger AGE = BlockProperties.AGE_4;
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> HALF = BlockTallPlant.HALF;
    private static final int DOUBLE_PLANT_AGE_INTERSECTION = 3;
    private static final int BONEMEAL_INCREASE = 1;
    private static final VoxelShape SHAPE_BULB = Block.column(6.0, -1.0, 3.0);
    private static final VoxelShape SHAPE_CROP = Block.column(10.0, -1.0, 5.0);
    private final Function<IBlockData, VoxelShape> shapes = this.makeShapes();

    public MapCodec<PitcherCropBlock> codec() {
        return CODEC;
    }

    public PitcherCropBlock(BlockBase.Info var0) {
        super(var0);
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        int[] var0 = new int[]{0, 9, 11, 22, 26};
        return this.getShapeForEachState(var1 -> {
            int var2 = (var1.getValue(AGE) == 0 ? 4 : 6) + var0[var1.getValue(AGE)];
            int var3 = var1.getValue(AGE) == 0 ? 6 : 10;
            return switch (var1.getValue(HALF)) {
                default -> throw new MatchException(null, null);
                case BlockPropertyDoubleBlockHalf.LOWER -> Block.column(var3, -1.0, Math.min(16, -1 + var2));
                case BlockPropertyDoubleBlockHalf.UPPER -> Block.column(var3, 0.0, Math.max(0, -1 + var2 - 16));
            };
        });
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.defaultBlockState();
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER) {
            return var0.getValue(AGE) == 0 ? SHAPE_BULB : SHAPE_CROP;
        }
        return VoxelShapes.empty();
    }

    @Override
    public IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (PitcherCropBlock.isDouble(var0.getValue(AGE))) {
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        return var0.canSurvive(var1, var3) ? var0 : Blocks.AIR.defaultBlockState();
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        if (PitcherCropBlock.isLower(var0) && !PitcherCropBlock.sufficientLight(var1, var2)) {
            return false;
        }
        return super.canSurvive(var0, var1, var2);
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(Blocks.FARMLAND);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
        super.createBlockStateDefinition(var0);
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        if (var1 instanceof WorldServer) {
            WorldServer var6 = (WorldServer)var1;
            if (var3 instanceof EntityRavager && var6.getGameRules().get(GameRules.MOB_GRIEFING).booleanValue()) {
                var6.destroyBlock(var2, true, var3);
            }
        }
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        return false;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER && !this.isMaxAge(var0);
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        boolean var5;
        float var4 = BlockCrops.getGrowthSpeed(this, var1, var2);
        boolean bl = var5 = var3.nextInt((int)(25.0f / var4) + 1) == 0;
        if (var5) {
            this.grow(var1, var0, var2, 1);
        }
    }

    private void grow(WorldServer var0, IBlockData var1, BlockPosition var2, int var3) {
        int var4 = Math.min(var1.getValue(AGE) + var3, 4);
        if (!this.canGrow(var0, var2, var1, var4)) {
            return;
        }
        IBlockData var5 = (IBlockData)var1.setValue(AGE, var4);
        var0.setBlock(var2, var5, 2);
        if (PitcherCropBlock.isDouble(var4)) {
            var0.setBlock(var2.above(), (IBlockData)var5.setValue(HALF, BlockPropertyDoubleBlockHalf.UPPER), 3);
        }
    }

    private static boolean canGrowInto(IWorldReader var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return var2.isAir() || var2.is(Blocks.PITCHER_CROP);
    }

    private static boolean sufficientLight(IWorldReader var0, BlockPosition var1) {
        return BlockCrops.hasSufficientLight(var0, var1);
    }

    private static boolean isLower(IBlockData var0) {
        return var0.is(Blocks.PITCHER_CROP) && var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
    }

    private static boolean isDouble(int var0) {
        return var0 >= 3;
    }

    private boolean canGrow(IWorldReader var0, BlockPosition var1, IBlockData var2, int var3) {
        return !this.isMaxAge(var2) && PitcherCropBlock.sufficientLight(var0, var1) && (!PitcherCropBlock.isDouble(var3) || PitcherCropBlock.canGrowInto(var0, var1.above()));
    }

    private boolean isMaxAge(IBlockData var0) {
        return var0.getValue(AGE) >= 4;
    }

    private @Nullable a getLowerHalf(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        if (PitcherCropBlock.isLower(var2)) {
            return new a(var1, var2);
        }
        BlockPosition var3 = var1.below();
        IBlockData var4 = var0.getBlockState(var3);
        if (PitcherCropBlock.isLower(var4)) {
            return new a(var3, var4);
        }
        return null;
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        a var3 = this.getLowerHalf(var0, var1, var2);
        if (var3 == null) {
            return false;
        }
        return this.canGrow(var0, var3.pos, var3.state, var3.state.getValue(AGE) + 1);
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        a var4 = this.getLowerHalf(var0, var2, var3);
        if (var4 == null) {
            return;
        }
        this.grow(var0, var4.state, var4.pos, 1);
    }

    static final class a
    extends Record {
        final BlockPosition pos;
        final IBlockData state;

        a(BlockPosition var0, IBlockData var1) {
            this.pos = var0;
            this.state = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;state", "pos", "state"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;state", "pos", "state"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;state", "pos", "state"}, this, var0);
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public IBlockData state() {
            return this.state;
        }
    }
}

