/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class CandleBlock
extends AbstractCandleBlock
implements IBlockWaterlogged {
    public static final MapCodec<CandleBlock> CODEC = CandleBlock.simpleCodec(CandleBlock::new);
    public static final int MIN_CANDLES = 1;
    public static final int MAX_CANDLES = 4;
    public static final BlockStateInteger CANDLES = BlockProperties.CANDLES;
    public static final BlockStateBoolean LIT = AbstractCandleBlock.LIT;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final ToIntFunction<IBlockData> LIGHT_EMISSION = var0 -> var0.getValue(LIT) != false ? 3 * var0.getValue(CANDLES) : 0;
    private static final Int2ObjectMap<List<Vec3D>> PARTICLE_OFFSETS = (Int2ObjectMap)SystemUtils.make(new Int2ObjectOpenHashMap(4), var0 -> {
        float var1 = 0.0625f;
        var0.put(1, List.of(new Vec3D(8.0, 8.0, 8.0).scale(0.0625)));
        var0.put(2, List.of(new Vec3D(6.0, 7.0, 8.0).scale(0.0625), new Vec3D(10.0, 8.0, 7.0).scale(0.0625)));
        var0.put(3, List.of(new Vec3D(8.0, 5.0, 10.0).scale(0.0625), new Vec3D(6.0, 7.0, 8.0).scale(0.0625), new Vec3D(9.0, 8.0, 7.0).scale(0.0625)));
        var0.put(4, List.of(new Vec3D(7.0, 5.0, 9.0).scale(0.0625), new Vec3D(10.0, 7.0, 9.0).scale(0.0625), new Vec3D(6.0, 7.0, 6.0).scale(0.0625), new Vec3D(9.0, 8.0, 6.0).scale(0.0625)));
    });
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.column(2.0, 0.0, 6.0), Block.box(5.0, 0.0, 6.0, 11.0, 6.0, 9.0), Block.box(5.0, 0.0, 6.0, 10.0, 6.0, 11.0), Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 10.0)};

    public MapCodec<CandleBlock> codec() {
        return CODEC;
    }

    public CandleBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(CANDLES, 1)).setValue(LIT, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (var0.isEmpty() && var4.getAbilities().mayBuild && var1.getValue(LIT).booleanValue()) {
            CandleBlock.extinguish(var4, var1, var2, var3);
            return EnumInteractionResult.SUCCESS;
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        if (!var1.isSecondaryUseActive() && var1.getItemInHand().getItem() == this.asItem() && var0.getValue(CANDLES) < 4) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(this)) {
            return (IBlockData)var1.cycle(CANDLES);
        }
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var3 = var2.getType() == FluidTypes.WATER;
        return (IBlockData)super.getStateForPlacement(var0).setValue(WATERLOGGED, var3);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES[var0.getValue(CANDLES) - 1];
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(CANDLES, LIT, WATERLOGGED);
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        if (var2.getValue(WATERLOGGED).booleanValue() || var3.getType() != FluidTypes.WATER) {
            return false;
        }
        IBlockData var4 = (IBlockData)var2.setValue(WATERLOGGED, true);
        if (var2.getValue(LIT).booleanValue()) {
            CandleBlock.extinguish(null, var4, var0, var1);
        } else {
            var0.setBlock(var1, var4, 3);
        }
        var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
        return true;
    }

    public static boolean canLight(IBlockData var02) {
        return var02.is(TagsBlock.CANDLES, var0 -> var0.hasProperty(LIT) && var0.hasProperty(WATERLOGGED)) && var02.getValue(LIT) == false && var02.getValue(WATERLOGGED) == false;
    }

    @Override
    protected Iterable<Vec3D> getParticleOffsets(IBlockData var0) {
        return (Iterable)PARTICLE_OFFSETS.get(var0.getValue(CANDLES).intValue());
    }

    @Override
    protected boolean canBeLit(IBlockData var0) {
        return var0.getValue(WATERLOGGED) == false && super.canBeLit(var0);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return Block.canSupportCenter(var1, var2.below(), EnumDirection.UP);
    }
}

