/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.redstone.Orientation;
import org.jspecify.annotations.Nullable;

public class BlockSponge
extends Block {
    public static final MapCodec<BlockSponge> CODEC = BlockSponge.simpleCodec(BlockSponge::new);
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final EnumDirection[] ALL_DIRECTIONS = EnumDirection.values();

    public MapCodec<BlockSponge> codec() {
        return CODEC;
    }

    protected BlockSponge(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.tryAbsorbWater(var1, var2);
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        this.tryAbsorbWater(var1, var2);
        super.neighborChanged(var0, var1, var2, var3, var4, var5);
    }

    protected void tryAbsorbWater(World var0, BlockPosition var1) {
        if (this.removeWaterBreadthFirstSearch(var0, var1)) {
            var0.setBlock(var1, Blocks.WET_SPONGE.defaultBlockState(), 2);
            var0.playSound(null, var1, SoundEffects.SPONGE_ABSORB, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean removeWaterBreadthFirstSearch(World var02, BlockPosition var12) {
        return BlockPosition.breadthFirstTraversal(var12, 6, 65, (var0, var1) -> {
            for (EnumDirection var5 : ALL_DIRECTIONS) {
                var1.accept(var0.relative(var5));
            }
        }, var2 -> {
            IFluidSource var5;
            if (var2.equals(var12)) {
                return BlockPosition.b.ACCEPT;
            }
            IBlockData var3 = var02.getBlockState((BlockPosition)var2);
            Fluid var4 = var02.getFluidState((BlockPosition)var2);
            if (!var4.is(TagsFluid.WATER)) {
                return BlockPosition.b.SKIP;
            }
            Block var6 = var3.getBlock();
            if (var6 instanceof IFluidSource && !(var5 = (IFluidSource)((Object)var6)).pickupBlock(null, var02, (BlockPosition)var2, var3).isEmpty()) {
                return BlockPosition.b.ACCEPT;
            }
            if (var3.getBlock() instanceof BlockFluids) {
                var02.setBlock((BlockPosition)var2, Blocks.AIR.defaultBlockState(), 3);
            } else if (var3.is(Blocks.KELP) || var3.is(Blocks.KELP_PLANT) || var3.is(Blocks.SEAGRASS) || var3.is(Blocks.TALL_SEAGRASS)) {
                var5 = var3.hasBlockEntity() ? var02.getBlockEntity((BlockPosition)var2) : null;
                BlockSponge.dropResources(var3, var02, var2, (TileEntity)((Object)var5));
                var02.setBlock((BlockPosition)var2, Blocks.AIR.defaultBlockState(), 3);
            } else {
                return BlockPosition.b.SKIP;
            }
            return BlockPosition.b.ACCEPT;
        }) > 1;
    }
}

