/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockHalfTransparent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.jspecify.annotations.Nullable;

public class BlockIce
extends BlockHalfTransparent {
    public static final MapCodec<BlockIce> CODEC = BlockIce.simpleCodec(BlockIce::new);

    public MapCodec<? extends BlockIce> codec() {
        return CODEC;
    }

    public BlockIce(BlockBase.Info var0) {
        super(var0);
    }

    public static IBlockData meltsInto() {
        return Blocks.WATER.defaultBlockState();
    }

    @Override
    public void playerDestroy(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3, @Nullable TileEntity var4, ItemStack var5) {
        super.playerDestroy(var0, var1, var2, var3, var4, var5);
        if (!EnchantmentManager.hasTag(var5, EnchantmentTags.PREVENTS_ICE_MELTING)) {
            if (var0.environmentAttributes().getValue(EnvironmentAttributes.WATER_EVAPORATES, var2).booleanValue()) {
                var0.removeBlock(var2, false);
                return;
            }
            IBlockData var6 = var0.getBlockState(var2.below());
            if (var6.blocksMotion() || var6.liquid()) {
                var0.setBlockAndUpdate(var2, BlockIce.meltsInto());
            }
        }
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var1.getBrightness(EnumSkyBlock.BLOCK, var2) > 11 - var0.getLightBlock()) {
            this.melt(var0, var1, var2);
        }
    }

    protected void melt(IBlockData var0, World var1, BlockPosition var2) {
        if (var1.environmentAttributes().getValue(EnvironmentAttributes.WATER_EVAPORATES, var2).booleanValue()) {
            var1.removeBlock(var2, false);
            return;
        }
        var1.setBlockAndUpdate(var2, BlockIce.meltsInto());
        var1.neighborChanged(var2, BlockIce.meltsInto().getBlock(), null);
    }
}

