/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockFenceGate
extends BlockFacingHorizontal {
    public static final MapCodec<BlockFenceGate> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockPropertyWood.CODEC.fieldOf("wood_type").forGetter(var0 -> var0.type), BlockFenceGate.propertiesCodec()).apply((Applicative)var02, BlockFenceGate::new));
    public static final BlockStateBoolean OPEN = BlockProperties.OPEN;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean IN_WALL = BlockProperties.IN_WALL;
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPES = VoxelShapes.rotateHorizontalAxis(Block.cube(16.0, 16.0, 4.0));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPES_WALL = Maps.newEnumMap(SystemUtils.mapValues(SHAPES, var0 -> VoxelShapes.join(var0, Block.column(16.0, 13.0, 16.0), OperatorBoolean.ONLY_FIRST)));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPE_COLLISION = VoxelShapes.rotateHorizontalAxis(Block.column(16.0, 4.0, 0.0, 24.0));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPE_SUPPORT = VoxelShapes.rotateHorizontalAxis(Block.column(16.0, 4.0, 5.0, 24.0));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPE_OCCLUSION = VoxelShapes.rotateHorizontalAxis(VoxelShapes.or(Block.box(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), Block.box(14.0, 5.0, 7.0, 16.0, 16.0, 9.0)));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPE_OCCLUSION_WALL = Maps.newEnumMap(SystemUtils.mapValues(SHAPE_OCCLUSION, var0 -> var0.move(0.0, -0.1875, 0.0).optimize()));
    private final BlockPropertyWood type;

    public MapCodec<BlockFenceGate> codec() {
        return CODEC;
    }

    public BlockFenceGate(BlockPropertyWood var0, BlockBase.Info var1) {
        super(var1.sound(var0.soundType()));
        this.type = var0;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(OPEN, false)).setValue(POWERED, false)).setValue(IN_WALL, false));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        EnumDirection.EnumAxis var4 = ((EnumDirection)var0.getValue(FACING)).getAxis();
        return (var0.getValue(IN_WALL) != false ? SHAPES_WALL : SHAPES).get(var4);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        EnumDirection.EnumAxis var8 = var4.getAxis();
        if (((EnumDirection)var0.getValue(FACING)).getClockWise().getAxis() == var8) {
            boolean var9 = this.isWall(var6) || this.isWall(var1.getBlockState(var3.relative(var4.getOpposite())));
            return (IBlockData)var0.setValue(IN_WALL, var9);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        EnumDirection.EnumAxis var3 = ((EnumDirection)var0.getValue(FACING)).getAxis();
        return var0.getValue(OPEN) != false ? VoxelShapes.empty() : SHAPE_SUPPORT.get(var3);
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        EnumDirection.EnumAxis var4 = ((EnumDirection)var0.getValue(FACING)).getAxis();
        return var0.getValue(OPEN) != false ? VoxelShapes.empty() : SHAPE_COLLISION.get(var4);
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData var0) {
        EnumDirection.EnumAxis var1 = ((EnumDirection)var0.getValue(FACING)).getAxis();
        return (var0.getValue(IN_WALL) != false ? SHAPE_OCCLUSION_WALL : SHAPE_OCCLUSION).get(var1);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        switch (var1) {
            case LAND: {
                return var0.getValue(OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return var0.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        boolean var3 = var1.hasNeighborSignal(var2);
        EnumDirection var4 = var0.getHorizontalDirection();
        EnumDirection.EnumAxis var5 = var4.getAxis();
        boolean var6 = var5 == EnumDirection.EnumAxis.Z && (this.isWall(var1.getBlockState(var2.west())) || this.isWall(var1.getBlockState(var2.east()))) || var5 == EnumDirection.EnumAxis.X && (this.isWall(var1.getBlockState(var2.north())) || this.isWall(var1.getBlockState(var2.south())));
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var4)).setValue(OPEN, var3)).setValue(POWERED, var3)).setValue(IN_WALL, var6);
    }

    private boolean isWall(IBlockData var0) {
        return var0.is(TagsBlock.WALLS);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var0.getValue(OPEN).booleanValue()) {
            var0 = (IBlockData)var0.setValue(OPEN, false);
            var1.setBlock(var2, var0, 10);
        } else {
            EnumDirection var5 = var3.getDirection();
            if (var0.getValue(FACING) == var5.getOpposite()) {
                var0 = (IBlockData)var0.setValue(FACING, var5);
            }
            var0 = (IBlockData)var0.setValue(OPEN, true);
            var1.setBlock(var2, var0, 10);
        }
        boolean var5 = var0.getValue(OPEN);
        var1.playSound((Entity)var3, var2, var5 ? this.type.fenceGateOpen() : this.type.fenceGateClose(), SoundCategory.BLOCKS, 1.0f, var1.getRandom().nextFloat() * 0.1f + 0.9f);
        var1.gameEvent((Entity)var3, var5 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(IBlockData var0, WorldServer var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        if (var3.canTriggerBlocks() && !var0.getValue(POWERED).booleanValue()) {
            boolean var5 = var0.getValue(OPEN);
            var1.setBlockAndUpdate(var2, (IBlockData)var0.setValue(OPEN, !var5));
            var1.playSound(null, var2, var5 ? this.type.fenceGateClose() : this.type.fenceGateOpen(), SoundCategory.BLOCKS, 1.0f, var1.getRandom().nextFloat() * 0.1f + 0.9f);
            var1.gameEvent(var5 ? GameEvent.BLOCK_CLOSE : GameEvent.BLOCK_OPEN, var2, GameEvent.a.of(var0));
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide()) {
            return;
        }
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var0.getValue(POWERED) != var6) {
            var1.setBlock(var2, (IBlockData)((IBlockData)var0.setValue(POWERED, var6)).setValue(OPEN, var6), 2);
            if (var0.getValue(OPEN) != var6) {
                var1.playSound(null, var2, var6 ? this.type.fenceGateOpen() : this.type.fenceGateClose(), SoundCategory.BLOCKS, 1.0f, var1.getRandom().nextFloat() * 0.1f + 0.9f);
                var1.gameEvent(null, var6 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, OPEN, POWERED, IN_WALL);
    }

    public static boolean connectsToDirection(IBlockData var0, EnumDirection var1) {
        return ((EnumDirection)var0.getValue(FACING)).getAxis() == var1.getClockWise().getAxis();
    }
}

