/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockDoor
extends Block {
    public static final MapCodec<BlockDoor> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(BlockDoor::type), BlockDoor.propertiesCodec()).apply((Applicative)var0, BlockDoor::new));
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> HALF = BlockProperties.DOUBLE_BLOCK_HALF;
    public static final BlockStateEnum<BlockPropertyDoorHinge> HINGE = BlockProperties.DOOR_HINGE;
    public static final BlockStateBoolean OPEN = BlockProperties.OPEN;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final Map<EnumDirection, VoxelShape> SHAPES = VoxelShapes.rotateHorizontal(Block.boxZ(16.0, 13.0, 16.0));
    private final BlockSetType type;

    public MapCodec<? extends BlockDoor> codec() {
        return CODEC;
    }

    protected BlockDoor(BlockSetType var0, BlockBase.Info var1) {
        super(var1.sound(var0.soundType()));
        this.type = var0;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(OPEN, false)).setValue(HINGE, BlockPropertyDoorHinge.LEFT)).setValue(POWERED, false)).setValue(HALF, BlockPropertyDoubleBlockHalf.LOWER));
    }

    public BlockSetType type() {
        return this.type;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        EnumDirection var4 = var0.getValue(FACING);
        EnumDirection var5 = var0.getValue(OPEN).booleanValue() ? (var0.getValue(HINGE) == BlockPropertyDoorHinge.RIGHT ? var4.getCounterClockWise() : var4.getClockWise()) : var4;
        return SHAPES.get(var5);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        BlockPropertyDoubleBlockHalf var8 = var0.getValue(HALF);
        if (var4.getAxis() == EnumDirection.EnumAxis.Y && var8 == BlockPropertyDoubleBlockHalf.LOWER == (var4 == EnumDirection.UP)) {
            if (var6.getBlock() instanceof BlockDoor && var6.getValue(HALF) != var8) {
                return (IBlockData)var6.setValue(HALF, var8);
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (var8 == BlockPropertyDoubleBlockHalf.LOWER && var4 == EnumDirection.DOWN && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void onExplosionHit(IBlockData var0, WorldServer var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        if (var3.canTriggerBlocks() && var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER && this.type.canOpenByWindCharge() && !var0.getValue(POWERED).booleanValue()) {
            this.setOpen(null, var1, var0, var2, !this.isOpen(var0));
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!(var0.isClientSide() || !var3.preventsBlockDrops() && var3.hasCorrectToolForDrops(var2))) {
            BlockTallPlant.preventDropFromBottomPart(var0, var1, var2, var3);
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return switch (var1) {
            default -> throw new MatchException(null, null);
            case PathMode.LAND, PathMode.AIR -> var0.getValue(OPEN);
            case PathMode.WATER -> false;
        };
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        World var2 = var0.getLevel();
        if (var1.getY() < var2.getMaxY() && var2.getBlockState(var1.above()).canBeReplaced(var0)) {
            boolean var3 = var2.hasNeighborSignal(var1) || var2.hasNeighborSignal(var1.above());
            return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection())).setValue(HINGE, this.getHinge(var0))).setValue(POWERED, var3)).setValue(OPEN, var3)).setValue(HALF, BlockPropertyDoubleBlockHalf.LOWER);
        }
        return null;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        var0.setBlock(var1.above(), (IBlockData)var2.setValue(HALF, BlockPropertyDoubleBlockHalf.UPPER), 3);
    }

    private BlockPropertyDoorHinge getHinge(BlockActionContext var0) {
        boolean var17;
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        EnumDirection var3 = var0.getHorizontalDirection();
        BlockPosition var4 = var2.above();
        EnumDirection var5 = var3.getCounterClockWise();
        BlockPosition var6 = var2.relative(var5);
        IBlockData var7 = var1.getBlockState(var6);
        BlockPosition var8 = var4.relative(var5);
        IBlockData var9 = var1.getBlockState(var8);
        EnumDirection var10 = var3.getClockWise();
        BlockPosition var11 = var2.relative(var10);
        IBlockData var12 = var1.getBlockState(var11);
        BlockPosition var13 = var4.relative(var10);
        IBlockData var14 = var1.getBlockState(var13);
        int var15 = (var7.isCollisionShapeFullBlock(var1, var6) ? -1 : 0) + (var9.isCollisionShapeFullBlock(var1, var8) ? -1 : 0) + (var12.isCollisionShapeFullBlock(var1, var11) ? 1 : 0) + (var14.isCollisionShapeFullBlock(var1, var13) ? 1 : 0);
        boolean var16 = var7.getBlock() instanceof BlockDoor && var7.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
        boolean bl = var17 = var12.getBlock() instanceof BlockDoor && var12.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
        if (var16 && !var17 || var15 > 0) {
            return BlockPropertyDoorHinge.RIGHT;
        }
        if (var17 && !var16 || var15 < 0) {
            return BlockPropertyDoorHinge.LEFT;
        }
        int var18 = var3.getStepX();
        int var19 = var3.getStepZ();
        Vec3D var20 = var0.getClickLocation();
        double var21 = var20.x - (double)var2.getX();
        double var23 = var20.z - (double)var2.getZ();
        return var18 < 0 && var23 < 0.5 || var18 > 0 && var23 > 0.5 || var19 < 0 && var21 > 0.5 || var19 > 0 && var21 < 0.5 ? BlockPropertyDoorHinge.RIGHT : BlockPropertyDoorHinge.LEFT;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!this.type.canOpenByHand()) {
            return EnumInteractionResult.PASS;
        }
        var0 = (IBlockData)var0.cycle(OPEN);
        var1.setBlock(var2, var0, 10);
        this.playSound(var3, var1, var2, var0.getValue(OPEN));
        var1.gameEvent((Entity)var3, this.isOpen(var0) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
        return EnumInteractionResult.SUCCESS;
    }

    public boolean isOpen(IBlockData var0) {
        return var0.getValue(OPEN);
    }

    public void setOpen(@Nullable Entity var0, World var1, IBlockData var2, BlockPosition var3, boolean var4) {
        if (!var2.is(this) || var2.getValue(OPEN) == var4) {
            return;
        }
        var1.setBlock(var3, (IBlockData)var2.setValue(OPEN, var4), 10);
        this.playSound(var0, var1, var3, var4);
        var1.gameEvent(var0, var4 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var3);
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        boolean var6;
        boolean bl = var1.hasNeighborSignal(var2) || var1.hasNeighborSignal(var2.relative(var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER ? EnumDirection.UP : EnumDirection.DOWN)) ? true : (var6 = false);
        if (!this.defaultBlockState().is(var3) && var6 != var0.getValue(POWERED)) {
            if (var6 != var0.getValue(OPEN)) {
                this.playSound(null, var1, var2, var6);
                var1.gameEvent(null, var6 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
            }
            var1.setBlock(var2, (IBlockData)((IBlockData)var0.setValue(POWERED, var6)).setValue(OPEN, var6), 2);
        }
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        IBlockData var4 = var1.getBlockState(var3);
        if (var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER) {
            return var4.isFaceSturdy(var1, var3, EnumDirection.UP);
        }
        return var4.is(this);
    }

    private void playSound(@Nullable Entity var0, World var1, BlockPosition var2, boolean var3) {
        var1.playSound(var0, var2, var3 ? this.type.doorOpen() : this.type.doorClose(), SoundCategory.BLOCKS, 1.0f, var1.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        if (var1 == EnumBlockMirror.NONE) {
            return var0;
        }
        return (IBlockData)var0.rotate(var1.getRotation(var0.getValue(FACING))).cycle(HINGE);
    }

    @Override
    protected long getSeed(IBlockData var0, BlockPosition var1) {
        return MathHelper.getSeed(var1.getX(), var1.below(var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER ? 0 : 1).getY(), var1.getZ());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HALF, FACING, OPEN, HINGE, POWERED);
    }

    public static boolean isWoodenDoor(World var0, BlockPosition var1) {
        return BlockDoor.isWoodenDoor(var0.getBlockState(var1));
    }

    public static boolean isWoodenDoor(IBlockData var0) {
        BlockDoor var1;
        Block block = var0.getBlock();
        return block instanceof BlockDoor && (var1 = (BlockDoor)block).type().canOpenByHand();
    }
}

