/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BlockDispenser
extends BlockTileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<BlockDispenser> CODEC = BlockDispenser.simpleCodec(BlockDispenser::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockDirectional.FACING;
    public static final BlockStateBoolean TRIGGERED = BlockProperties.TRIGGERED;
    private static final DispenseBehaviorItem DEFAULT_BEHAVIOR = new DispenseBehaviorItem();
    public static final Map<Item, IDispenseBehavior> DISPENSER_REGISTRY = new IdentityHashMap<Item, IDispenseBehavior>();
    private static final int TRIGGER_DURATION = 4;

    public MapCodec<? extends BlockDispenser> codec() {
        return CODEC;
    }

    public static void registerBehavior(IMaterial var0, IDispenseBehavior var1) {
        DISPENSER_REGISTRY.put(var0.asItem(), var1);
    }

    public static void registerProjectileBehavior(IMaterial var0) {
        DISPENSER_REGISTRY.put(var0.asItem(), new DispenseBehaviorProjectile(var0.asItem()));
    }

    protected BlockDispenser(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(TRIGGERED, false));
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity;
        if (!var1.isClientSide() && (tileEntity = var1.getBlockEntity(var2)) instanceof TileEntityDispenser) {
            TileEntityDispenser var5 = (TileEntityDispenser)tileEntity;
            var3.openMenu(var5);
            var3.awardStat(var5 instanceof TileEntityDropper ? StatisticList.INSPECT_DROPPER : StatisticList.INSPECT_DISPENSER);
        }
        return EnumInteractionResult.SUCCESS;
    }

    public void dispenseFrom(WorldServer var0, IBlockData var1, BlockPosition var2) {
        TileEntityDispenser var3 = var0.getBlockEntity(var2, TileEntityTypes.DISPENSER).orElse(null);
        if (var3 == null) {
            LOGGER.warn("Ignoring dispensing attempt for Dispenser without matching block entity at {}", (Object)var2);
            return;
        }
        SourceBlock var4 = new SourceBlock(var0, var2, var1, var3);
        int var5 = var3.getRandomSlot(var0.random);
        if (var5 < 0) {
            var0.levelEvent(1001, var2, 0);
            var0.gameEvent(GameEvent.BLOCK_ACTIVATE, var2, GameEvent.a.of(var3.getBlockState()));
            return;
        }
        ItemStack var6 = var3.getItem(var5);
        IDispenseBehavior var7 = this.getDispenseMethod(var0, var6);
        if (var7 != IDispenseBehavior.NOOP) {
            var3.setItem(var5, var7.dispense(var4, var6));
        }
    }

    protected IDispenseBehavior getDispenseMethod(World var0, ItemStack var1) {
        if (!var1.isItemEnabled(var0.enabledFeatures())) {
            return DEFAULT_BEHAVIOR;
        }
        IDispenseBehavior var2 = DISPENSER_REGISTRY.get(var1.getItem());
        if (var2 != null) {
            return var2;
        }
        return BlockDispenser.getDefaultDispenseMethod(var1);
    }

    private static IDispenseBehavior getDefaultDispenseMethod(ItemStack var0) {
        if (var0.has(DataComponents.EQUIPPABLE)) {
            return EquipmentDispenseItemBehavior.INSTANCE;
        }
        return DEFAULT_BEHAVIOR;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        boolean var6 = var1.hasNeighborSignal(var2) || var1.hasNeighborSignal(var2.above());
        boolean var7 = var0.getValue(TRIGGERED);
        if (var6 && !var7) {
            var1.scheduleTick(var2, this, 4);
            var1.setBlock(var2, (IBlockData)var0.setValue(TRIGGERED, true), 2);
        } else if (!var6 && var7) {
            var1.setBlock(var2, (IBlockData)var0.setValue(TRIGGERED, false), 2);
        }
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        this.dispenseFrom(var1, var0, var2);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityDispenser(var0, var1);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getNearestLookingDirection().getOpposite());
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    public static IPosition getDispensePosition(SourceBlock var0) {
        return BlockDispenser.getDispensePosition(var0, 0.7, Vec3D.ZERO);
    }

    public static IPosition getDispensePosition(SourceBlock var0, double var1, Vec3D var3) {
        EnumDirection var4 = var0.state().getValue(FACING);
        return var0.center().add(var1 * (double)var4.getStepX() + var3.x(), var1 * (double)var4.getStepY() + var3.y(), var1 * (double)var4.getStepZ() + var3.z());
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        return Container.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, TRIGGERED);
    }
}

