/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockCobbleWall
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockCobbleWall> CODEC = BlockCobbleWall.simpleCodec(BlockCobbleWall::new);
    public static final BlockStateBoolean UP = BlockProperties.UP;
    public static final BlockStateEnum<BlockPropertyWallHeight> EAST = BlockProperties.EAST_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> NORTH = BlockProperties.NORTH_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> SOUTH = BlockProperties.SOUTH_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> WEST = BlockProperties.WEST_WALL;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(EnumDirection.NORTH, NORTH, EnumDirection.EAST, EAST, EnumDirection.SOUTH, SOUTH, EnumDirection.WEST, WEST)));
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private final Function<IBlockData, VoxelShape> shapes;
    private final Function<IBlockData, VoxelShape> collisionShapes;
    private static final VoxelShape TEST_SHAPE_POST = Block.column(2.0, 0.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> TEST_SHAPES_WALL = VoxelShapes.rotateHorizontal(Block.boxZ(2.0, 16.0, 0.0, 9.0));

    public MapCodec<BlockCobbleWall> codec() {
        return CODEC;
    }

    public BlockCobbleWall(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(UP, true)).setValue(NORTH, BlockPropertyWallHeight.NONE)).setValue(EAST, BlockPropertyWallHeight.NONE)).setValue(SOUTH, BlockPropertyWallHeight.NONE)).setValue(WEST, BlockPropertyWallHeight.NONE)).setValue(WATERLOGGED, false));
        this.shapes = this.makeShapes(16.0f, 14.0f);
        this.collisionShapes = this.makeShapes(24.0f, 24.0f);
    }

    private Function<IBlockData, VoxelShape> makeShapes(float var0, float var1) {
        VoxelShape var2 = Block.column(8.0, 0.0, var0);
        int var32 = 6;
        Map<EnumDirection, VoxelShape> var4 = VoxelShapes.rotateHorizontal(Block.boxZ(6.0, 0.0, var1, 0.0, 11.0));
        Map<EnumDirection, VoxelShape> var5 = VoxelShapes.rotateHorizontal(Block.boxZ(6.0, 0.0, var0, 0.0, 11.0));
        return this.getShapeForEachState(var3 -> {
            VoxelShape var4 = var3.getValue(UP) != false ? var2 : VoxelShapes.empty();
            for (Map.Entry<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> var6 : PROPERTY_BY_DIRECTION.entrySet()) {
                var4 = VoxelShapes.or(var4, switch ((BlockPropertyWallHeight)var3.getValue(var6.getValue())) {
                    default -> throw new MatchException(null, null);
                    case BlockPropertyWallHeight.NONE -> VoxelShapes.empty();
                    case BlockPropertyWallHeight.LOW -> (VoxelShape)var4.get(var6.getKey());
                    case BlockPropertyWallHeight.TALL -> (VoxelShape)var5.get(var6.getKey());
                });
            }
            return var4;
        }, WATERLOGGED);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.collisionShapes.apply(var0);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    private boolean connectsTo(IBlockData var0, boolean var1, EnumDirection var2) {
        Block var3 = var0.getBlock();
        boolean var4 = var3 instanceof BlockFenceGate && BlockFenceGate.connectsToDirection(var0, var2);
        return var0.is(TagsBlock.WALLS) || !BlockCobbleWall.isExceptionForConnection(var0) && var1 || var3 instanceof BlockIronBars || var4;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        Fluid var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        BlockPosition var4 = var2.north();
        BlockPosition var5 = var2.east();
        BlockPosition var6 = var2.south();
        BlockPosition var7 = var2.west();
        BlockPosition var8 = var2.above();
        IBlockData var9 = var1.getBlockState(var4);
        IBlockData var10 = var1.getBlockState(var5);
        IBlockData var11 = var1.getBlockState(var6);
        IBlockData var12 = var1.getBlockState(var7);
        IBlockData var13 = var1.getBlockState(var8);
        boolean var14 = this.connectsTo(var9, var9.isFaceSturdy(var1, var4, EnumDirection.SOUTH), EnumDirection.SOUTH);
        boolean var15 = this.connectsTo(var10, var10.isFaceSturdy(var1, var5, EnumDirection.WEST), EnumDirection.WEST);
        boolean var16 = this.connectsTo(var11, var11.isFaceSturdy(var1, var6, EnumDirection.NORTH), EnumDirection.NORTH);
        boolean var17 = this.connectsTo(var12, var12.isFaceSturdy(var1, var7, EnumDirection.EAST), EnumDirection.EAST);
        IBlockData var18 = (IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
        return this.updateShape(var1, var18, var8, var13, var14, var15, var16, var17);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (var4 == EnumDirection.DOWN) {
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        if (var4 == EnumDirection.UP) {
            return this.topUpdate(var1, var0, var5, var6);
        }
        return this.sideUpdate(var1, var3, var0, var5, var6, var4);
    }

    private static boolean isConnected(IBlockData var0, IBlockState<BlockPropertyWallHeight> var1) {
        return var0.getValue(var1) != BlockPropertyWallHeight.NONE;
    }

    private static boolean isCovered(VoxelShape var0, VoxelShape var1) {
        return !VoxelShapes.joinIsNotEmpty(var1, var0, OperatorBoolean.ONLY_FIRST);
    }

    private IBlockData topUpdate(IWorldReader var0, IBlockData var1, BlockPosition var2, IBlockData var3) {
        boolean var4 = BlockCobbleWall.isConnected(var1, NORTH);
        boolean var5 = BlockCobbleWall.isConnected(var1, EAST);
        boolean var6 = BlockCobbleWall.isConnected(var1, SOUTH);
        boolean var7 = BlockCobbleWall.isConnected(var1, WEST);
        return this.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    private IBlockData sideUpdate(IWorldReader var0, BlockPosition var1, IBlockData var2, BlockPosition var3, IBlockData var4, EnumDirection var5) {
        EnumDirection var6 = var5.getOpposite();
        boolean var7 = var5 == EnumDirection.NORTH ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, NORTH);
        boolean var8 = var5 == EnumDirection.EAST ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, EAST);
        boolean var9 = var5 == EnumDirection.SOUTH ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, SOUTH);
        boolean var10 = var5 == EnumDirection.WEST ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, WEST);
        BlockPosition var11 = var1.above();
        IBlockData var12 = var0.getBlockState(var11);
        return this.updateShape(var0, var2, var11, var12, var7, var8, var9, var10);
    }

    private IBlockData updateShape(IWorldReader var0, IBlockData var1, BlockPosition var2, IBlockData var3, boolean var4, boolean var5, boolean var6, boolean var7) {
        VoxelShape var8 = var3.getCollisionShape(var0, var2).getFaceShape(EnumDirection.DOWN);
        IBlockData var9 = this.updateSides(var1, var4, var5, var6, var7, var8);
        return (IBlockData)var9.setValue(UP, this.shouldRaisePost(var9, var3, var8));
    }

    private boolean shouldRaisePost(IBlockData var0, IBlockData var1, VoxelShape var2) {
        boolean var13;
        boolean var12;
        boolean var3;
        boolean bl = var3 = var1.getBlock() instanceof BlockCobbleWall && var1.getValue(UP) != false;
        if (var3) {
            return true;
        }
        BlockPropertyWallHeight var4 = var0.getValue(NORTH);
        BlockPropertyWallHeight var5 = var0.getValue(SOUTH);
        BlockPropertyWallHeight var6 = var0.getValue(EAST);
        BlockPropertyWallHeight var7 = var0.getValue(WEST);
        boolean var8 = var5 == BlockPropertyWallHeight.NONE;
        boolean var9 = var7 == BlockPropertyWallHeight.NONE;
        boolean var10 = var6 == BlockPropertyWallHeight.NONE;
        boolean var11 = var4 == BlockPropertyWallHeight.NONE;
        boolean bl2 = var12 = var11 && var8 && var9 && var10 || var11 != var8 || var9 != var10;
        if (var12) {
            return true;
        }
        boolean bl3 = var13 = var4 == BlockPropertyWallHeight.TALL && var5 == BlockPropertyWallHeight.TALL || var6 == BlockPropertyWallHeight.TALL && var7 == BlockPropertyWallHeight.TALL;
        if (var13) {
            return false;
        }
        return var1.is(TagsBlock.WALL_POST_OVERRIDE) || BlockCobbleWall.isCovered(var2, TEST_SHAPE_POST);
    }

    private IBlockData updateSides(IBlockData var0, boolean var1, boolean var2, boolean var3, boolean var4, VoxelShape var5) {
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, this.makeWallState(var1, var5, TEST_SHAPES_WALL.get(EnumDirection.NORTH)))).setValue(EAST, this.makeWallState(var2, var5, TEST_SHAPES_WALL.get(EnumDirection.EAST)))).setValue(SOUTH, this.makeWallState(var3, var5, TEST_SHAPES_WALL.get(EnumDirection.SOUTH)))).setValue(WEST, this.makeWallState(var4, var5, TEST_SHAPES_WALL.get(EnumDirection.WEST)));
    }

    private BlockPropertyWallHeight makeWallState(boolean var0, VoxelShape var1, VoxelShape var2) {
        if (var0) {
            if (BlockCobbleWall.isCovered(var1, var2)) {
                return BlockPropertyWallHeight.TALL;
            }
            return BlockPropertyWallHeight.LOW;
        }
        return BlockPropertyWallHeight.NONE;
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return var0.getValue(WATERLOGGED) == false;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(UP, NORTH, EAST, WEST, SOUTH, WATERLOGGED);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }
}

