/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.biome.BiomeBase;

public record BiomeFog(int waterColor, Optional<Integer> foliageColorOverride, Optional<Integer> dryFoliageColorOverride, Optional<Integer> grassColorOverride, GrassColor grassColorModifier) {
    public static final Codec<BiomeFog> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.STRING_RGB_COLOR.fieldOf("water_color").forGetter(BiomeFog::waterColor), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("foliage_color").forGetter(BiomeFog::foliageColorOverride), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("dry_foliage_color").forGetter(BiomeFog::dryFoliageColorOverride), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("grass_color").forGetter(BiomeFog::grassColorOverride), (App)GrassColor.CODEC.optionalFieldOf("grass_color_modifier", (Object)GrassColor.NONE).forGetter(BiomeFog::grassColorModifier)).apply((Applicative)var0, BiomeFog::new));

    public static abstract sealed class GrassColor
    extends Enum<GrassColor>
    implements INamable {
        public static final /* enum */ GrassColor NONE = new GrassColor("none"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                return var4;
            }
        };
        public static final /* enum */ GrassColor DARK_FOREST = new GrassColor("dark_forest"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                return (var4 & 0xFEFEFE) + 2634762 >> 1;
            }
        };
        public static final /* enum */ GrassColor SWAMP = new GrassColor("swamp"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                double var5 = BiomeBase.BIOME_INFO_NOISE.getValue(var0 * 0.0225, var2 * 0.0225, false);
                if (var5 < -0.1) {
                    return 5011004;
                }
                return 6975545;
            }
        };
        private final String name;
        public static final Codec<GrassColor> CODEC;
        private static final /* synthetic */ GrassColor[] f;

        public static GrassColor[] values() {
            return (GrassColor[])f.clone();
        }

        public static GrassColor valueOf(String var0) {
            return Enum.valueOf(GrassColor.class, var0);
        }

        public abstract int modifyColor(double var1, double var3, int var5);

        GrassColor(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ GrassColor[] b() {
            return new GrassColor[]{NONE, DARK_FOREST, SWAMP};
        }

        static {
            f = GrassColor.b();
            CODEC = INamable.fromEnum(GrassColor::values);
        }
    }

    public static class a {
        private OptionalInt waterColor = OptionalInt.empty();
        private Optional<Integer> foliageColorOverride = Optional.empty();
        private Optional<Integer> dryFoliageColorOverride = Optional.empty();
        private Optional<Integer> grassColorOverride = Optional.empty();
        private GrassColor grassColorModifier = GrassColor.NONE;

        public a waterColor(int var0) {
            this.waterColor = OptionalInt.of(var0);
            return this;
        }

        public a foliageColorOverride(int var0) {
            this.foliageColorOverride = Optional.of(var0);
            return this;
        }

        public a dryFoliageColorOverride(int var0) {
            this.dryFoliageColorOverride = Optional.of(var0);
            return this;
        }

        public a grassColorOverride(int var0) {
            this.grassColorOverride = Optional.of(var0);
            return this;
        }

        public a grassColorModifier(GrassColor var0) {
            this.grassColorModifier = var0;
            return this;
        }

        public BiomeFog build() {
            return new BiomeFog(this.waterColor.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.foliageColorOverride, this.dryFoliageColorOverride, this.grassColorOverride, this.grassColorModifier);
        }
    }
}

