/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class TicketStorage
extends PersistentBase {
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Pair<ChunkCoordIntPair, Ticket>> TICKET_ENTRY = Codec.mapPair((MapCodec)ChunkCoordIntPair.CODEC.fieldOf("chunk_pos"), Ticket.CODEC).codec();
    public static final Codec<TicketStorage> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)TICKET_ENTRY.listOf().optionalFieldOf("tickets", List.of()).forGetter(TicketStorage::packTickets)).apply((Applicative)var0, TicketStorage::fromPacked));
    public static final SavedDataType<TicketStorage> TYPE = new SavedDataType<TicketStorage>("chunks", TicketStorage::new, CODEC, DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    public final Long2ObjectOpenHashMap<List<Ticket>> tickets;
    private final Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets;
    private LongSet chunksWithForcedTickets = new LongOpenHashSet();
    private @Nullable a loadingChunkUpdatedListener;
    private @Nullable a simulationChunkUpdatedListener;

    private TicketStorage(Long2ObjectOpenHashMap<List<Ticket>> var0, Long2ObjectOpenHashMap<List<Ticket>> var1) {
        this.tickets = var0;
        this.deactivatedTickets = var1;
        this.updateForcedChunks();
    }

    public TicketStorage() {
        this((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap());
    }

    private static TicketStorage fromPacked(List<Pair<ChunkCoordIntPair, Ticket>> var02) {
        Long2ObjectOpenHashMap var1 = new Long2ObjectOpenHashMap();
        for (Pair<ChunkCoordIntPair, Ticket> var3 : var02) {
            ChunkCoordIntPair var4 = (ChunkCoordIntPair)var3.getFirst();
            List var5 = (List)var1.computeIfAbsent(var4.toLong(), var0 -> new ObjectArrayList(4));
            var5.add((Ticket)var3.getSecond());
        }
        return new TicketStorage((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)var1);
    }

    private List<Pair<ChunkCoordIntPair, Ticket>> packTickets() {
        ArrayList<Pair<ChunkCoordIntPair, Ticket>> var0 = new ArrayList<Pair<ChunkCoordIntPair, Ticket>>();
        this.forEachTicket((var1, var2) -> {
            if (var2.getType().persist()) {
                var0.add(new Pair(var1, var2));
            }
        });
        return var0;
    }

    private void forEachTicket(BiConsumer<ChunkCoordIntPair, Ticket> var0) {
        TicketStorage.forEachTicket(var0, this.tickets);
        TicketStorage.forEachTicket(var0, this.deactivatedTickets);
    }

    private static void forEachTicket(BiConsumer<ChunkCoordIntPair, Ticket> var0, Long2ObjectOpenHashMap<List<Ticket>> var1) {
        for (Long2ObjectMap.Entry var3 : Long2ObjectMaps.fastIterable(var1)) {
            ChunkCoordIntPair var4 = new ChunkCoordIntPair(var3.getLongKey());
            for (Ticket var6 : (List)var3.getValue()) {
                var0.accept(var4, var6);
            }
        }
    }

    public void activateAllDeactivatedTickets() {
        for (Long2ObjectMap.Entry var1 : Long2ObjectMaps.fastIterable(this.deactivatedTickets)) {
            for (Ticket var3 : (List)var1.getValue()) {
                this.addTicket(var1.getLongKey(), var3);
            }
        }
        this.deactivatedTickets.clear();
    }

    public void setLoadingChunkUpdatedListener(@Nullable a var0) {
        this.loadingChunkUpdatedListener = var0;
    }

    public void setSimulationChunkUpdatedListener(@Nullable a var0) {
        this.simulationChunkUpdatedListener = var0;
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    public boolean shouldKeepDimensionActive() {
        for (List var1 : this.tickets.values()) {
            for (Ticket var3 : var1) {
                if (!var3.getType().shouldKeepDimensionActive()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Ticket> getTickets(long var0) {
        return (List)this.tickets.getOrDefault(var0, List.of());
    }

    private List<Ticket> getOrCreateTickets(long var02) {
        return (List)this.tickets.computeIfAbsent(var02, var0 -> new ObjectArrayList(4));
    }

    public void addTicketWithRadius(TicketType var0, ChunkCoordIntPair var1, int var2) {
        Ticket var3 = new Ticket(var0, ChunkLevel.byStatus(FullChunkStatus.FULL) - var2);
        this.addTicket(var1.toLong(), var3);
    }

    public void addTicket(Ticket var0, ChunkCoordIntPair var1) {
        this.addTicket(var1.toLong(), var0);
    }

    public boolean addTicket(long var0, Ticket var2) {
        List<Ticket> var3 = this.getOrCreateTickets(var0);
        for (Ticket var5 : var3) {
            if (!TicketStorage.isTicketSameTypeAndLevel(var2, var5)) continue;
            var5.resetTicksLeft();
            this.setDirty();
            return false;
        }
        int var4 = TicketStorage.getTicketLevelAt(var3, true);
        int var5 = TicketStorage.getTicketLevelAt(var3, false);
        var3.add(var2);
        if (SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
            LOGGER.debug("ATI {} {}", (Object)new ChunkCoordIntPair(var0), (Object)var2);
        }
        if (var2.getType().doesSimulate() && var2.getTicketLevel() < var4 && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(var0, var2.getTicketLevel(), true);
        }
        if (var2.getType().doesLoad() && var2.getTicketLevel() < var5 && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(var0, var2.getTicketLevel(), true);
        }
        if (var2.getType().equals(TicketType.FORCED)) {
            this.chunksWithForcedTickets.add(var0);
        }
        this.setDirty();
        return true;
    }

    private static boolean isTicketSameTypeAndLevel(Ticket var0, Ticket var1) {
        return var1.getType() == var0.getType() && var1.getTicketLevel() == var0.getTicketLevel();
    }

    public int getTicketLevelAt(long var0, boolean var2) {
        return TicketStorage.getTicketLevelAt(this.getTickets(var0), var2);
    }

    private static int getTicketLevelAt(List<Ticket> var0, boolean var1) {
        Ticket var2 = TicketStorage.getLowestTicket(var0, var1);
        return var2 == null ? ChunkLevel.MAX_LEVEL + 1 : var2.getTicketLevel();
    }

    private static @Nullable Ticket getLowestTicket(@Nullable List<Ticket> var0, boolean var1) {
        if (var0 == null) {
            return null;
        }
        Ticket var2 = null;
        for (Ticket var4 : var0) {
            if (var2 != null && var4.getTicketLevel() >= var2.getTicketLevel()) continue;
            if (var1 && var4.getType().doesSimulate()) {
                var2 = var4;
                continue;
            }
            if (var1 || !var4.getType().doesLoad()) continue;
            var2 = var4;
        }
        return var2;
    }

    public void removeTicketWithRadius(TicketType var0, ChunkCoordIntPair var1, int var2) {
        Ticket var3 = new Ticket(var0, ChunkLevel.byStatus(FullChunkStatus.FULL) - var2);
        this.removeTicket(var1.toLong(), var3);
    }

    public void removeTicket(Ticket var0, ChunkCoordIntPair var1) {
        this.removeTicket(var1.toLong(), var0);
    }

    public boolean removeTicket(long var0, Ticket var2) {
        List var3 = (List)this.tickets.get(var0);
        if (var3 == null) {
            return false;
        }
        boolean var4 = false;
        Iterator var5 = var3.iterator();
        while (var5.hasNext()) {
            Ticket var6 = (Ticket)var5.next();
            if (!TicketStorage.isTicketSameTypeAndLevel(var2, var6)) continue;
            var5.remove();
            if (SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
                LOGGER.debug("RTI {} {}", (Object)new ChunkCoordIntPair(var0), (Object)var6);
            }
            var4 = true;
            break;
        }
        if (!var4) {
            return false;
        }
        if (var3.isEmpty()) {
            this.tickets.remove(var0);
        }
        if (var2.getType().doesSimulate() && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(var0, TicketStorage.getTicketLevelAt(var3, true), false);
        }
        if (var2.getType().doesLoad() && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(var0, TicketStorage.getTicketLevelAt(var3, false), false);
        }
        if (var2.getType().equals(TicketType.FORCED)) {
            this.updateForcedChunks();
        }
        this.setDirty();
        return true;
    }

    private void updateForcedChunks() {
        this.chunksWithForcedTickets = this.getAllChunksWithTicketThat(var0 -> var0.getType().equals(TicketType.FORCED));
    }

    public String getTicketDebugString(long var0, boolean var2) {
        List<Ticket> var3 = this.getTickets(var0);
        Ticket var4 = TicketStorage.getLowestTicket(var3, var2);
        return var4 == null ? "no_ticket" : var4.toString();
    }

    public void purgeStaleTickets(PlayerChunkMap var0) {
        this.removeTicketIf((var1, var2) -> {
            if (this.canTicketExpire(var0, var1, var2)) {
                var1.decreaseTicksLeft();
                return var1.isTimedOut();
            }
            return false;
        }, null);
        this.setDirty();
    }

    private boolean canTicketExpire(PlayerChunkMap var0, Ticket var1, long var2) {
        if (!var1.getType().hasTimeout()) {
            return false;
        }
        if (var1.getType().canExpireIfUnloaded()) {
            return true;
        }
        PlayerChunk var4 = var0.getUpdatingChunkIfPresent(var2);
        return var4 == null || var4.isReadyForSaving();
    }

    public void deactivateTicketsOnClosing() {
        this.removeTicketIf((var0, var1) -> var0.getType() != TicketType.UNKNOWN, this.deactivatedTickets);
    }

    public void removeTicketIf(b var0, @Nullable Long2ObjectOpenHashMap<List<Ticket>> var12) {
        ObjectIterator var2 = this.tickets.long2ObjectEntrySet().fastIterator();
        boolean var3 = false;
        while (var2.hasNext()) {
            Long2ObjectMap.Entry var4 = (Long2ObjectMap.Entry)var2.next();
            Iterator var5 = ((List)var4.getValue()).iterator();
            long var6 = var4.getLongKey();
            boolean var8 = false;
            boolean var9 = false;
            while (var5.hasNext()) {
                Ticket var10 = (Ticket)var5.next();
                if (!var0.test(var10, var6)) continue;
                if (var12 != null) {
                    List var11 = (List)var12.computeIfAbsent(var6, var1 -> new ObjectArrayList(((List)var4.getValue()).size()));
                    var11.add(var10);
                }
                var5.remove();
                if (var10.getType().doesLoad()) {
                    var9 = true;
                }
                if (var10.getType().doesSimulate()) {
                    var8 = true;
                }
                if (!var10.getType().equals(TicketType.FORCED)) continue;
                var3 = true;
            }
            if (!var9 && !var8) continue;
            if (var9 && this.loadingChunkUpdatedListener != null) {
                this.loadingChunkUpdatedListener.update(var6, TicketStorage.getTicketLevelAt((List)var4.getValue(), false), false);
            }
            if (var8 && this.simulationChunkUpdatedListener != null) {
                this.simulationChunkUpdatedListener.update(var6, TicketStorage.getTicketLevelAt((List)var4.getValue(), true), false);
            }
            this.setDirty();
            if (!((List)var4.getValue()).isEmpty()) continue;
            var2.remove();
        }
        if (var3) {
            this.updateForcedChunks();
        }
    }

    public void replaceTicketLevelOfType(int var0, TicketType var1) {
        ArrayList<Pair> var2 = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry entry : this.tickets.long2ObjectEntrySet()) {
            for (Ticket var6 : (List)entry.getValue()) {
                if (var6.getType() != var1) continue;
                var2.add(Pair.of((Object)var6, (Object)entry.getLongKey()));
            }
        }
        for (Pair pair : var2) {
            Ticket var6;
            Long var5 = (Long)pair.getSecond();
            var6 = (Ticket)pair.getFirst();
            this.removeTicket(var5, var6);
            TicketType var7 = var6.getType();
            this.addTicket(var5, new Ticket(var7, var0));
        }
    }

    public boolean updateChunkForced(ChunkCoordIntPair var0, boolean var1) {
        Ticket var2 = new Ticket(TicketType.FORCED, PlayerChunkMap.FORCED_TICKET_LEVEL);
        if (var1) {
            return this.addTicket(var0.toLong(), var2);
        }
        return this.removeTicket(var0.toLong(), var2);
    }

    public LongSet getForceLoadedChunks() {
        return this.chunksWithForcedTickets;
    }

    private LongSet getAllChunksWithTicketThat(Predicate<Ticket> var0) {
        LongOpenHashSet var1 = new LongOpenHashSet();
        block0: for (Long2ObjectMap.Entry var3 : Long2ObjectMaps.fastIterable(this.tickets)) {
            for (Ticket var5 : (List)var3.getValue()) {
                if (!var0.test(var5)) continue;
                var1.add(var3.getLongKey());
                continue block0;
            }
        }
        return var1;
    }

    @FunctionalInterface
    public static interface a {
        public void update(long var1, int var3, boolean var4);
    }

    public static interface b {
        public boolean test(Ticket var1, long var2);
    }
}

