/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.lang.runtime.SwitchBootstraps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public interface Explosion {
    public static DamageSource getDefaultDamageSource(World var0, @Nullable Entity var1) {
        return var0.damageSources().explosion(var1, Explosion.getIndirectSourceEntity(var1));
    }

    public static @Nullable EntityLiving getIndirectSourceEntity(@Nullable Entity var0) {
        EntityLiving entityLiving;
        Entity entity = var0;
        int n2 = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityTNTPrimed.class, EntityLiving.class, IProjectile.class}, (Object)entity, n2)) {
                case 0: {
                    EntityTNTPrimed var3 = (EntityTNTPrimed)entity;
                    entityLiving = var3.getOwner();
                    break block5;
                }
                case 1: {
                    EntityLiving var4;
                    entityLiving = var4 = (EntityLiving)entity;
                    break block5;
                }
                case 2: {
                    IProjectile var5 = (IProjectile)entity;
                    Entity entity2 = var5.getOwner();
                    if (!(entity2 instanceof EntityLiving)) {
                        n2 = 3;
                        continue block5;
                    }
                    EntityLiving var6 = (EntityLiving)entity2;
                    entityLiving = var6;
                    break block5;
                }
                default: {
                    entityLiving = null;
                    break block5;
                }
            }
            break;
        }
        return entityLiving;
    }

    public WorldServer level();

    public Effect getBlockInteraction();

    public @Nullable EntityLiving getIndirectSourceEntity();

    public @Nullable Entity getDirectSourceEntity();

    public float radius();

    public Vec3D center();

    public boolean canTriggerBlocks();

    public boolean shouldAffectBlocklikeEntities();

    public static final class Effect
    extends Enum<Effect> {
        public static final /* enum */ Effect KEEP = new Effect(false);
        public static final /* enum */ Effect DESTROY = new Effect(true);
        public static final /* enum */ Effect DESTROY_WITH_DECAY = new Effect(true);
        public static final /* enum */ Effect TRIGGER_BLOCK = new Effect(false);
        private final boolean shouldAffectBlocklikeEntities;
        private static final /* synthetic */ Effect[] f;

        public static Effect[] values() {
            return (Effect[])f.clone();
        }

        public static Effect valueOf(String var0) {
            return Enum.valueOf(Effect.class, var0);
        }

        private Effect(boolean var2) {
            this.shouldAffectBlocklikeEntities = var2;
        }

        public boolean shouldAffectBlocklikeEntities() {
            return this.shouldAffectBlocklikeEntities;
        }

        private static /* synthetic */ Effect[] b() {
            return new Effect[]{KEEP, DESTROY, DESTROY_WITH_DECAY, TRIGGER_BLOCK};
        }

        static {
            f = Effect.b();
        }
    }
}

