/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantRecipe;
import org.jspecify.annotations.Nullable;

public class MerchantRecipeList
extends ArrayList<MerchantRecipe> {
    public static final Codec<MerchantRecipeList> CODEC = MerchantRecipe.CODEC.listOf().optionalFieldOf("Recipes", List.of()).xmap(MerchantRecipeList::new, Function.identity()).codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, MerchantRecipeList> STREAM_CODEC = MerchantRecipe.STREAM_CODEC.apply(ByteBufCodecs.collection(MerchantRecipeList::new));

    public MerchantRecipeList() {
    }

    private MerchantRecipeList(int var0) {
        super(var0);
    }

    private MerchantRecipeList(Collection<MerchantRecipe> var0) {
        super(var0);
    }

    public @Nullable MerchantRecipe getRecipeFor(ItemStack var0, ItemStack var1, int var2) {
        if (var2 > 0 && var2 < this.size()) {
            MerchantRecipe var3 = (MerchantRecipe)this.get(var2);
            if (var3.satisfiedBy(var0, var1)) {
                return var3;
            }
            return null;
        }
        for (int var3 = 0; var3 < this.size(); ++var3) {
            MerchantRecipe var4 = (MerchantRecipe)this.get(var3);
            if (!var4.satisfiedBy(var0, var1)) continue;
            return var4;
        }
        return null;
    }

    public MerchantRecipeList copy() {
        MerchantRecipeList var0 = new MerchantRecipeList(this.size());
        for (MerchantRecipe var2 : this) {
            var0.add(var2.copy());
        }
        return var0;
    }
}

