/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment.trim;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public class TrimMaterials {
    public static final ResourceKey<TrimMaterial> QUARTZ = TrimMaterials.registryKey("quartz");
    public static final ResourceKey<TrimMaterial> IRON = TrimMaterials.registryKey("iron");
    public static final ResourceKey<TrimMaterial> NETHERITE = TrimMaterials.registryKey("netherite");
    public static final ResourceKey<TrimMaterial> REDSTONE = TrimMaterials.registryKey("redstone");
    public static final ResourceKey<TrimMaterial> COPPER = TrimMaterials.registryKey("copper");
    public static final ResourceKey<TrimMaterial> GOLD = TrimMaterials.registryKey("gold");
    public static final ResourceKey<TrimMaterial> EMERALD = TrimMaterials.registryKey("emerald");
    public static final ResourceKey<TrimMaterial> DIAMOND = TrimMaterials.registryKey("diamond");
    public static final ResourceKey<TrimMaterial> LAPIS = TrimMaterials.registryKey("lapis");
    public static final ResourceKey<TrimMaterial> AMETHYST = TrimMaterials.registryKey("amethyst");
    public static final ResourceKey<TrimMaterial> RESIN = TrimMaterials.registryKey("resin");

    public static void bootstrap(BootstrapContext<TrimMaterial> var0) {
        TrimMaterials.register(var0, QUARTZ, ChatModifier.EMPTY.withColor(14931140), MaterialAssetGroup.QUARTZ);
        TrimMaterials.register(var0, IRON, ChatModifier.EMPTY.withColor(0xECECEC), MaterialAssetGroup.IRON);
        TrimMaterials.register(var0, NETHERITE, ChatModifier.EMPTY.withColor(6445145), MaterialAssetGroup.NETHERITE);
        TrimMaterials.register(var0, REDSTONE, ChatModifier.EMPTY.withColor(9901575), MaterialAssetGroup.REDSTONE);
        TrimMaterials.register(var0, COPPER, ChatModifier.EMPTY.withColor(11823181), MaterialAssetGroup.COPPER);
        TrimMaterials.register(var0, GOLD, ChatModifier.EMPTY.withColor(14594349), MaterialAssetGroup.GOLD);
        TrimMaterials.register(var0, EMERALD, ChatModifier.EMPTY.withColor(1155126), MaterialAssetGroup.EMERALD);
        TrimMaterials.register(var0, DIAMOND, ChatModifier.EMPTY.withColor(7269586), MaterialAssetGroup.DIAMOND);
        TrimMaterials.register(var0, LAPIS, ChatModifier.EMPTY.withColor(4288151), MaterialAssetGroup.LAPIS);
        TrimMaterials.register(var0, AMETHYST, ChatModifier.EMPTY.withColor(10116294), MaterialAssetGroup.AMETHYST);
        TrimMaterials.register(var0, RESIN, ChatModifier.EMPTY.withColor(16545810), MaterialAssetGroup.RESIN);
    }

    public static Optional<Holder<TrimMaterial>> getFromIngredient(HolderLookup.a var0, ItemStack var1) {
        ProvidesTrimMaterial var2 = var1.get(DataComponents.PROVIDES_TRIM_MATERIAL);
        return var2 != null ? var2.unwrap(var0) : Optional.empty();
    }

    private static void register(BootstrapContext<TrimMaterial> var0, ResourceKey<TrimMaterial> var1, ChatModifier var2, MaterialAssetGroup var3) {
        IChatMutableComponent var4 = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("trim_material", var1.identifier())).withStyle(var2);
        var0.register(var1, new TrimMaterial(var3, var4));
    }

    private static ResourceKey<TrimMaterial> registryKey(String var0) {
        return ResourceKey.create(Registries.TRIM_MATERIAL, MinecraftKey.withDefaultNamespace(var0));
    }
}

