/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.World;
import org.jspecify.annotations.Nullable;

public class ShapelessRecipes
implements RecipeCrafting {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final List<RecipeItemStack> ingredients;
    private @Nullable PlacementInfo placementInfo;

    public ShapelessRecipes(String var0, CraftingBookCategory var1, ItemStack var2, List<RecipeItemStack> var3) {
        this.group = var0;
        this.category = var1;
        this.result = var2;
        this.ingredients = var3;
    }

    @Override
    public RecipeSerializer<ShapelessRecipes> getSerializer() {
        return RecipeSerializer.SHAPELESS_RECIPE;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.ingredients);
        }
        return this.placementInfo;
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        if (var0.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (var0.size() == 1 && this.ingredients.size() == 1) {
            return this.ingredients.getFirst().test(var0.getItem(0));
        }
        return var0.stackedContents().canCraft(this, null);
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        return this.result.copy();
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.ingredients.stream().map(RecipeItemStack::display).toList(), new SlotDisplay.f(this.result), new SlotDisplay.d(Items.CRAFTING_TABLE)));
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        private static final MapCodec<ShapelessRecipes> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(var0 -> var0.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(var0 -> var0.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(var0 -> var0.result), (App)RecipeItemStack.CODEC.listOf(1, 9).fieldOf("ingredients").forGetter(var0 -> var0.ingredients)).apply((Applicative)var02, ShapelessRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, var0 -> var0.group, CraftingBookCategory.STREAM_CODEC, var0 -> var0.category, ItemStack.STREAM_CODEC, var0 -> var0.result, RecipeItemStack.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), var0 -> var0.ingredients, ShapelessRecipes::new);

        @Override
        public MapCodec<ShapelessRecipes> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

